/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.output;

import java.io.File;
import java.net.MalformedURLException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.netbeans.modules.maven.output.Bundle;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class SiteOutputProcessor
implements OutputProcessor {
    private static final String[] SITEGOALS = new String[]{"mojo-execute#site:site"};
    private Project project;

    public SiteOutputProcessor(Project prj) {
        this.project = prj;
    }

    @Override
    public String[] getRegisteredOutputSequences() {
        return SITEGOALS;
    }

    @Override
    public void processLine(String line, OutputVisitor visitor) {
    }

    @Override
    public void sequenceStart(String sequenceId, OutputVisitor visitor) {
    }

    @Override
    public void sequenceEnd(String sequenceId, OutputVisitor visitor) {
        if ("mojo-execute#site:site".equals(sequenceId)) {
            visitor.setLine("     View Generated Project Site");
            OutputVisitor.Context con = visitor.getContext();
            if (con != null && con.getCurrentProject() != null) {
                visitor.setOutputListener(new Listener(con.getCurrentProject()), false);
            } else {
                visitor.setOutputListener(new Listener(this.project), false);
            }
        }
    }

    @Override
    public void sequenceFail(String sequenceId, OutputVisitor visitor) {
    }

    private static class Listener
    implements OutputListener {
        private final Project prj;

        private Listener(Project prj) {
            this.prj = prj;
        }

        public void outputLineAction(OutputEvent arg0) {
            File html = new File(FileUtil.toFile((FileObject)this.prj.getProjectDirectory()), "target/site/index.html");
            if (html.isFile()) {
                try {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(Utilities.toURI((File)html).toURL());
                }
                catch (MalformedURLException x) {
                    assert (false) : x;
                }
            } else {
                StatusDisplayer.getDefault().setStatusText(Bundle.SiteOutputProcessor_not_found(html));
            }
        }
    }
}

