/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.lucene.support;

import java.io.IOException;
import java.util.BitSet;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.PrefixTermEnum;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.OpenBitSet;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.parsing.lucene.TermCollector;
import org.openide.util.Pair;
import org.openide.util.Parameters;

public final class Queries {
    public static final String OPTION_CAMEL_CASE_SEPARATOR = "camelCaseSeparator";
    public static final String OPTION_CAMEL_CASE_PART = "camelCasePart";
    private static final String DEFAULT_CAMEL_CASE_SEPARATOR = "\\p{javaUpperCase}";
    private static final String DEFAULT_CAMEL_CASE_PART_CASE_SENSITIVE = "\\p{javaLowerCase}|\\p{Digit}|_|\\.|\\$";
    private static final String DEFAULT_CAMEL_CASE_PART_CASE_INSENSITIVE = "\\p{javaLowerCase}|\\p{Digit}|\\p{javaUpperCase}|_|\\.|\\$";
    private static final String CAMEL_CASE_FORMAT = "(.(?:%s)*)(?:(?:%s)(?:%s)*){1,}";
    private static final Pattern DEFAULT_CAMEL_CASE_PATTERN = Pattern.compile(String.format("(.(?:%s)*)(?:(?:%s)(?:%s)*){1,}", "\\p{javaLowerCase}|\\p{Digit}|_|\\.|\\$", "\\p{javaUpperCase}", "\\p{javaLowerCase}|\\p{Digit}|_|\\.|\\$"));
    private static volatile Pair<Pair<String, String>, Pattern> cache;

    @NonNull
    public static Query createQuery(@NonNull String fieldName, @NonNull String caseInsensitiveFieldName, @NonNull String value, @NonNull QueryKind kind) {
        return Queries.createQuery(fieldName, caseInsensitiveFieldName, value, kind, Collections.emptyMap());
    }

    @NonNull
    public static Query createQuery(@NonNull String fieldName, @NonNull String caseInsensitiveFieldName, @NonNull String value, @NonNull QueryKind kind, @NonNull Map<String, Object> options) {
        Parameters.notNull((CharSequence)"fieldName", (Object)fieldName);
        Parameters.notNull((CharSequence)"caseInsensitiveFieldName", (Object)caseInsensitiveFieldName);
        Parameters.notNull((CharSequence)"value", (Object)value);
        Parameters.notNull((CharSequence)"kind", (Object)((Object)kind));
        Parameters.notNull((CharSequence)"options", options);
        return Queries.createQueryImpl(fieldName, caseInsensitiveFieldName, value, kind, new StandardQueryFactory(), options);
    }

    @NonNull
    public static Query createTermCollectingQuery(@NonNull String fieldName, @NonNull String caseInsensitiveFieldName, @NonNull String value, @NonNull QueryKind kind) {
        return Queries.createTermCollectingQuery(fieldName, caseInsensitiveFieldName, value, kind, Collections.emptyMap());
    }

    @NonNull
    public static Query createTermCollectingQuery(@NonNull String fieldName, @NonNull String caseInsensitiveFieldName, @NonNull String value, @NonNull QueryKind kind, @NonNull Map<String, Object> options) {
        Parameters.notNull((CharSequence)"fieldName", (Object)fieldName);
        Parameters.notNull((CharSequence)"caseInsensitiveFieldName", (Object)caseInsensitiveFieldName);
        Parameters.notNull((CharSequence)"value", (Object)value);
        Parameters.notNull((CharSequence)"kind", (Object)((Object)kind));
        Parameters.notNull((CharSequence)"options", options);
        return Queries.createQueryImpl(fieldName, caseInsensitiveFieldName, value, kind, new TCQueryFactory(), options);
    }

    public static FieldSelector createFieldSelector(String ... fieldsToLoad) {
        return new FieldSelectorImpl(fieldsToLoad);
    }

    public static boolean isCamelCase(@NonNull String value, @NullAllowed String separatorRegExp, @NullAllowed String partRegExp) {
        Pattern p;
        if (separatorRegExp == null && partRegExp == null) {
            return DEFAULT_CAMEL_CASE_PATTERN.matcher(value).matches();
        }
        Pair<Pair<String, String>, Pattern> val = cache;
        if (val != null && Objects.equals(separatorRegExp, ((Pair)val.first()).first()) && Objects.equals(partRegExp, ((Pair)val.first()).second())) {
            p = (Pattern)val.second();
        } else {
            if (separatorRegExp == null) {
                separatorRegExp = DEFAULT_CAMEL_CASE_SEPARATOR;
            }
            if (partRegExp == null) {
                partRegExp = DEFAULT_CAMEL_CASE_PART_CASE_SENSITIVE;
            }
            p = Pattern.compile(String.format(CAMEL_CASE_FORMAT, partRegExp, separatorRegExp, partRegExp));
            cache = Pair.of((Object)Pair.of((Object)separatorRegExp, (Object)partRegExp), (Object)p);
        }
        return p.matcher(value).matches();
    }

    @NonNull
    public static String createCamelCaseRegExp(@NonNull String value, @NullAllowed String separatorRegExp, @NullAllowed String partRegExp, boolean caseSensitive) {
        int index;
        StringBuilder sb = new StringBuilder();
        Pattern separator = separatorRegExp == null ? null : Pattern.compile(separatorRegExp);
        Object[] objectArray = new Object[1];
        objectArray[0] = partRegExp == null ? (caseSensitive ? DEFAULT_CAMEL_CASE_PART_CASE_SENSITIVE : DEFAULT_CAMEL_CASE_PART_CASE_INSENSITIVE) : partRegExp;
        String part = String.format("(%s)*", objectArray);
        int lastIndex = 0;
        do {
            index = separator == null ? Queries.findNextUpper(value, lastIndex + 1) : Queries.findNextSeparator(value, lastIndex + 1, separator);
            String token = value.substring(lastIndex, index == -1 ? value.length() : index);
            sb.append(Pattern.quote(caseSensitive ? token : token.toLowerCase()));
            sb.append(index != -1 ? part : ".*");
            lastIndex = index;
        } while (index != -1);
        return sb.toString();
    }

    private static Query createQueryImpl(@NonNull String fieldName, @NonNull String caseInsensitiveFieldName, @NonNull String value, @NonNull QueryKind kind, @NonNull QueryFactory f, @NonNull Map<String, Object> options) {
        switch (kind.ordinal()) {
            case 0: {
                return f.createTermQuery(fieldName, value);
            }
            case 1: {
                if (value.length() == 0) {
                    return f.createAllDocsQuery(fieldName);
                }
                return f.createPrefixQuery(fieldName, value);
            }
            case 2: {
                if (value.length() == 0) {
                    return f.createAllDocsQuery(caseInsensitiveFieldName);
                }
                return f.createPrefixQuery(caseInsensitiveFieldName, value.toLowerCase());
            }
            case 3: {
                if (value.length() == 0) {
                    throw new IllegalArgumentException();
                }
                return f.createRegExpQuery(fieldName, Queries.createCamelCaseRegExp(value, Queries.getOption(options, OPTION_CAMEL_CASE_SEPARATOR, String.class), Queries.getOption(options, OPTION_CAMEL_CASE_PART, String.class), true), true);
            }
            case 6: {
                if (value.length() == 0) {
                    throw new IllegalArgumentException();
                }
                return f.createRegExpQuery(caseInsensitiveFieldName, value.toLowerCase(), false);
            }
            case 5: {
                if (value.length() == 0) {
                    throw new IllegalArgumentException();
                }
                return f.createRegExpQuery(fieldName, value, true);
            }
            case 4: {
                if (value.length() == 0) {
                    return f.createAllDocsQuery(caseInsensitiveFieldName);
                }
                return f.createRegExpQuery(caseInsensitiveFieldName, Queries.createCamelCaseRegExp(value, Queries.getOption(options, OPTION_CAMEL_CASE_SEPARATOR, String.class), Queries.getOption(options, OPTION_CAMEL_CASE_PART, String.class), false), false);
            }
        }
        throw new UnsupportedOperationException(kind.toString());
    }

    @CheckForNull
    private static <T> T getOption(@NonNull Map<String, Object> options, @NonNull String key, @NonNull Class<T> clz) {
        Object val = options.get(key);
        return clz.isInstance(val) ? (T)clz.cast(val) : null;
    }

    private static int findNextUpper(String text, int offset) {
        for (int i = offset; i < text.length(); ++i) {
            if (!Character.isUpperCase(text.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private static int findNextSeparator(@NonNull String text, int offset, @NonNull Pattern separator) {
        Matcher m = separator.matcher(text);
        if (m.find(offset)) {
            return m.start();
        }
        return -1;
    }

    private Queries() {
    }

    public static enum QueryKind {
        EXACT,
        PREFIX,
        CASE_INSENSITIVE_PREFIX,
        CAMEL_CASE,
        CASE_INSENSITIVE_CAMEL_CASE,
        REGEXP,
        CASE_INSENSITIVE_REGEXP;

    }

    private static class StandardQueryFactory
    implements QueryFactory {
        private StandardQueryFactory() {
        }

        @Override
        public Query createTermQuery(@NonNull String name, @NonNull String value) {
            return new TermQuery(new Term(name, value));
        }

        @Override
        public Query createPrefixQuery(@NonNull String name, @NonNull String value) {
            PrefixQuery pq = new PrefixQuery(new Term(name, value));
            pq.setRewriteMethod(PrefixQuery.CONSTANT_SCORE_FILTER_REWRITE);
            return pq;
        }

        @Override
        public Query createRegExpQuery(@NonNull String name, @NonNull String value, boolean caseSensitive) {
            return new FilteredQuery((Query)new MatchAllDocsQuery(), (Filter)new RegexpFilter(name, value, caseSensitive));
        }

        @Override
        public Query createAllDocsQuery(@NonNull String name) {
            if (name.length() == 0) {
                return new MatchAllDocsQuery();
            }
            return new FilteredQuery((Query)new MatchAllDocsQuery(), (Filter)new HasFieldFilter(name));
        }

        @Override
        public BooleanQuery createBooleanQuery() {
            return new BooleanQuery();
        }
    }

    private static interface QueryFactory {
        public Query createTermQuery(@NonNull String var1, @NonNull String var2);

        public Query createPrefixQuery(@NonNull String var1, @NonNull String var2);

        public Query createRegExpQuery(@NonNull String var1, @NonNull String var2, boolean var3);

        public Query createAllDocsQuery(@NonNull String var1);

        public BooleanQuery createBooleanQuery();
    }

    private static class TCQueryFactory
    implements QueryFactory {
        private TCQueryFactory() {
        }

        @Override
        public Query createTermQuery(@NonNull String name, @NonNull String value) {
            return new TCFilteredQuery((Query)new MatchAllDocsQuery(), new TermFilter(name, value));
        }

        @Override
        public Query createPrefixQuery(@NonNull String name, @NonNull String value) {
            return new TCFilteredQuery((Query)new MatchAllDocsQuery(), new PrefixFilter(name, value));
        }

        @Override
        public Query createRegExpQuery(@NonNull String name, @NonNull String value, boolean caseSensitive) {
            return new TCFilteredQuery((Query)new MatchAllDocsQuery(), new RegexpFilter(name, value, caseSensitive));
        }

        @Override
        public Query createAllDocsQuery(@NonNull String name) {
            throw new IllegalArgumentException();
        }

        @Override
        public BooleanQuery createBooleanQuery() {
            return new TCBooleanQuery();
        }
    }

    private static class FieldSelectorImpl
    implements FieldSelector {
        private final Term[] terms;

        FieldSelectorImpl(String ... fieldNames) {
            this.terms = new Term[fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                this.terms[i] = new Term(fieldNames[i], "");
            }
        }

        public FieldSelectorResult accept(String fieldName) {
            for (Term t : this.terms) {
                if (fieldName != t.field()) continue;
                return FieldSelectorResult.LOAD;
            }
            return FieldSelectorResult.NO_LOAD;
        }
    }

    private static class TCBooleanQuery
    extends BooleanQuery
    implements TermCollector.TermCollecting {
        private TermCollector collector;

        private TCBooleanQuery() {
        }

        @Override
        public void attach(TermCollector collector) {
            this.collector = collector;
            if (this.collector != null) {
                TCBooleanQuery.attach(this, this.collector);
            }
        }

        public Query rewrite(IndexReader reader) throws IOException {
            Query result = super.rewrite(reader);
            if (this.collector != null) {
                TCBooleanQuery.attach(this, this.collector);
            }
            return result;
        }

        private static void attach(BooleanQuery query, TermCollector collector) {
            for (BooleanClause clause : query.getClauses()) {
                Query q = clause.getQuery();
                if (!(q instanceof TermCollector.TermCollecting)) {
                    throw new IllegalArgumentException();
                }
                ((TermCollector.TermCollecting)q).attach(collector);
            }
        }
    }

    private static class TCFilteredQuery
    extends FilteredQuery
    implements TermCollector.TermCollecting {
        private TCFilteredQuery(Query query, TCFilter filter) {
            super(query, (Filter)filter);
        }

        @Override
        public void attach(TermCollector collector) {
            ((TCFilter)this.getFilter()).attach(collector);
        }
    }

    private static class HasFieldFilter
    extends PrefixFilter {
        public HasFieldFilter(String fieldName) {
            super(fieldName, "");
        }

        @Override
        protected FilteredTermEnum getTermEnum(IndexReader reader) throws IOException {
            return new PrefixTermEnum(reader, this.term){
                private boolean endEnum;

                protected boolean termCompare(Term term) {
                    if (term.field() == term.field()) {
                        return true;
                    }
                    this.endEnum = true;
                    return false;
                }

                protected boolean endEnum() {
                    return this.endEnum;
                }
            };
        }
    }

    private static class TermFilter
    extends PrefixFilter {
        public TermFilter(String fieldName, String value) {
            super(fieldName, value);
        }

        @Override
        protected FilteredTermEnum getTermEnum(IndexReader reader) throws IOException {
            return new PrefixTermEnum(reader, this.term){
                private boolean endEnum;

                protected boolean termCompare(Term term) {
                    if (term.field() == term.field() && term.text().equals(term.text())) {
                        return true;
                    }
                    this.endEnum = true;
                    return false;
                }

                protected boolean endEnum() {
                    return this.endEnum;
                }
            };
        }
    }

    private static class PrefixFilter
    extends AbstractTCFilter {
        protected final Term term;

        public PrefixFilter(@NonNull String fieldName, @NonNull String prefix) {
            this.term = new Term(fieldName, prefix);
        }

        @Override
        protected FilteredTermEnum getTermEnum(@NonNull IndexReader reader) throws IOException {
            return new PrefixTermEnum(reader, this.term);
        }
    }

    static class RegexpFilter
    extends AbstractTCFilter {
        private static final BitSet SPECIAL_CHARS;
        private static final BitSet QUANTIFIER_CHARS;
        private final String fieldName;
        private final String startPrefix;
        private final Pattern pattern;

        public RegexpFilter(String fieldName, String regexp, boolean caseSensitive) {
            this.fieldName = fieldName;
            this.pattern = caseSensitive ? Pattern.compile(regexp) : Pattern.compile(regexp, 2);
            this.startPrefix = RegexpFilter.getStartText(regexp);
        }

        @Override
        protected FilteredTermEnum getTermEnum(@NonNull IndexReader reader) throws IOException {
            return new RegexpTermEnum(reader, this.fieldName, this.pattern, this.startPrefix);
        }

        private static String getStartText(String regexp) {
            StringBuilder startBuilder = new StringBuilder();
            boolean quoted = false;
            for (int i = 0; i < regexp.length(); ++i) {
                char lookAhead;
                char c = regexp.charAt(i);
                if (!quoted && i < regexp.length() - 1 && QUANTIFIER_CHARS.get(lookAhead = regexp.charAt(i + 1))) break;
                if (c == '\\' && i + 1 < regexp.length()) {
                    char cn = regexp.charAt(i + 1);
                    if (!quoted && cn == 'Q') {
                        quoted = true;
                        ++i;
                        continue;
                    }
                    if (cn == 'E') {
                        quoted = false;
                        ++i;
                        continue;
                    }
                } else if (!quoted && (c == '^' || c == '$')) continue;
                if (!quoted && SPECIAL_CHARS.get(c)) break;
                startBuilder.append(c);
            }
            return startBuilder.toString();
        }

        static {
            char[] specials;
            SPECIAL_CHARS = new BitSet(126);
            for (char c : specials = new char[]{'{', '}', '[', ']', '(', ')', '\\', '.', '*', '?', '+'}) {
                SPECIAL_CHARS.set(c);
            }
            QUANTIFIER_CHARS = new BitSet(126);
            for (char c : specials = new char[]{'{', '*', '?'}) {
                QUANTIFIER_CHARS.set(c);
            }
        }
    }

    private static class RegexpTermEnum
    extends FilteredTermEnum {
        private final String fieldName;
        private final String startPrefix;
        private final Pattern pattern;
        private boolean endEnum;

        public RegexpTermEnum(IndexReader in, String fieldName, Pattern pattern, String startPrefix) throws IOException {
            Term term = new Term(fieldName, startPrefix);
            this.fieldName = term.field();
            this.pattern = pattern;
            this.startPrefix = startPrefix;
            this.setEnum(in.terms(term));
        }

        protected boolean termCompare(Term term) {
            String searchText;
            if (this.fieldName == term.field() && (searchText = term.text()).startsWith(this.startPrefix)) {
                return this.pattern.matcher(term.text()).matches();
            }
            this.endEnum = true;
            return false;
        }

        public float difference() {
            return 1.0f;
        }

        protected boolean endEnum() {
            return this.endEnum;
        }
    }

    private static abstract class AbstractTCFilter
    extends TCFilter {
        private TermCollector termCollector;

        private AbstractTCFilter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final DocIdSet getDocIdSet(IndexReader reader) throws IOException {
            FilteredTermEnum enumerator = this.getTermEnum(reader);
            if (enumerator.term() == null) {
                return DocIdSet.EMPTY_DOCIDSET;
            }
            try {
                OpenBitSet bitSet = new OpenBitSet((long)reader.maxDoc());
                int[] docs = new int[32];
                int[] freqs = new int[32];
                try (TermDocs termDocs = reader.termDocs();){
                    do {
                        int count;
                        Term term;
                        if ((term = enumerator.term()) == null) {
                            break;
                        }
                        termDocs.seek(term);
                        while ((count = termDocs.read(docs, freqs)) != 0) {
                            for (int i = 0; i < count; ++i) {
                                bitSet.set((long)docs[i]);
                                if (this.termCollector == null) continue;
                                this.termCollector.add(docs[i], term);
                            }
                        }
                    } while (enumerator.next());
                }
                OpenBitSet openBitSet = bitSet;
                return openBitSet;
            }
            finally {
                enumerator.close();
            }
        }

        @Override
        public final void attach(TermCollector tc) {
            this.termCollector = tc;
        }

        protected abstract FilteredTermEnum getTermEnum(IndexReader var1) throws IOException;
    }

    private static abstract class TCFilter
    extends Filter {
        private TCFilter() {
        }

        public abstract void attach(TermCollector var1);
    }
}

