/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.beans.CdiUtil;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.JSFUtils;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.editor.JSFBeanCache;
import org.netbeans.modules.web.jsf.api.facesmodel.Description;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigModel;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.netbeans.modules.web.jsf.api.metamodel.FacesManagedBean;
import org.netbeans.modules.web.jsf.impl.facesmodel.JSFConfigModelUtilities;
import org.netbeans.modules.web.jsf.wizards.ManagedBeanPanel;
import org.netbeans.modules.web.wizards.Utilities;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class ManagedBeanIterator
implements TemplateWizard.Iterator {
    private int index;
    private ManagedBeanPanel managedBeanPanel;
    private transient WizardDescriptor.Panel[] panels;
    private static final Map<ManagedBean.Scope, String> FACES_SCOPE = new EnumMap<ManagedBean.Scope, String>(ManagedBean.Scope.class);
    private static final Map<NamedScope, String> NAMED_SCOPE;

    public void initialize(TemplateWizard wizard) {
        WizardDescriptor.Panel javaPanel;
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)wizard);
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        this.managedBeanPanel = new ManagedBeanPanel(project, wizard);
        if (sourceGroups.length == 0) {
            wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ManagedBeanIterator.class, (String)"MSG_No_Sources_found"));
            javaPanel = this.managedBeanPanel;
        } else {
            javaPanel = JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroups, (WizardDescriptor.Panel)this.managedBeanPanel);
            javaPanel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ManagedBeanIterator.this.managedBeanPanel.updateManagedBeanName((WizardDescriptor.Panel)e.getSource());
                }
            });
        }
        this.panels = new WizardDescriptor.Panel[]{javaPanel};
        Object prop = wizard.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            JComponent jc = (JComponent)this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = jc.getName();
            }
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(TemplateWizard wizard) {
        this.panels = null;
    }

    public Set instantiate(TemplateWizard wizard) throws IOException {
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)wizard);
        DataFolder df = DataFolder.findFolder((FileObject)dir);
        FileObject template = Templates.getTemplate((WizardDescriptor)wizard);
        DataObject dTemplate = DataObject.find((FileObject)template);
        String configFile = (String)wizard.getProperty("ConfigFile");
        Project project = Templates.getProject((WizardDescriptor)wizard);
        WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        dir = wm.getDocumentBase();
        if (configFile == null && !JSFConfigUtilities.hasJsfFramework(dir)) {
            JSFConfigUtilities.extendJsfFramework(dir, false);
        }
        String beanName = this.getUniqueName((String)wizard.getProperty("Name"), project);
        Object scope = wizard.getProperty("Scope");
        boolean isAnnotate = !this.managedBeanPanel.isAddBeanToConfig();
        DataObject dobj = null;
        if (isAnnotate && (Utilities.isJavaEE6Plus((TemplateWizard)wizard) || JSFUtils.isJSF20Plus(wm, true) && JSFUtils.isJavaEE5(wizard))) {
            boolean isCdiEnabled;
            boolean jakartaJsfPackages;
            HashMap<String, Object> templateProperties = new HashMap<String, Object>();
            String targetName = Templates.getTargetName((WizardDescriptor)wizard);
            if (JSFUtils.isJakartaEE9Plus(wizard)) {
                templateProperties.put("jakartaJsfPackages", true);
                jakartaJsfPackages = true;
            } else {
                templateProperties.put("jakartaJsfPackages", false);
                jakartaJsfPackages = false;
            }
            CdiUtil cdiUtil = (CdiUtil)project.getLookup().lookup(CdiUtil.class);
            boolean bl = isCdiEnabled = cdiUtil != null && cdiUtil.isCdiEnabled();
            if (isCdiEnabled) {
                templateProperties.put("cdiEnabled", true);
                templateProperties.put("classAnnotation", "@Named(value=\"" + beanName + "\")");
                templateProperties.put("scope", ScopeEntry.getFor(scope, jakartaJsfPackages));
                NamedScope namedScope = (NamedScope)((Object)scope);
                switch (namedScope.ordinal()) {
                    case 3: 
                    case 4: 
                    case 6: {
                        templateProperties.put("passivationCapable", "true");
                        break;
                    }
                }
            } else {
                if (targetName.equalsIgnoreCase(beanName) && targetName.substring(0, 1).equalsIgnoreCase(beanName.substring(0, 1))) {
                    templateProperties.put("classAnnotation", "@ManagedBean");
                } else {
                    templateProperties.put("classAnnotation", "@ManagedBean(name=\"" + beanName + "\")");
                }
                templateProperties.put("scope", ScopeEntry.getFor(scope, jakartaJsfPackages));
            }
            dobj = dTemplate.createFromTemplate(df, targetName, templateProperties);
        } else {
            FileObject fo = dir.getFileObject(configFile);
            JSFConfigModel configModel = ConfigurationUtils.getConfigModel(fo, true);
            final FacesConfig facesConfig = configModel.getRootComponent();
            dobj = dTemplate.createFromTemplate(df, Templates.getTargetName((WizardDescriptor)wizard));
            final ManagedBean bean = configModel.getFactory().createManagedBean();
            String targetName = Templates.getTargetName((WizardDescriptor)wizard);
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] groups = sources.getSourceGroups("java");
            String packageName = null;
            FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)wizard);
            for (int i = 0; i < groups.length && packageName == null && (packageName = FileUtil.getRelativePath((FileObject)groups[i].getRootFolder(), (FileObject)targetFolder)) == null; ++i) {
            }
            packageName = packageName != null ? packageName.replace('/', '.') : "";
            String className = null;
            className = packageName.length() > 0 ? packageName + "." + targetName : targetName;
            bean.setManagedBeanName(beanName);
            bean.setManagedBeanClass(className);
            if (scope == null) {
                scope = ManagedBean.Scope.REQUEST;
            }
            bean.setManagedBeanScope((ManagedBean.Scope)((Object)scope));
            String description = (String)wizard.getProperty("Description");
            if (description != null && description.length() > 0) {
                Description beanDescription = bean.getModel().getFactory().createDescription();
                beanDescription.setValue(description);
                bean.addDescription(beanDescription);
            }
            JSFConfigModelUtilities.doInTransaction(configModel, new Runnable(){
                final /* synthetic */ ManagedBeanIterator this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    facesConfig.addManagedBean(bean);
                }
            });
            JSFConfigModelUtilities.saveChanges(configModel);
        }
        return Collections.singleton(dobj);
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public String name() {
        return NbBundle.getMessage(ManagedBeanIterator.class, (String)"TITLE_x_of_y", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    private String getUniqueName(String original, Project project) {
        String value = original;
        int count = 0;
        for (FacesManagedBean managedBean : JSFBeanCache.getBeans(project)) {
            if (!value.equals(managedBean.getManagedBeanName())) continue;
            value = original + ++count;
        }
        return value;
    }

    static {
        FACES_SCOPE.put(ManagedBean.Scope.APPLICATION, "ApplicationScoped");
        FACES_SCOPE.put(ManagedBean.Scope.NONE, "NoneScoped");
        FACES_SCOPE.put(ManagedBean.Scope.REQUEST, "RequestScoped");
        FACES_SCOPE.put(ManagedBean.Scope.SESSION, "SessionScoped");
        FACES_SCOPE.put(ManagedBean.Scope.VIEW, "ViewScoped");
        NAMED_SCOPE = new EnumMap<NamedScope, String>(NamedScope.class);
        NAMED_SCOPE.put(NamedScope.DEPENDENT, "Dependent");
        NAMED_SCOPE.put(NamedScope.APPLICATION, "ApplicationScoped");
        NAMED_SCOPE.put(NamedScope.REQUEST, "RequestScoped");
        NAMED_SCOPE.put(NamedScope.SESSION, "SessionScoped");
        NAMED_SCOPE.put(NamedScope.CONVERSATION, "ConversationScoped");
        NAMED_SCOPE.put(NamedScope.FLOW, "FlowScoped");
        NAMED_SCOPE.put(NamedScope.VIEW, "ViewScoped");
    }

    public static class ScopeEntry {
        private final String className;
        private final String importEntry;
        private String parameters;

        public ScopeEntry(String className, String importEntry) {
            this.className = className;
            this.importEntry = importEntry;
        }

        public String getClassName() {
            return this.className;
        }

        public String getImportEntry() {
            return this.importEntry;
        }

        public String getParameters() {
            return this.parameters;
        }

        private static ScopeEntry getFor(Object scope, boolean jakartaJsfPackages) {
            if (scope instanceof ManagedBean.Scope) {
                ManagedBean.Scope typedScope = (ManagedBean.Scope)((Object)scope);
                return new ScopeEntry((String)FACES_SCOPE.get((Object)typedScope), ScopeEntry.getScopeImport(typedScope, jakartaJsfPackages));
            }
            NamedScope typedScope = (NamedScope)((Object)scope);
            ScopeEntry se = new ScopeEntry((String)NAMED_SCOPE.get((Object)typedScope), ScopeEntry.getScopeImport(typedScope, jakartaJsfPackages));
            if (typedScope == NamedScope.FLOW) {
                se.parameters = "\"\"";
            }
            return se;
        }

        private static String getScopeImport(ManagedBean.Scope scope, boolean jakartaJsfPackages) {
            if (jakartaJsfPackages) {
                return "jakarta.faces.bean." + (String)FACES_SCOPE.get((Object)scope);
            }
            return "javax.faces.bean." + (String)FACES_SCOPE.get((Object)scope);
        }

        private static String getScopeImport(NamedScope scope, boolean jakartaJsfPackages) {
            String scopeSimpleName = (String)NAMED_SCOPE.get((Object)scope);
            if (jakartaJsfPackages) {
                if (scope == NamedScope.FLOW) {
                    return "jakarta.faces.flow." + scopeSimpleName;
                }
                if (scope == NamedScope.VIEW) {
                    return "jakarta.faces.view." + scopeSimpleName;
                }
                return "jakarta.enterprise.context." + scopeSimpleName;
            }
            if (scope == NamedScope.FLOW) {
                return "javax.faces.flow." + scopeSimpleName;
            }
            if (scope == NamedScope.VIEW) {
                return "javax.faces.view." + scopeSimpleName;
            }
            return "javax.enterprise.context." + scopeSimpleName;
        }
    }

    protected static enum NamedScope {
        DEPENDENT("dependent"),
        APPLICATION("application"),
        REQUEST("request"),
        SESSION("session"),
        CONVERSATION("conversation"),
        FLOW("flow"),
        VIEW("view");

        private String scope;

        private NamedScope(String scope) {
            this.scope = scope;
        }

        public String toString() {
            return this.scope;
        }
    }
}

