/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.vault;

import com.oracle.bmc.vault.VaultsClient;
import com.oracle.bmc.vault.model.ScheduleSecretDeletionDetails;
import com.oracle.bmc.vault.model.Secret;
import com.oracle.bmc.vault.model.SecretSummary;
import com.oracle.bmc.vault.requests.GetSecretRequest;
import com.oracle.bmc.vault.requests.ListSecretsRequest;
import com.oracle.bmc.vault.requests.ScheduleSecretDeletionRequest;
import com.oracle.bmc.vault.responses.GetSecretResponse;
import com.oracle.bmc.vault.responses.ScheduleSecretDeletionResponse;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.stream.Collectors;
import javax.swing.Action;
import org.netbeans.modules.cloud.oracle.ChildrenProvider;
import org.netbeans.modules.cloud.oracle.NodeProvider;
import org.netbeans.modules.cloud.oracle.NotificationUtils;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCINode;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.vault.Bundle;
import org.netbeans.modules.cloud.oracle.vault.SecretItem;
import org.netbeans.modules.cloud.oracle.vault.VaultItem;
import org.openide.actions.DeleteAction;
import org.openide.nodes.Children;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class SecretNode
extends OCINode {
    private static final String SECRET_ICON = "org/netbeans/modules/cloud/oracle/resources/secret.svg";
    private static final SimpleDateFormat DELETION_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public SecretNode(SecretItem vault) {
        super((OCIItem)vault, Children.LEAF);
        this.setName(vault.getName());
        this.setDisplayName(vault.getName());
        this.setIconBaseWithExtension(SECRET_ICON);
        this.setShortDescription(this.createShortDescription(vault.getLifecycleState(), vault.getDeletionTime()));
    }

    private String createShortDescription(String state, Date deletionTime) {
        if (deletionTime != null) {
            return Bundle.SecretNodeDeletingDesc(this.getItem().getName(), state, this.formatDateTime(deletionTime));
        }
        return Bundle.SecretNodeDesc(this.getItem().getName(), state);
    }

    private String formatDateTime(Date deletionTime) {
        return DELETION_TIME_FORMAT.format(deletionTime);
    }

    public static NodeProvider<SecretItem> createNode() {
        return SecretNode::new;
    }

    @Override
    public void update(OCIItem item) {
        SecretItem orig = (SecretItem)item;
        VaultsClient client = OCIManager.getDefault().getActiveProfile(item).newClient(VaultsClient.class);
        GetSecretRequest request = GetSecretRequest.builder().secretId(orig.getKey().getValue()).build();
        GetSecretResponse response = client.getSecret(request);
        Secret secret = response.getSecret();
        orig.setLifecycleState(secret.getLifecycleState().getValue());
        orig.setDeletionTime(secret.getTimeOfDeletion());
        this.setShortDescription(this.createShortDescription(orig.getLifecycleState(), orig.getDeletionTime()));
    }

    @Override
    public Action[] getActions(boolean context) {
        Action[] actions = super.getActions(context);
        ArrayList<Action> actionList = new ArrayList<Action>(Arrays.asList(actions));
        actionList.add((Action)SystemAction.get(DeleteAction.class));
        return (Action[])actionList.toArray(Action[]::new);
    }

    public boolean canDestroy() {
        return ((SecretItem)this.getItem()).getLifecycleState().equals(SecretSummary.LifecycleState.Active.getValue());
    }

    public void destroy() throws IOException {
        RequestProcessor.getDefault().post(() -> {
            ScheduleSecretDeletionResponse response;
            if (!NotificationUtils.confirmAction(Bundle.MSG_ConfirmDeleteAction(this.getName()))) {
                return;
            }
            VaultsClient client = OCIManager.getDefault().getActiveProfile(this.getItem()).newClient(VaultsClient.class);
            Date deletionTime = this.getDeletionTime();
            ScheduleSecretDeletionRequest request = this.buildScheduleDeletionRequest(deletionTime);
            try {
                response = client.scheduleSecretDeletion(request);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                NotificationUtils.showErrorMessage(Bundle.MSG_DeleteActionFailed(this.getName()));
                return;
            }
            if (response.get__httpStatusCode__() != 200) {
                NotificationUtils.showErrorMessage(Bundle.MSG_DeleteActionFailed(this.getName()));
                return;
            }
            this.updateToPendingState(deletionTime);
            NotificationUtils.showMessage(Bundle.MSG_DeleteActionSuccess(this.getName(), this.formatDateTime(deletionTime)));
        });
    }

    private ScheduleSecretDeletionRequest buildScheduleDeletionRequest(Date deletionTime) {
        ScheduleSecretDeletionDetails scheduleSecretDeletionDetails = ScheduleSecretDeletionDetails.builder().timeOfDeletion(deletionTime).build();
        return ScheduleSecretDeletionRequest.builder().secretId(this.getItem().getKey().getValue()).scheduleSecretDeletionDetails(scheduleSecretDeletionDetails).build();
    }

    private void updateToPendingState(Date deletionTime) {
        ((SecretItem)this.getItem()).setLifecycleState(SecretSummary.LifecycleState.PendingDeletion.getValue());
        this.setShortDescription(this.createShortDescription(SecretSummary.LifecycleState.PendingDeletion.getValue(), deletionTime));
    }

    private Date getDeletionTime() {
        LocalDateTime tomorrow = LocalDateTime.now().plusDays(1L).plusHours(1L);
        return Date.from(tomorrow.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static ChildrenProvider.SessionAware<VaultItem, SecretItem> getSecrets() {
        return (vault, session) -> {
            VaultsClient client = session.newClient(VaultsClient.class);
            ListSecretsRequest listSecretsRequest = ListSecretsRequest.builder().compartmentId(vault.getCompartmentId()).vaultId(vault.getKey().getValue()).limit(Integer.valueOf(88)).build();
            String tenancyId = session.getTenancy().isPresent() ? session.getTenancy().get().getKey().getValue() : null;
            String regionCode = session.getRegion().getRegionCode();
            return client.listSecrets(listSecretsRequest).getItems().stream().map(d -> new SecretItem(OCID.of(d.getId(), "Vault/Secret"), d.getCompartmentId(), d.getSecretName(), d.getLifecycleState().getValue(), d.getTimeOfDeletion(), vault.getKey().getValue(), tenancyId, regionCode)).collect(Collectors.toList());
        };
    }
}

