/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofObject;
import org.netbeans.lib.profiler.heap.StackFrame;
import org.netbeans.lib.profiler.heap.StackFrameSegment;
import org.netbeans.lib.profiler.heap.StackTraceSegment;

class StackTrace
extends HprofObject {
    private final StackTraceSegment stackTraceSegment;

    StackTrace(StackTraceSegment segment, long offset) {
        super(offset);
        this.stackTraceSegment = segment;
        assert (this.getHprofBuffer().get(offset) == 5);
    }

    long getSerialNumber() {
        return this.getHprofBuffer().getInt(this.fileOffset + (long)this.stackTraceSegment.stackTraceSerialNumberOffset);
    }

    long getThreadSerialNumber() {
        return this.getHprofBuffer().getInt(this.fileOffset + (long)this.stackTraceSegment.threadSerialNumberOffset);
    }

    StackFrame[] getStackFrames() {
        HprofByteBuffer buf = this.getHprofBuffer();
        int frames = buf.getInt(this.fileOffset + (long)this.stackTraceSegment.numberOfFramesOffset);
        StackFrame[] fr = new StackFrame[frames];
        long idOffset = this.fileOffset + (long)this.stackTraceSegment.framesListOffset;
        StackFrameSegment stackFrameSegment = this.stackTraceSegment.hprofHeap.getStackFrameSegment();
        int i = 0;
        while (i < frames) {
            long frameID = buf.getID(idOffset);
            fr[i] = stackFrameSegment.getStackFrameByID(frameID);
            ++i;
            idOffset += (long)buf.getIDSize();
        }
        return fr;
    }

    private HprofByteBuffer getHprofBuffer() {
        return this.stackTraceSegment.hprofHeap.dumpBuffer;
    }
}

