/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.agui;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.execute.agent.AgentInput;
import org.opensearch.ml.common.input.execute.agent.AgentMLInput;
import org.opensearch.ml.common.input.execute.agent.ContentBlock;
import org.opensearch.ml.common.input.execute.agent.ContentType;
import org.opensearch.ml.common.input.execute.agent.ImageContent;
import org.opensearch.ml.common.input.execute.agent.Message;
import org.opensearch.ml.common.input.execute.agent.SourceType;
import org.opensearch.ml.common.input.execute.agent.ToolCall;
import org.opensearch.ml.common.utils.StringUtils;

public class AGUIInputConverter {
    @Generated
    private static final Logger log = LogManager.getLogger(AGUIInputConverter.class);
    private static final Gson gson = new Gson();

    public static boolean isAGUIInput(String inputJson) {
        try {
            JsonObject jsonObj = JsonParser.parseString((String)inputJson).getAsJsonObject();
            if (!(jsonObj.has("threadId") && jsonObj.has("runId") && jsonObj.has("state") && jsonObj.has("messages") && jsonObj.has("tools") && jsonObj.has("context") && jsonObj.has("forwardedProps"))) {
                return false;
            }
            JsonElement messages = jsonObj.get("messages");
            if (!messages.isJsonArray()) {
                return false;
            }
            JsonElement tools = jsonObj.get("tools");
            if (!tools.isJsonArray()) {
                return false;
            }
            JsonElement context = jsonObj.get("context");
            return context.isJsonArray();
        }
        catch (Exception e) {
            log.error("Failed to parse input as JSON for AG-UI detection", (Throwable)e);
            return false;
        }
    }

    public static AgentMLInput convertFromAGUIInput(String aguiInputJson, String agentId, String tenantId, boolean isAsync) {
        try {
            JsonObject aguiInput = JsonParser.parseString((String)aguiInputJson).getAsJsonObject();
            String threadId = StringUtils.getStringField(aguiInput, "threadId");
            String runId = StringUtils.getStringField(aguiInput, "runId");
            JsonElement state = aguiInput.get("state");
            JsonElement messages = aguiInput.get("messages");
            JsonElement tools = aguiInput.get("tools");
            JsonElement context = aguiInput.get("context");
            JsonElement forwardedProps = aguiInput.get("forwardedProps");
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("agui_thread_id", threadId);
            parameters.put("agui_run_id", runId);
            if (state != null) {
                parameters.put("agui_state", gson.toJson(state));
            }
            if (messages != null) {
                parameters.put("agui_messages", gson.toJson(messages));
            }
            if (tools != null) {
                parameters.put("agui_tools", gson.toJson(tools));
            }
            if (context != null) {
                parameters.put("agui_context", gson.toJson(context));
            }
            if (forwardedProps != null) {
                parameters.put("agui_forwarded_props", gson.toJson(forwardedProps));
            }
            RemoteInferenceInputDataSet inputDataSet = RemoteInferenceInputDataSet.builder().parameters(parameters).build();
            AgentMLInput agentMLInput = new AgentMLInput(agentId, tenantId, FunctionName.AGENT, inputDataSet, isAsync);
            if (messages != null && messages.isJsonArray()) {
                JsonArray messagesArray = messages.getAsJsonArray();
                List<Message> agentMessages = AGUIInputConverter.convertAGUIMessages(messagesArray);
                if (context != null && context.isJsonArray()) {
                    AGUIInputConverter.appendContextToLatestUserMessage(agentMessages, context.getAsJsonArray());
                }
                AgentInput agentInput = new AgentInput(agentMessages);
                agentMLInput.setAgentInput(agentInput);
            }
            log.debug("Converted AG-UI input to ML-Commons format for agent: {}", (Object)agentId);
            return agentMLInput;
        }
        catch (Exception e) {
            log.error("Failed to convert AG-UI input to ML-Commons format", (Throwable)e);
            throw new IllegalArgumentException("Invalid AG-UI input format", e);
        }
    }

    private static List<Message> convertAGUIMessages(JsonArray aguiMessages) {
        ArrayList<Message> messages = new ArrayList<Message>();
        for (JsonElement msgElement : aguiMessages) {
            JsonElement toolCallsElement;
            JsonObject aguiMsg;
            String role;
            if (!msgElement.isJsonObject() || (role = StringUtils.getStringField(aguiMsg = msgElement.getAsJsonObject(), "role")) == null) continue;
            List<ContentBlock> contentBlocks = AGUIInputConverter.parseContent(aguiMsg.get("content"));
            Message message = new Message(role, contentBlocks);
            if ("assistant".equalsIgnoreCase(role) && aguiMsg.has("toolCalls") && (toolCallsElement = aguiMsg.get("toolCalls")).isJsonArray()) {
                List<ToolCall> toolCalls = AGUIInputConverter.parseToolCalls(toolCallsElement.getAsJsonArray());
                message.setToolCalls(toolCalls);
            }
            if ("tool".equalsIgnoreCase(role) && aguiMsg.has("toolCallId")) {
                String toolCallId = StringUtils.getStringField(aguiMsg, "toolCallId");
                message.setToolCallId(toolCallId);
            }
            messages.add(message);
        }
        return messages;
    }

    private static List<ToolCall> parseToolCalls(JsonArray toolCallsArray) {
        ArrayList<ToolCall> toolCalls = new ArrayList<ToolCall>();
        for (JsonElement toolCallElement : toolCallsArray) {
            if (!toolCallElement.isJsonObject()) continue;
            JsonObject toolCallObj = toolCallElement.getAsJsonObject();
            String id = StringUtils.getStringField(toolCallObj, "id");
            String type = StringUtils.getStringField(toolCallObj, "type");
            JsonElement functionElement = toolCallObj.get("function");
            if (id == null || functionElement == null || !functionElement.isJsonObject()) continue;
            JsonObject functionObj = functionElement.getAsJsonObject();
            String name = StringUtils.getStringField(functionObj, "name");
            String arguments = StringUtils.getStringField(functionObj, "arguments");
            if (name == null || arguments == null) continue;
            ToolCall.ToolFunction function = new ToolCall.ToolFunction(name, arguments);
            ToolCall toolCall = new ToolCall(id, type, function);
            toolCalls.add(toolCall);
        }
        return toolCalls;
    }

    private static List<ContentBlock> parseContent(JsonElement contentElement) {
        ArrayList<ContentBlock> contentBlocks = new ArrayList<ContentBlock>();
        if (contentElement == null || contentElement.isJsonNull()) {
            return contentBlocks;
        }
        if (contentElement.isJsonPrimitive()) {
            ContentBlock textBlock = new ContentBlock();
            textBlock.setType(ContentType.TEXT);
            textBlock.setText(contentElement.getAsString());
            contentBlocks.add(textBlock);
        } else if (contentElement.isJsonArray()) {
            JsonArray contentArray = contentElement.getAsJsonArray();
            for (JsonElement element : contentArray) {
                ContentBlock block;
                if (!element.isJsonObject() || (block = AGUIInputConverter.parseContentBlock(element.getAsJsonObject())) == null) continue;
                contentBlocks.add(block);
            }
        }
        return contentBlocks;
    }

    private static ContentBlock parseContentBlock(JsonObject blockObj) {
        if (!blockObj.has("type")) {
            return null;
        }
        String type = blockObj.get("type").getAsString();
        if ("text".equals(type)) {
            ContentBlock block = new ContentBlock();
            block.setType(ContentType.TEXT);
            if (blockObj.has("text")) {
                block.setText(blockObj.get("text").getAsString());
            }
            return block;
        }
        if ("binary".equals(type)) {
            return AGUIInputConverter.parseBinaryContent(blockObj);
        }
        return null;
    }

    private static ContentBlock parseBinaryContent(JsonObject binaryObj) {
        if (!binaryObj.has("mimeType") || !binaryObj.has("data")) {
            return null;
        }
        String mimeType = binaryObj.get("mimeType").getAsString();
        if (!mimeType.startsWith("image/")) {
            return null;
        }
        String format = AGUIInputConverter.extractFormat(mimeType);
        String data = binaryObj.get("data").getAsString();
        ImageContent imageContent = new ImageContent();
        imageContent.setType(SourceType.BASE64);
        imageContent.setFormat(format);
        imageContent.setData(data);
        ContentBlock block = new ContentBlock();
        block.setType(ContentType.IMAGE);
        block.setImage(imageContent);
        return block;
    }

    private static String extractFormat(String mimeType) {
        int slashIndex = mimeType.indexOf(47);
        if (slashIndex >= 0 && slashIndex < mimeType.length() - 1) {
            return mimeType.substring(slashIndex + 1);
        }
        return mimeType;
    }

    private static void appendContextToLatestUserMessage(List<Message> messages, JsonArray contextArray) {
        if (messages == null || messages.isEmpty() || contextArray == null || contextArray.size() == 0) {
            return;
        }
        Message latestUserMessage = null;
        for (int i = messages.size() - 1; i >= 0; --i) {
            Message message = messages.get(i);
            if (!"user".equalsIgnoreCase(message.getRole())) continue;
            latestUserMessage = message;
            break;
        }
        if (latestUserMessage == null) {
            log.debug("No user message found to append context to, skipping context appending");
            return;
        }
        StringBuilder contextBuilder = new StringBuilder();
        contextBuilder.append("Context:\n");
        for (JsonElement contextItemElement : contextArray) {
            if (!contextItemElement.isJsonObject()) continue;
            JsonObject contextItem = contextItemElement.getAsJsonObject();
            String description = StringUtils.getStringField(contextItem, "description");
            String value = StringUtils.getStringField(contextItem, "value");
            if (description == null || value == null) continue;
            contextBuilder.append("- ").append(description).append(": ").append(value).append("\n");
        }
        contextBuilder.append("\n");
        List<ContentBlock> contentBlocks = latestUserMessage.getContent();
        if (contentBlocks != null && !contentBlocks.isEmpty()) {
            ContentBlock lastTextBlock = null;
            for (int i = contentBlocks.size() - 1; i >= 0; --i) {
                ContentBlock block = contentBlocks.get(i);
                if (block.getType() != ContentType.TEXT) continue;
                lastTextBlock = block;
                break;
            }
            if (lastTextBlock != null) {
                String originalText = lastTextBlock.getText();
                String newText = contextBuilder.toString() + originalText;
                lastTextBlock.setText(newText);
                log.debug("AG-UI: Appended context to latest user message");
            } else {
                log.warn("No text content block found in latest user message, skipping context appending");
            }
        } else {
            log.debug("No content blocks found in latest user message, skipping context appending");
        }
    }
}

