/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.options.general;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.core.ProxySettings;
import org.netbeans.core.ui.options.general.GeneralOptionsPanel;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

class GeneralOptionsModel {
    private static final Logger LOGGER = Logger.getLogger(GeneralOptionsModel.class.getName());
    private static final String NON_PROXY_HOSTS_DELIMITER = "|";
    private static final RequestProcessor rp = new RequestProcessor(GeneralOptionsModel.class);

    GeneralOptionsModel() {
    }

    private static Preferences getProxyPreferences() {
        return NbPreferences.root().node("org/netbeans/core");
    }

    boolean getUsageStatistics() {
        String string = System.getProperty("nb.show.statistics.ui");
        if (string != null) {
            return GeneralOptionsModel.getProxyPreferences().getBoolean(string, Boolean.FALSE);
        }
        return false;
    }

    void setUsageStatistics(boolean bl) {
        String string = System.getProperty("nb.show.statistics.ui");
        if (string != null && bl != this.getUsageStatistics()) {
            GeneralOptionsModel.getProxyPreferences().putBoolean(string, bl);
        }
    }

    int getProxyType() {
        return GeneralOptionsModel.getProxyPreferences().getInt("proxyType", 1);
    }

    void setProxyType(int n) {
        if (n != this.getProxyType()) {
            if (1 == n) {
                GeneralOptionsModel.getProxyPreferences().putInt("proxyType", GeneralOptionsModel.usePAC() ? 3 : 1);
            } else {
                GeneralOptionsModel.getProxyPreferences().putInt("proxyType", n);
            }
        }
    }

    String getHttpProxyHost() {
        return ProxySettings.getHttpHost();
    }

    void setHttpProxyHost(String string) {
        if (!string.equals(this.getHttpProxyHost())) {
            GeneralOptionsModel.getProxyPreferences().put("proxyHttpHost", string);
        }
    }

    String getHttpProxyPort() {
        return ProxySettings.getHttpPort();
    }

    void setHttpProxyPort(String string) {
        if (!string.equals(this.getHttpProxyPort())) {
            GeneralOptionsModel.getProxyPreferences().put("proxyHttpPort", GeneralOptionsModel.validatePort(string) ? string : "");
        }
    }

    String getHttpsProxyHost() {
        return ProxySettings.getHttpsHost();
    }

    void setHttpsProxyHost(String string) {
        if (!string.equals(this.getHttpsProxyHost())) {
            GeneralOptionsModel.getProxyPreferences().put("proxyHttpsHost", string);
        }
    }

    String getHttpsProxyPort() {
        return ProxySettings.getHttpsPort();
    }

    void setHttpsProxyPort(String string) {
        if (!string.equals(this.getHttpsProxyPort())) {
            GeneralOptionsModel.getProxyPreferences().put("proxyHttpsPort", GeneralOptionsModel.validatePort(string) ? string : "");
        }
    }

    String getSocksHost() {
        return ProxySettings.getSocksHost();
    }

    void setSocksHost(String string) {
        if (!string.equals(this.getSocksHost())) {
            GeneralOptionsModel.getProxyPreferences().put("proxySocksHost", string);
        }
    }

    String getSocksPort() {
        return ProxySettings.getSocksPort();
    }

    void setSocksPort(String string) {
        if (!string.equals(this.getSocksPort())) {
            GeneralOptionsModel.getProxyPreferences().put("proxySocksPort", GeneralOptionsModel.validatePort(string) ? string : "");
        }
    }

    String getOriginalHttpsHost() {
        return GeneralOptionsModel.getProxyPreferences().get("proxyHttpsHost", "");
    }

    String getOriginalHttpsPort() {
        return GeneralOptionsModel.getProxyPreferences().get("proxyHttpsPort", "");
    }

    String getOriginalSocksHost() {
        return GeneralOptionsModel.getProxyPreferences().get("proxySocksHost", "");
    }

    String getOriginalSocksPort() {
        return GeneralOptionsModel.getProxyPreferences().get("proxySocksPort", "");
    }

    String getNonProxyHosts() {
        return GeneralOptionsModel.code2view(ProxySettings.getNonProxyHosts());
    }

    void setNonProxyHosts(String string) {
        if (!string.equals(this.getNonProxyHosts())) {
            GeneralOptionsModel.getProxyPreferences().put("proxyNonProxyHosts", GeneralOptionsModel.view2code(string));
        }
    }

    boolean useProxyAuthentication() {
        return ProxySettings.useAuthentication();
    }

    void setUseProxyAuthentication(boolean bl) {
        if (bl != this.useProxyAuthentication()) {
            GeneralOptionsModel.getProxyPreferences().putBoolean("useProxyAuthentication", bl);
        }
    }

    boolean useProxyAllProtocols() {
        return ProxySettings.useProxyAllProtocols();
    }

    void setUseProxyAllProtocols(boolean bl) {
        if (bl != this.useProxyAllProtocols()) {
            GeneralOptionsModel.getProxyPreferences().putBoolean("useProxyAllProtocols", bl);
        }
    }

    String getProxyAuthenticationUsername() {
        return ProxySettings.getAuthenticationUsername();
    }

    void setAuthenticationUsername(String string) {
        GeneralOptionsModel.getProxyPreferences().put("proxyAuthenticationUsername", string);
    }

    char[] getProxyAuthenticationPassword() {
        return ProxySettings.getAuthenticationPassword();
    }

    void setAuthenticationPassword(char[] cArray) {
        ProxySettings.setAuthenticationPassword((char[])cArray);
    }

    static boolean usePAC() {
        String string = GeneralOptionsModel.getProxyPreferences().get("systemPAC", "");
        return string != null && string.length() > 0;
    }

    static void testConnection(final GeneralOptionsPanel generalOptionsPanel, final int n, final String string, final String string2, final String string3) {
        rp.post(new Runnable(){

            @Override
            public void run() {
                GeneralOptionsModel.testProxy(generalOptionsPanel, n, string, string2, string3);
            }
        });
    }

    private static void testProxy(GeneralOptionsPanel generalOptionsPanel, int n, String string, String string2, String string3) {
        Proxy proxy;
        String string4;
        URL uRL;
        generalOptionsPanel.updateTestConnectionStatus(TestingStatus.WAITING, null);
        TestingStatus testingStatus = TestingStatus.FAILED;
        String string5 = null;
        try {
            uRL = new URL("https://netbeans.apache.org");
            string4 = uRL.getHost();
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.log(Level.SEVERE, "Cannot create url from string.", malformedURLException);
            generalOptionsPanel.updateTestConnectionStatus(testingStatus, string5);
            return;
        }
        switch (n) {
            case 0: {
                proxy = Proxy.NO_PROXY;
                break;
            }
            case 1: 
            case 3: {
                string3 = ProxySettings.getSystemNonProxyHosts();
                if (GeneralOptionsModel.isNonProxy(string4, string3)) {
                    proxy = Proxy.NO_PROXY;
                    break;
                }
                String string6 = ProxySettings.getTestSystemHttpHost();
                if (string6 == null || string6.isEmpty()) {
                    proxy = Proxy.NO_PROXY;
                    break;
                }
                int n2 = 0;
                try {
                    n2 = Integer.valueOf(ProxySettings.getTestSystemHttpPort());
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.log(Level.INFO, "Cannot parse port number", numberFormatException);
                }
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string6, n2));
                break;
            }
            case 2: {
                string3 = GeneralOptionsModel.view2code(string3);
                if (GeneralOptionsModel.isNonProxy(uRL.getHost(), string3)) {
                    proxy = Proxy.NO_PROXY;
                    break;
                }
                try {
                    int n3 = Integer.valueOf(string2);
                    proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, n3));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.log(Level.INFO, "Cannot parse port number", numberFormatException);
                    testingStatus = TestingStatus.FAILED;
                    string5 = NbBundle.getMessage(GeneralOptionsModel.class, (String)"LBL_GeneralOptionsPanel_PortError");
                    generalOptionsPanel.updateTestConnectionStatus(testingStatus, string5);
                    return;
                }
            }
            default: {
                proxy = Proxy.NO_PROXY;
            }
        }
        try {
            testingStatus = GeneralOptionsModel.testHttpConnection(uRL, proxy) ? TestingStatus.OK : TestingStatus.FAILED;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, "Cannot connect via http protocol.", iOException);
            string5 = iOException.getLocalizedMessage();
        }
        generalOptionsPanel.updateTestConnectionStatus(testingStatus, string5);
    }

    private static boolean testHttpConnection(URL uRL, Proxy proxy) throws IOException {
        boolean bl = false;
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection(proxy);
        httpURLConnection.setConnectTimeout(5000);
        httpURLConnection.connect();
        if (httpURLConnection.getResponseCode() == 200 || httpURLConnection.getResponseCode() == 302) {
            bl = true;
        }
        httpURLConnection.disconnect();
        return bl;
    }

    private static boolean isNonProxy(String string, String string2) {
        boolean bl = false;
        if (string != null && string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, NON_PROXY_HOSTS_DELIMITER, false);
            while (stringTokenizer.hasMoreTokens()) {
                if (!stringTokenizer.nextToken().equals(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private static boolean validatePort(String string) {
        boolean bl;
        block3: {
            if (string.trim().length() == 0) {
                return true;
            }
            bl = false;
            try {
                Integer.parseInt(string);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)numberFormatException);
            }
        }
        return bl;
    }

    private static String code2view(String string) {
        return string == null ? string : string.replace(NON_PROXY_HOSTS_DELIMITER, ", ");
    }

    private static String view2code(String string) {
        return string == null ? string : string.replace(", ", NON_PROXY_HOSTS_DELIMITER);
    }

    static enum TestingStatus {
        OK,
        FAILED,
        WAITING,
        NOT_TESTED;

    }
}

