/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.artifacts.verification.DependencyVerificationMode;
import org.gradle.api.component.Artifact;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.DependencyVerifyingModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.ArtifactVerificationOperation;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.DefaultKeyServers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.DependencyVerificationOverride;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.RepositoryAwareVerificationFailure;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report.DependencyVerificationReportWriter;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report.VerificationReport;
import org.gradle.api.internal.artifacts.verification.exceptions.DependencyVerificationException;
import org.gradle.api.internal.artifacts.verification.serializer.DependencyVerificationsXmlReader;
import org.gradle.api.internal.artifacts.verification.signatures.BuildTreeDefinedKeys;
import org.gradle.api.internal.artifacts.verification.signatures.SignatureVerificationService;
import org.gradle.api.internal.artifacts.verification.signatures.SignatureVerificationServiceFactory;
import org.gradle.api.internal.artifacts.verification.verifier.DependencyVerifier;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.ExternalModuleComponentGraphResolveState;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.resource.local.FileResourceListener;

public class ChecksumAndSignatureVerificationOverride
implements DependencyVerificationOverride,
ArtifactVerificationOperation,
Stoppable {
    private static final Logger LOGGER = Logging.getLogger(ChecksumAndSignatureVerificationOverride.class);
    private final DependencyVerifier verifier;
    private final BuildOperationExecutor buildOperationExecutor;
    private final ChecksumService checksumService;
    private final SignatureVerificationService signatureVerificationService;
    private final DependencyVerificationMode verificationMode;
    private final FileResourceListener fileResourceListener;
    private final Set<VerificationQuery> verificationQueries = Sets.newConcurrentHashSet();
    private final Deque<VerificationEvent> verificationEvents = Queues.newArrayDeque();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final DependencyVerificationReportWriter reportWriter;
    private final Object failuresLock = new Object();
    private final Multimap<ModuleComponentArtifactIdentifier, RepositoryAwareVerificationFailure> failures = LinkedHashMultimap.create();
    private boolean hasFatalFailure = false;

    public ChecksumAndSignatureVerificationOverride(BuildOperationExecutor buildOperationExecutor, File gradleUserHome, File verificationsFile, ChecksumService checksumService, SignatureVerificationServiceFactory signatureVerificationServiceFactory, DependencyVerificationMode verificationMode, DocumentationRegistry documentationRegistry, File reportsDirectory, Factory<GradleProperties> gradlePropertiesFactory, FileResourceListener fileResourceListener) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.checksumService = checksumService;
        this.verificationMode = verificationMode;
        this.fileResourceListener = fileResourceListener;
        try {
            this.verifier = DependencyVerificationsXmlReader.readFromXml(new FileInputStream(this.observed(verificationsFile)));
            this.reportWriter = new DependencyVerificationReportWriter(gradleUserHome.toPath(), documentationRegistry, verificationsFile, this.verifier.getSuggestedWriteFlags(), reportsDirectory, gradlePropertiesFactory);
        }
        catch (FileNotFoundException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        catch (DependencyVerificationException e) {
            throw new DependencyVerificationException("Unable to read dependency verification metadata from " + verificationsFile, e.getCause());
        }
        BuildTreeDefinedKeys localKeyring = new BuildTreeDefinedKeys(verificationsFile.getParentFile(), this.verifier.getConfiguration().getKeyringFormat());
        this.signatureVerificationService = signatureVerificationServiceFactory.create(localKeyring, this.keyServers(), this.verifier.getConfiguration().isUseKeyServers());
    }

    private List<URI> keyServers() {
        return DefaultKeyServers.getOrDefaults(this.verifier.getConfiguration().getKeyServers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onArtifact(ArtifactVerificationOperation.ArtifactKind kind, ModuleComponentArtifactIdentifier artifact, File mainFile, Factory<File> signatureFile, String repositoryName, String repositoryId) {
        if (this.verificationQueries.add(new VerificationQuery(artifact, repositoryId))) {
            VerificationEvent event = new VerificationEvent(kind, artifact, mainFile, signatureFile, repositoryName);
            Deque<VerificationEvent> deque = this.verificationEvents;
            synchronized (deque) {
                this.verificationEvents.add(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyConcurrently() {
        Deque<VerificationEvent> deque = this.verificationEvents;
        synchronized (deque) {
            if (this.verificationEvents.isEmpty()) {
                return;
            }
        }
        if (this.closed.get()) {
            LOGGER.debug("Cannot perform verification of all dependencies because the verification service has been shutdown. Under normal circumstances this shouldn't happen unless a user buildFinished was added in an unexpected way.");
            return;
        }
        this.buildOperationExecutor.runAll(queue -> {
            Deque<VerificationEvent> deque = this.verificationEvents;
            synchronized (deque) {
                VerificationEvent event;
                while ((event = this.verificationEvents.poll()) != null) {
                    final VerificationEvent ve = event;
                    queue.add((BuildOperation)new RunnableBuildOperation(){

                        public void run(BuildOperationContext context) {
                            ChecksumAndSignatureVerificationOverride.this.verifier.verify(ChecksumAndSignatureVerificationOverride.this.checksumService, ChecksumAndSignatureVerificationOverride.this.signatureVerificationService, ve.kind, ve.artifact, ChecksumAndSignatureVerificationOverride.this.observed(ve.mainFile), ChecksumAndSignatureVerificationOverride.this.observed((File)ve.signatureFile.create()), f -> {
                                Object object = ChecksumAndSignatureVerificationOverride.this.failuresLock;
                                synchronized (object) {
                                    ChecksumAndSignatureVerificationOverride.this.failures.put((Object)ve.artifact, (Object)new RepositoryAwareVerificationFailure(f, ve.repositoryName));
                                    if (f.isFatal()) {
                                        ChecksumAndSignatureVerificationOverride.this.hasFatalFailure = true;
                                    }
                                }
                            });
                        }

                        public BuildOperationDescriptor.Builder description() {
                            return BuildOperationDescriptor.displayName((String)"Dependency verification").progressDisplayName("Verifying " + ve.artifact);
                        }
                    });
                }
            }
        });
    }

    @Override
    public ModuleComponentRepository<ExternalModuleComponentGraphResolveState> overrideDependencyVerification(ModuleComponentRepository<ExternalModuleComponentGraphResolveState> original) {
        return new DependencyVerifyingModuleComponentRepository(original, this, this.verifier.getConfiguration().isVerifySignatures());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void artifactsAccessed(String displayName) {
        this.verifyConcurrently();
        Object object = this.failuresLock;
        synchronized (object) {
            if (this.hasFatalFailure) {
                Map filtered = (Map)this.failures.asMap().entrySet().stream().filter(entry -> {
                    Collection value = (Collection)entry.getValue();
                    return value.stream().anyMatch(wrapper -> wrapper.getFailure().isFatal());
                }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
                VerificationReport report = this.reportWriter.generateReport(displayName, filtered, this.verifier.getConfiguration().isUseKeyServers());
                String errorMessage = this.buildConsoleErrorMessage(report);
                if (this.verificationMode == DependencyVerificationMode.LENIENT) {
                    LOGGER.error(errorMessage);
                    this.failures.clear();
                    this.hasFatalFailure = false;
                } else {
                    throw new DependencyVerificationException(errorMessage);
                }
            }
        }
    }

    public String buildConsoleErrorMessage(VerificationReport report) {
        String errorMessage = report.getSummary();
        String htmlReport = new ConsoleRenderer().asClickableFileUrl(report.getHtmlReport());
        errorMessage = errorMessage + "\n\nOpen this report for more details: " + htmlReport;
        return errorMessage;
    }

    @Override
    public ResolvedArtifactResult verifiedArtifact(final ResolvedArtifactResult artifact) {
        return new ResolvedArtifactResult(){

            public File getFile() {
                ChecksumAndSignatureVerificationOverride.this.artifactsAccessed(artifact.getVariant().getDisplayName());
                return artifact.getFile();
            }

            public ResolvedVariantResult getVariant() {
                return artifact.getVariant();
            }

            public ComponentArtifactIdentifier getId() {
                return artifact.getId();
            }

            public Class<? extends Artifact> getType() {
                return artifact.getType();
            }
        };
    }

    private File observed(File file) {
        if (file == null) {
            return file;
        }
        this.fileResourceListener.fileObserved(file);
        return file;
    }

    public void stop() {
        this.closed.set(true);
        this.signatureVerificationService.stop();
    }

    private static class VerificationQuery {
        private final ModuleComponentArtifactIdentifier artifact;
        private final String repositoryId;
        private final int hashCode;

        public VerificationQuery(ModuleComponentArtifactIdentifier artifact, String repositoryId) {
            this.artifact = artifact;
            this.repositoryId = repositoryId;
            this.hashCode = this.precomputeHashCode(artifact, repositoryId);
        }

        private int precomputeHashCode(ModuleComponentArtifactIdentifier artifact, String repositoryId) {
            int hashCode = artifact.getComponentIdentifier().hashCode();
            hashCode = 31 * hashCode + artifact.getFileName().hashCode();
            hashCode = 31 * hashCode + repositoryId.hashCode();
            return hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VerificationQuery that = (VerificationQuery)o;
            if (this.hashCode != that.hashCode) {
                return false;
            }
            if (!this.artifact.getComponentIdentifier().equals(that.artifact.getComponentIdentifier())) {
                return false;
            }
            if (!this.artifact.getFileName().equals(that.artifact.getFileName())) {
                return false;
            }
            return this.repositoryId.equals(that.repositoryId);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class VerificationEvent {
        private final ArtifactVerificationOperation.ArtifactKind kind;
        private final ModuleComponentArtifactIdentifier artifact;
        private final File mainFile;
        private final Factory<File> signatureFile;
        private final String repositoryName;

        private VerificationEvent(ArtifactVerificationOperation.ArtifactKind kind, ModuleComponentArtifactIdentifier artifact, File mainFile, Factory<File> signatureFile, String repositoryName) {
            this.kind = kind;
            this.artifact = artifact;
            this.mainFile = mainFile;
            this.signatureFile = signatureFile;
            this.repositoryName = repositoryName;
        }
    }
}

