/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ReturnValueCheckerMode;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u000b\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J-\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u00020\u000eR\u00020\u0010j\u0006\u0010\u000f\u001a\u00020\u000ej\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReturnValueAnnotationsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "isMustUseReturnValue", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isIgnorableValue", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnusedReturnValueChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnusedReturnValueChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReturnValueAnnotationsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,195:1\n1869#2,2:196\n*S KotlinDebug\n*F\n+ 1 FirUnusedReturnValueChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReturnValueAnnotationsChecker\n*L\n54#1:196,2\n*E\n"})
public final class FirReturnValueAnnotationsChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirReturnValueAnnotationsChecker INSTANCE = new FirReturnValueAnnotationsChecker();

    private FirReturnValueAnnotationsChecker() {
        super(MppCheckerKind.Common);
    }

    private final boolean isMustUseReturnValue(FirAnnotation $this$isMustUseReturnValue, FirSession session) {
        return Intrinsics.areEqual(FirAnnotationUtilsKt.toAnnotationClassId($this$isMustUseReturnValue, session), StandardClassIds.Annotations.INSTANCE.getMustUseReturnValue());
    }

    private final boolean isIgnorableValue(FirAnnotation $this$isIgnorableValue, FirSession session) {
        return Intrinsics.areEqual(FirAnnotationUtilsKt.toAnnotationClassId($this$isIgnorableValue, session), StandardClassIds.Annotations.INSTANCE.getIgnorableReturnValue());
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getReturnValueCheckerMode()) != ReturnValueCheckerMode.DISABLED) {
            return;
        }
        FirSession session = context2.getSession();
        Iterable $this$forEach$iv = declaration.getAnnotations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirAnnotation annotation = (FirAnnotation)element$iv;
            boolean bl = false;
            if (!INSTANCE.isMustUseReturnValue(annotation, session) && !INSTANCE.isIgnorableValue(annotation, session)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getIGNORABILITY_ANNOTATIONS_WITH_CHECKER_DISABLED(), null, 8, null);
        }
    }
}

