/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FloatingNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileGroup;
import net.sourceforge.plantuml.activitydiagram3.gtile.AbstractGtileRoot;
import net.sourceforge.plantuml.activitydiagram3.gtile.GConnection;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.skin.AlignmentParam;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.utils.MathUtils;

public class GtileGroup
extends AbstractGtileRoot {
    private final double diffYY2 = 20.0;
    private final Gtile inner;
    private final TextBlock name;
    private final TextBlock headerNote;
    private final HColor borderColor;
    private final HColor backColor;
    private final double shadowing;
    private final UStroke stroke;
    private final USymbol type;
    private final double roundCorner;

    public final StyleSignatureBasic getStyleSignature() {
        return FtileGroup.getStyleSignature(this.type);
    }

    private double suppWidth(StringBounder stringBounder) {
        XDimension2D orig = this.inner.calculateDimension(stringBounder);
        XDimension2D dimTitle = this.name.calculateDimension(stringBounder);
        XDimension2D dimHeaderNote = this.headerNote.calculateDimension(stringBounder);
        double suppWidth = MathUtils.max(orig.getWidth(), dimTitle.getWidth() + 20.0, dimHeaderNote.getWidth() + 20.0) - orig.getWidth();
        return suppWidth;
    }

    public GtileGroup(Gtile inner, Display title, Display displayNote, HColor arrowColor, HColor backColor, ISkinParam skinParam, USymbol type, Style style) {
        super(inner.getStringBounder(), skinParam);
        this.type = type;
        this.backColor = backColor == null ? HColors.WHITE : backColor;
        this.inner = inner;
        this.borderColor = style.value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
        this.roundCorner = style.value(PName.RoundCorner).asDouble();
        FontConfiguration fc = style.getFontConfiguration(skinParam.getIHtmlColorSet());
        this.shadowing = style.getShadowing();
        this.name = title == null ? TextBlockUtils.empty(0.0, 0.0) : title.create(fc, HorizontalAlignment.LEFT, skinParam);
        this.headerNote = Display.isNull(displayNote) ? TextBlockUtils.empty(0.0, 0.0) : FloatingNote.create(displayNote, skinParam, SName.activityDiagram);
        this.stroke = style.getStroke();
    }

    @Override
    public Collection<GConnection> getInnerConnections() {
        return Collections.emptyList();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.inner.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlane(String point) {
        return this.inner.getSwimlane(point);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D orig = this.inner.calculateDimension(stringBounder);
        return orig.delta(18.0, this.suppHeight(stringBounder));
    }

    private double suppHeight(StringBounder stringBounder) {
        XDimension2D dimTitle = this.name.calculateDimension(stringBounder);
        return dimTitle.getHeight() + 30.0;
    }

    private UTranslate getTranslate() {
        return new UTranslate(9.0, this.suppHeight(this.getStringBounder()) - 10.0);
    }

    @Override
    protected UTranslate getCoordImpl(String name) {
        return this.inner.getCoord(name).compose(this.getTranslate());
    }

    @Override
    protected void drawUInternal(UGraphic ug) {
        XDimension2D dimTotal = this.calculateDimension(this.stringBounder);
        Fashion symbolContext = new Fashion(this.backColor, this.borderColor).withShadow(this.shadowing).withStroke(this.stroke).withCorner(this.roundCorner, 0.0);
        HorizontalAlignment align = this.inner.skinParam().getHorizontalAlignment(AlignmentParam.packageTitleAlignment, null, false, null);
        this.type.asBig(this.name, align, TextBlockUtils.empty(0.0, 0.0), dimTotal.getWidth(), dimTotal.getHeight(), symbolContext, this.skinParam().getStereotypeAlignment()).drawU(ug);
        this.inner.drawU(ug.apply(this.getTranslate()));
    }
}

