/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.nlctdoc;

import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.NumericRegister;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import java.io.IOException;

public class ExampleFileBaseName
extends Command {
    public ExampleFileBaseName() {
        this("nlctexamplefilebasename");
    }

    public ExampleFileBaseName(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new ExampleFileBaseName(this.getName());
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXParserListener teXParserListener = teXParser.getListener();
        NumericRegister numericRegister = teXParser.getSettings().getNumericRegister("c@example");
        if (numericRegister == null) {
            throw new LaTeXSyntaxException(teXParser, "latex.error.undefined_counter", "example");
        }
        int n = numericRegister.number(teXParser);
        TeXObjectList teXObjectList2 = teXParserListener.createStack();
        ControlSequence controlSequence = teXParserListener.getControlSequence("jobname");
        teXObjectList2.add(TeXParserUtils.expandOnce(controlSequence, teXParser, teXObjectList), true);
        teXObjectList2.addAll(teXParserListener.createString(String.format("-example%03d", n)));
        return teXObjectList2;
    }
}

