---
myst:
  html_meta:
    keywords: éditeur de texte,GUI,EDI,IDE,environnement de développement intégré,développement,rédaction,Emacs,VI,troll,débat,coloration syntaxique
---

# Les éditeurs


Il existe des quantités invraisemblables d'éditeurs TeX, LaTeX. Il nous
faut distinguer les éditeurs spécialisés[^1] des éditeurs de
programmation avec un mode TeX/LaTeX plus ou moins sophistiqué. Ceci
dit, l'utilisation d'un éditeur particulier n'est qu'une affaire
strictement personnelle, et nous les citerons en essayant d'éviter
toute guerre de religion.

Il faut savoir que n'importe quel éditeur qui permet de sauver du texte
en texte brut peut servir à éditer des sources LaTeX. Une des
différences entre ces éditeurs est l'intégration plus ou moins complète
avec l'environnement TeX, les compilateurs, éditeurs de bibliographie,
gestion des erreurs de compilation, visualiseurs etc.

Une autre caractéristique à prendre en considération est la possibilité
d'entrer du texte en UTF8. Un tel éditeur peut permettre de saisir du
texte en de multiples langues mixées. C'est d'autant plus
recommandable que, aujourd'hui, il s'agit de l'encodage de LaTeX par
défaut[^2]. La plupart des éditeurs généralistes modernes satisfont
cette condition.

Ces quelques pages vous permettront de connaître les principaux éditeurs
disponibles :

-   [Éditeur de
    texte](https://fr.wikipedia.org/wiki/%C3%89diteur_de_texte) sur
    Wikipedia ;
-   [Liste d'éditeurs UTF-8](/6_distributions/editeurs/editeurs_utf8) ;
-   Passage en revue des principaux éditeurs pour TeX par plateforme :
    -   [Linux](/6_distributions/editeurs/editeurs_pour_unix) ;
    -   [Windows](/6_distributions/editeurs/editeurs_pour_windows) ;
    -   [Mac](/6_distributions/editeurs/editeurs_pour_macos) ;
    -   [Autres
        systèmes](/6_distributions/editeurs/editeurs_multiplateformes).
-   [](/6_distributions/editeurs/correcteurs_orthographiques)

------------------------------------------------------------------------

*Sources:*

-   <https://tex.stackexchange.com/questions/339/latex-editors-ides>
-   <https://docteur-michel.fr/latexr/spip.php?article4>
-   <https://www.gutenberg-asso.fr/Editeurs-pour-La-TeX>

[^1]: Dont ne fait pas partie [GNU
    TeXmacs](/6_distributions/editeurs/texmacs) !

[^2]: Autrefois, il fallait utiliser une extension telle que `ucs-latex`
    ou `omega` pour traiter les fichiers UTF-8, ou préciser l'encodage
    dans le préambule.

:::{todo}
Les liens qui suivent ne sont pas classés.
:::

-   [](/6_distributions/editeurs/introduction2)

```{toctree}
:glob: true
:maxdepth: 1
:hidden:

*/start
*
```
