/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.util;

import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.Map;

public final class ElkReflect {
    private static final Map<Class<?>, NewInstanceFunction> REGISTRY_NEW = Maps.newHashMap();
    private static final Map<Class<?>, CloneFunction> REGISTRY_CLONE = Maps.newHashMap();

    static {
        ElkReflect.registerClone(EnumSet.class, es -> ((EnumSet)es).clone());
    }

    private ElkReflect() {
    }

    public static void register(Class<?> clazz, NewInstanceFunction newFun, CloneFunction cloneFun) {
        if (clazz != null && newFun != null) {
            REGISTRY_NEW.put(clazz, newFun);
        }
        if (clazz != null && cloneFun != null) {
            REGISTRY_CLONE.put(clazz, cloneFun);
        }
    }

    public static void registerNewInstance(Class<?> clazz, NewInstanceFunction newFun) {
        ElkReflect.register(clazz, newFun, null);
    }

    public static void registerClone(Class<?> clazz, CloneFunction cloneFun) {
        ElkReflect.register(clazz, null, cloneFun);
    }

    public static <T> T newInstance(Class<T> clazz) {
        if (REGISTRY_NEW.containsKey(clazz)) {
            return (T)REGISTRY_NEW.get(clazz).newInstance();
        }
        return null;
    }

    public static <T> T clone(T clonee) {
        if (clonee instanceof EnumSet) {
            return (T)REGISTRY_CLONE.get(EnumSet.class).clone(clonee);
        }
        if (REGISTRY_CLONE.containsKey(clonee.getClass())) {
            return (T)REGISTRY_CLONE.get(clonee.getClass()).clone(clonee);
        }
        return null;
    }

    @FunctionalInterface
    public static interface CloneFunction {
        public Object clone(Object var1);
    }

    @FunctionalInterface
    public static interface NewInstanceFunction {
        public Object newInstance();
    }
}

