/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import org.eclipse.wst.css.core.internal.document.CSSDocumentImpl;
import org.eclipse.wst.css.core.internal.document.CSSNodeImpl;
import org.eclipse.wst.css.core.internal.document.CSSStyleDeclItemImpl;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclItem;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSValue;

class CSSStyleDeclarationImpl
extends CSSDocumentImpl
implements ICSSStyleDeclaration {
    private boolean fIsDocument;

    CSSStyleDeclarationImpl(CSSStyleDeclarationImpl that) {
        super(that);
        this.fIsDocument = that.fIsDocument;
        if (this.fIsDocument) {
            this.setOwnerDocument(this);
        }
    }

    CSSStyleDeclarationImpl(boolean isDocument) {
        this.fIsDocument = isDocument;
        if (this.fIsDocument) {
            this.setOwnerDocument(this);
        }
    }

    @Override
    public ICSSNode cloneNode(boolean deep) {
        CSSStyleDeclarationImpl cloned = new CSSStyleDeclarationImpl(this);
        if (deep) {
            this.cloneChildNodes(cloned, deep);
        }
        return cloned;
    }

    @Override
    public ICSSStyleDeclItem getDeclItemNode(String propertyName) {
        ICSSNode node = this.getLastChild();
        propertyName = propertyName.trim();
        while (node != null) {
            ICSSStyleDeclItem item;
            if (node instanceof CSSStyleDeclItemImpl && propertyName.compareToIgnoreCase((item = (ICSSStyleDeclItem)node).getPropertyName().trim()) == 0) {
                return item;
            }
            node = node.getPreviousSibling();
        }
        return null;
    }

    @Override
    public int getLength() {
        int i = 0;
        ICSSNode node = this.getFirstChild();
        while (node != null) {
            if (node instanceof CSSStyleDeclItemImpl) {
                ++i;
            }
            node = node.getNextSibling();
        }
        return i;
    }

    @Override
    public short getNodeType() {
        return 8;
    }

    @Override
    public CSSRule getParentRule() {
        ICSSNode parent = this.getParentNode();
        if (parent instanceof CSSRule) {
            return (CSSRule)((Object)parent);
        }
        return null;
    }

    @Override
    public CSSValue getPropertyCSSValue(String propertyName) {
        ICSSStyleDeclItem item = this.getDeclItemNode(propertyName);
        if (item != null) {
            return item.getCSSValue();
        }
        return null;
    }

    @Override
    public String getPropertyPriority(String propertyName) {
        ICSSStyleDeclItem item = this.getDeclItemNode(propertyName);
        if (item != null) {
            return item.getPriority();
        }
        return null;
    }

    @Override
    public String getPropertyValue(String propertyName) {
        CSSValue value = this.getPropertyCSSValue(propertyName);
        if (value != null) {
            return ((ICSSValue)value).getCSSValueText();
        }
        return null;
    }

    @Override
    public boolean isDocument() {
        return this.fIsDocument;
    }

    @Override
    public String item(int index) {
        if (index < 0) {
            return null;
        }
        int i = 0;
        ICSSNode node = this.getFirstChild();
        while (node != null) {
            if (node instanceof CSSStyleDeclItemImpl) {
                if (i != index) {
                    ++i;
                } else {
                    CSSStyleDeclItemImpl item = (CSSStyleDeclItemImpl)node;
                    return item.getPropertyName();
                }
            }
            node = node.getNextSibling();
        }
        return null;
    }

    @Override
    public ICSSStyleDeclItem removeDeclItemNode(ICSSStyleDeclItem oldDecl) throws DOMException {
        return (ICSSStyleDeclItem)((Object)this.removeChild((CSSNodeImpl)((Object)oldDecl)));
    }

    @Override
    public String removeProperty(String propertyName) throws DOMException {
        ICSSStyleDeclItem item = this.getDeclItemNode(propertyName);
        if (item != null) {
            this.removeChild((CSSNodeImpl)((Object)item));
            return item.getCssText();
        }
        return null;
    }

    @Override
    public ICSSStyleDeclItem setDeclItemNode(ICSSStyleDeclItem newDecl) throws DOMException {
        if (newDecl == null) {
            return null;
        }
        ICSSStyleDeclItem item = this.getDeclItemNode(newDecl.getPropertyName());
        if (item != null) {
            return (ICSSStyleDeclItem)((Object)this.replaceChild((CSSNodeImpl)((Object)newDecl), (CSSNodeImpl)((Object)item)));
        }
        return (ICSSStyleDeclItem)((Object)this.appendChild((CSSNodeImpl)((Object)newDecl)));
    }

    @Override
    public void setProperty(String propertyName, String value, String priority) throws DOMException {
        if (propertyName.equals("")) {
            throw new DOMException(7, "");
        }
        CSSStyleDeclItemImpl item = (CSSStyleDeclItemImpl)this.getDeclItemNode(propertyName);
        if (item == null) {
            item = (CSSStyleDeclItemImpl)this.getOwnerDocument().createCSSStyleDeclItem(propertyName);
            this.appendChild(item);
        }
        item.setCssValueText(value);
        item.setPriority(priority);
    }
}

