/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.core.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class ClassSecurity {
    public static ClassLoader getClassLoader(final Class clazz) {
        assert (clazz != null);
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
    }

    public static Class loadClass(final ClassLoader loader, final String className) throws ClassNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                @Override
                public Class run() throws ClassNotFoundException {
                    return loader.loadClass(className);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception typedException = e.getException();
            if (typedException instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)typedException;
            }
            return null;
        }
    }
}

