/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.parser.DesignParseState;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.AnyElementState;
import org.eclipse.birt.report.model.util.ElementStructureUtil;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.eclipse.birt.report.model.util.XMLParserHandler;
import org.xml.sax.Attributes;

class OverriddenValuesState
extends AbstractParseState {
    private ModuleParserHandler handler;
    private Map baseIdMap = new HashMap();

    OverriddenValuesState(ModuleParserHandler handler, DesignElement element) {
        this.handler = handler;
        assert (element.getExtendsElement() != null);
        this.baseIdMap = ElementStructureUtil.getIdMap(handler.module, element);
    }

    @Override
    public XMLParserHandler getHandler() {
        return this.handler;
    }

    @Override
    public AbstractParseState startElement(String tagName) {
        if ("ref-entry".equalsIgnoreCase(tagName)) {
            return new RefEntryState(this.handler);
        }
        return super.startElement(tagName);
    }

    class RefEntryState
    extends DesignParseState {
        private long baseId;
        private boolean isBaseValid;

        RefEntryState(ModuleParserHandler handler) {
            super(handler);
            this.baseId = 0L;
            this.isBaseValid = true;
        }

        @Override
        public XMLParserHandler getHandler() {
            return this.handler;
        }

        @Override
        public void parseAttrs(Attributes attrs) throws XMLParserException {
            String baseIdStr = attrs.getValue("baseId");
            if (baseIdStr == null) {
                return;
            }
            try {
                this.baseId = Long.parseLong(baseIdStr);
            }
            catch (NumberFormatException e) {
                DesignParserException ex = new DesignParserException(new String[]{baseIdStr}, "Error.DesignParserException.INVALID_ELEMENT_ID");
                this.handler.getErrorHandler().semanticError((Exception)((Object)ex));
                this.isBaseValid = false;
                return;
            }
            DesignElement virtualChild = this.getElement();
            if (virtualChild == null) {
                this.isBaseValid = false;
                DesignParserException ex = new DesignParserException(new String[]{baseIdStr}, "Error.DesignParserException.VIRTUAL_PARENT_NOT_FOUND");
                this.handler.getErrorHandler().semanticWarning((Exception)((Object)ex));
                return;
            }
            String name = attrs.getValue("name");
            if (!StringUtil.isBlank(name)) {
                virtualChild.setName(name);
            }
            try {
                String theID = attrs.getValue("id");
                if (!StringUtil.isBlank(theID)) {
                    long id = Long.parseLong(theID);
                    if (id <= 0L) {
                        this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException(new String[]{virtualChild.getIdentifier(), attrs.getValue("id")}, "Error.DesignParserException.INVALID_ELEMENT_ID")));
                    } else {
                        DesignElement theElement = this.handler.module.getElementByID(id);
                        if (theElement != null && this.handler.versionNumber >= 3020700 && theElement != virtualChild) {
                            this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException(new String[]{theElement.getIdentifier(), virtualChild.getIdentifier()}, "Error.DesignParserException.DUPLICATE_ELEMENT_ID")));
                        }
                        virtualChild.setID(id);
                    }
                }
            }
            catch (NumberFormatException e) {
                this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException(new String[]{virtualChild.getIdentifier(), attrs.getValue("id")}, "Error.DesignParserException.INVALID_ELEMENT_ID")));
            }
        }

        @Override
        public DesignElement getElement() {
            Object obj = OverriddenValuesState.this.baseIdMap.get(this.baseId);
            return (DesignElement)obj;
        }

        @Override
        public AbstractParseState startElement(String tagName) {
            if (!this.isBaseValid) {
                return new AnyElementState(this.getHandler());
            }
            return super.startElement(tagName);
        }
    }
}

