/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.validation.validators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.validation.StatusList;
import org.eclipse.bpmn2.modeler.core.validation.validators.IBpmn2ElementValidator;
import org.eclipse.bpmn2.modeler.core.validation.validators.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;

public abstract class AbstractBpmn2ElementValidator<T extends EObject>
implements IBpmn2ElementValidator<T> {
    protected AbstractBpmn2ElementValidator<?> parent;
    protected IValidationContext ctx;
    protected StatusList result = new StatusList();

    public AbstractBpmn2ElementValidator(IValidationContext ctx) {
        this.ctx = ctx;
    }

    public AbstractBpmn2ElementValidator(AbstractBpmn2ElementValidator<?> other) {
        this.parent = other.getParent();
        this.ctx = this.parent.ctx;
        this.result = this.parent.result;
    }

    public static IBpmn2ElementValidator<?> getValidator(IValidationContext ctx, Class<?> c) {
        String className = String.valueOf(AbstractBpmn2ElementValidator.class.getPackage().getName()) + "." + c.getSimpleName();
        if (className.endsWith("Impl")) {
            className = className.replaceFirst("Impl$", "");
        }
        className = String.valueOf(className) + "Validator";
        try {
            Class<?> validatorClass = AbstractBpmn2ElementValidator.class.getClassLoader().loadClass(className);
            if (validatorClass != null) {
                return (AbstractBpmn2ElementValidator)validatorClass.getConstructor(IValidationContext.class).newInstance(ctx);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static IBpmn2ElementValidator<?> getValidator(IBpmn2ElementValidator<?> parent, Class<?> c) {
        String className = String.valueOf(AbstractBpmn2ElementValidator.class.getPackage().getName()) + "." + c.getSimpleName();
        if (className.endsWith("Impl")) {
            className = className.replaceFirst("Impl$", "");
        }
        className = String.valueOf(className) + "Validator";
        try {
            Class<?> validatorClass = AbstractBpmn2ElementValidator.class.getClassLoader().loadClass(className);
            if (validatorClass != null) {
                return (AbstractBpmn2ElementValidator)validatorClass.getConstructor(AbstractBpmn2ElementValidator.class).newInstance(parent);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    protected AbstractBpmn2ElementValidator() {
    }

    protected void addStatus(EObject object, EObject[] resultLocus, int severity, String messagePattern, Object ... messageArguments) {
        ConstraintStatus status = ConstraintStatus.createStatus((IValidationContext)this.ctx, (EObject)object, Arrays.asList(resultLocus), (int)severity, (int)0, (String)messagePattern, (Object[])messageArguments);
        this.addStatus((IStatus)status);
    }

    protected void addStatus(EObject object, int severity, String messagePattern, Object ... messageArguments) {
        ConstraintStatus status = ConstraintStatus.createStatus((IValidationContext)this.ctx, (EObject)object, null, (int)severity, (int)0, (String)messagePattern, (Object[])messageArguments);
        this.addStatus((IStatus)status);
    }

    protected void addStatus(EObject object, String featureName, int severity, String messagePattern, Object ... messageArguments) {
        ArrayList<EStructuralFeature> resultLocus = null;
        resultLocus = new ArrayList<EStructuralFeature>();
        EStructuralFeature feature = object.eClass().getEStructuralFeature(featureName);
        if (feature != null) {
            resultLocus.add(feature);
        }
        ConstraintStatus status = ConstraintStatus.createStatus((IValidationContext)this.ctx, (EObject)object, resultLocus, (int)severity, (int)0, (String)messagePattern, (Object[])messageArguments);
        this.addStatus((IStatus)status);
    }

    protected void addStatus(EObject object, String featureName, EObject[] resultLocus, int severity, String messagePattern, Object ... messageArguments) {
        ArrayList<Object> rsltLocus = null;
        rsltLocus = new ArrayList<Object>();
        rsltLocus.addAll(Arrays.asList(resultLocus));
        EStructuralFeature feature = object.eClass().getEStructuralFeature(featureName);
        if (feature != null) {
            rsltLocus.add(feature);
        }
        ConstraintStatus status = ConstraintStatus.createStatus((IValidationContext)this.ctx, (EObject)object, rsltLocus, (int)severity, (int)0, (String)messagePattern, (Object[])messageArguments);
        this.addStatus((IStatus)status);
    }

    protected void addMissingFeatureStatus(EObject object, String featureName, int severity) {
        EStructuralFeature feature = object.eClass().getEStructuralFeature(featureName);
        String message = feature != null && feature.getEType() == Bpmn2Package.eINSTANCE.getSequenceFlow() ? Messages.AbstractBpmn2ElementValidator_Object_Missing_Connections : Messages.AbstractBpmn2ElementValidator_Object_Missing_Feature;
        if (feature != null) {
            featureName = this.getLabel(object, feature);
        }
        this.addStatus(object, featureName, severity, message, this.getLabel(object), this.getName(object), featureName);
    }

    protected void addMissingFeatureStatus(EObject object, String featureName, EObject[] resultLocus, int severity) {
        EStructuralFeature feature = object.eClass().getEStructuralFeature(featureName);
        String message = feature != null && feature.getEType() == Bpmn2Package.eINSTANCE.getSequenceFlow() ? Messages.AbstractBpmn2ElementValidator_Object_Missing_Connections : Messages.AbstractBpmn2ElementValidator_Object_Missing_Feature;
        if (feature != null) {
            featureName = this.getLabel(object, feature);
        }
        this.addStatus(object, featureName, resultLocus, severity, message, this.getLabel(object), this.getName(object), featureName);
    }

    protected void addStatus(IStatus status) {
        if (status.getSeverity() != 0) {
            this.result.add(status);
        }
    }

    @Override
    public IStatus getResult() {
        if (this.result.isEmpty()) {
            return this.ctx.createSuccessStatus();
        }
        if (this.result.size() == 1) {
            return (IStatus)this.result.get(0);
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)this.ctx, (Collection)this.result);
    }

    protected AbstractBpmn2ElementValidator<?> getParent() {
        if (this.parent == null) {
            return this;
        }
        return this.parent;
    }

    protected String getLabel(EObject object) {
        return ExtendedPropertiesProvider.getLabel(object);
    }

    protected String getLabel(EObject object, EStructuralFeature feature) {
        return ExtendedPropertiesProvider.getLabel(object, feature);
    }

    protected String getName(EObject object) {
        return ExtendedPropertiesProvider.getTextValue(object);
    }

    protected static boolean isEmpty(Object object) {
        String w;
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            String str = (String)object;
            return str == null || str.isEmpty();
        }
        if (object instanceof List) {
            return ((List)object).isEmpty();
        }
        return ModelUtil.isStringWrapper(object) && ((w = ModelUtil.getStringWrapperValue(object)) == null || w.isEmpty());
    }

    @Override
    public abstract IStatus validate(T var1);

    @Override
    public boolean checkSuperType(EClass eClass, T object) {
        return false;
    }

    protected boolean isLiveValidation() {
        return this.ctx.getEventType() != EMFEventType.NULL;
    }

    @Override
    public boolean doLiveValidation() {
        return false;
    }
}

