/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib.constraints;

import com.google.gson.annotations.Expose;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;

public class CRuleError {
    @Expose
    private String ruleName;
    @Expose
    private String errorMessage;
    private CObservedMessage firstEvent;
    private CObservedMessage lastEvent;
    @Expose
    private String umlFile;

    public CRuleError(String ruleName, String message, CObservedMessage firstEvent, CObservedMessage lastEvent) {
        this.ruleName = ruleName;
        this.errorMessage = message;
        this.firstEvent = firstEvent;
        this.lastEvent = lastEvent;
    }

    public CRuleError setUMLFile(String file) {
        this.umlFile = file;
        return this;
    }

    public String errorSummary() {
        return "Time/data constraint violation.";
    }

    public String toString() {
        String result = "";
        result = String.valueOf(result) + "Warning: constraint violated. Rule: " + this.ruleName + "\n";
        result = String.valueOf(result) + "=================================\n";
        result = String.valueOf(result) + this.errorMessage + "\n\n";
        result = String.valueOf(result) + "Trace:\n";
        if (this.firstEvent != this.lastEvent) {
            result = String.valueOf(result) + this.firstEvent.printStringWithState() + "\n";
            result = String.valueOf(result) + "... messages...\n";
            result = String.valueOf(result) + this.lastEvent.toString();
        } else {
            result = String.valueOf(result) + this.firstEvent.printStringWithState();
        }
        return result;
    }

    public String toUML() {
        String result = "";
        result = String.valueOf(result) + "@startuml\n";
        result = String.valueOf(result) + "title Warning (rule " + this.ruleName + "): " + this.errorMessage + "\n";
        if (this.firstEvent != this.lastEvent) {
            result = String.valueOf(result) + "group Event sequence\n";
            result = String.valueOf(result) + this.firstEvent.printUMLWithTimeAndState() + "\n";
            result = String.valueOf(result) + "... messages ...\n";
            result = String.valueOf(result) + this.lastEvent.printUMLWithTime() + "\n";
            result = String.valueOf(result) + "end\n";
        } else {
            result = String.valueOf(result) + this.firstEvent.printUMLWithTimeAndState() + "\n";
        }
        result = String.valueOf(result) + "@enduml\n";
        return result;
    }
}

