/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.dirigible.ide.shared.editor.EditorUtil;
import org.eclipse.dirigible.ide.workspace.dual.EditorInputFactory;
import org.eclipse.dirigible.ide.workspace.ui.commands.Messages;
import org.eclipse.dirigible.repository.api.ContentTypeHelper;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public class OpenHandler
extends AbstractHandler {
    private static final String OPEN_FAILURE2 = Messages.OpenHandler_OPEN_FAILURE2;
    private static final String BINARY_FILES_ARE_NOT_SUPPORTED = Messages.OpenHandler_BINARY_FILES_ARE_NOT_SUPPORTED;
    private static final Logger logger = Logger.getLogger(OpenHandler.class);
    private static final String COULD_NOT_OPEN_ONE_OR_MORE_FILES = Messages.OpenHandler_COULD_NOT_OPEN_ONE_OR_MORE_FILES;
    private static final String SOURCE_CODE_EDITOR_ID = "org.eclipse.dirigible.ide.editor.orion.OrionEditor";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean successful = true;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                successful = element instanceof IFile ? (successful &= this.openEditorFor(element) != null) : (successful &= true);
                ++n2;
            }
        }
        if (!successful) {
            logger.error(COULD_NOT_OPEN_ONE_OR_MORE_FILES);
            MessageDialog.openError(null, (String)OPEN_FAILURE2, (String)COULD_NOT_OPEN_ONE_OR_MORE_FILES);
        }
        return null;
    }

    public static IEditorPart open(Object element, int row) {
        OpenHandler handler = new OpenHandler();
        if (element instanceof IFile) {
            return handler.openEditorForResource((IFile)element, row);
        }
        return null;
    }

    public IEditorPart openEditorFor(Object element) {
        if (element instanceof IFile) {
            return this.openEditorForResource((IFile)element, 0);
        }
        return null;
    }

    private IEditorPart openEditorForResource(IFile file, int row) {
        String editorId = EditorUtil.getEditorIdForExtension((String)file.getFileExtension());
        String contentType = ContentTypeHelper.getContentType((String)file.getFileExtension());
        if (editorId == null) {
            if (contentType != null && contentType.contains("text")) {
                editorId = SOURCE_CODE_EDITOR_ID;
            } else {
                logger.error(BINARY_FILES_ARE_NOT_SUPPORTED);
                editorId = "org.eclipse.dirigible.ide.editor.text.editor.TextEditor";
            }
        }
        FileEditorInput input = EditorInputFactory.createInput((IFile)file, (int)row, (String)contentType);
        return this.openEditor(editorId, (IEditorInput)input);
    }

    private IEditorPart openEditor(String id, IEditorInput input) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        try {
            String targetEditorId = id;
            Object descriptor = this.findSourceCodeEditor(id, workbench);
            if (descriptor == null) {
                descriptor = this.findSourceCodeEditor("org.eclipse.dirigible.ide.editor.text.editor.TextEditor", workbench);
                targetEditorId = "org.eclipse.dirigible.ide.editor.text.editor.TextEditor";
            } else {
                targetEditorId = id;
            }
            IEditorPart editorPart = null;
            editorPart = page.openEditor(input, targetEditorId);
            return editorPart;
        }
        catch (PartInitException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Object findSourceCodeEditor(String id, IWorkbench workbench) {
        IEditorDescriptor descriptor = workbench.getEditorRegistry().findEditor(id);
        return descriptor;
    }
}

