/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.launching;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.ui.console.ScriptConsole;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class EaseLaunchDelegate
implements ILaunchShortcut,
ILaunchShortcut2,
ILaunchConfigurationDelegate {
    private static final String LAUNCH_CONFIGURATION_ID = "org.eclipse.ease.launchConfigurationType";

    public final void launch(IEditorPart editor, String mode) {
        this.launch(this.getLaunchableResource(editor), mode);
    }

    public final void launch(ISelection selection, String mode) {
        this.launch(this.getLaunchableResource(selection), mode);
    }

    public final IResource getLaunchableResource(IEditorPart editorpart) {
        IEditorInput input = editorpart.getEditorInput();
        if (input instanceof FileEditorInput) {
            return ((FileEditorInput)input).getFile();
        }
        return null;
    }

    public final IResource getLaunchableResource(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IFile) {
                    return (IResource)element;
                }
                ++n2;
            }
        }
        return null;
    }

    public final ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        return this.getLaunchConfgurations(this.getLaunchableResource(editorpart), "run");
    }

    public final ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return this.getLaunchConfgurations(this.getLaunchableResource(selection), "run");
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Object resource = ResourceTools.getResource((String)configuration.getAttribute("File location", ""));
        if (resource != null) {
            this.launch(resource, configuration, mode, launch, monitor);
        }
    }

    private ILaunchConfiguration[] getLaunchConfgurations(IResource resource, String mode) {
        ArrayList<ILaunchConfiguration> configurations = new ArrayList<ILaunchConfiguration>();
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(LAUNCH_CONFIGURATION_ID);
        String resourceLocation = ResourceTools.toAbsoluteLocation((Object)resource, null);
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = manager.getLaunchConfigurations(type);
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                try {
                    String configurationUri = configuration.getAttribute("File location", "");
                    if (resourceLocation.equals(configurationUri)) {
                        if ("debug".equals(mode)) {
                            String engineID = configuration.getAttribute("Script engine", "");
                            IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
                            EngineDescription engineDescription = scriptService.getEngineByID(engineID);
                            if (engineDescription.supportsDebugging()) {
                                configurations.add(configuration);
                            }
                        } else {
                            configurations.add(configuration);
                        }
                    }
                }
                catch (CoreException coreException) {}
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return configurations.toArray(new ILaunchConfiguration[configurations.size()]);
    }

    private void launch(IResource file, String mode) {
        if (file instanceof IFile) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().saveAllEditors(true);
            try {
                ILaunchConfiguration[] configurations = this.getLaunchConfgurations(file, mode);
                if (configurations.length == 0) {
                    ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
                    ILaunchConfigurationType type = manager.getLaunchConfigurationType(LAUNCH_CONFIGURATION_ID);
                    ILaunchConfigurationWorkingCopy configuration = type.newInstance(null, file.getName());
                    configuration.setAttribute("File location", ResourceTools.toAbsoluteLocation((Object)file, null));
                    IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
                    List engines = scriptService.getScriptType(ResourceTools.toAbsoluteLocation((Object)file, null)).getEngines();
                    if (engines.isEmpty()) {
                        throw new CoreException(Status.CANCEL_STATUS);
                    }
                    configuration.setAttribute("Script engine", ((EngineDescription)engines.iterator().next()).getID());
                    configuration.doSave();
                    configurations = new ILaunchConfiguration[]{configuration};
                }
                configurations[0].launch(mode, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                this.launch(file, null, mode, null, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    private void launch(Object resource, ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) {
        try {
            String parameterString;
            String engineID = configuration.getAttribute("Script engine", "");
            IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
            IScriptEngine engine = scriptService.getEngineByID(engineID).createEngine();
            ScriptConsole console = ScriptConsole.create(String.valueOf(engine.getName()) + ": " + resource, engine);
            engine.setOutputStream((OutputStream)console.getOutputStream());
            engine.setErrorStream((OutputStream)console.getErrorStream());
            engine.setTerminateOnIdle(true);
            if ("debug".equals(mode)) {
                this.setupDebugger(engine, configuration, launch);
            }
            String[] parameters = !(parameterString = configuration.getAttribute("Startup parameters", "").trim()).isEmpty() ? parameterString.split("\\s+") : new String[]{};
            engine.setVariable("argv", (Object)parameters);
            engine.executeAsync(resource);
            engine.schedule();
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private void setupDebugger(IScriptEngine engine, ILaunchConfiguration configuration, ILaunch launch) {
        if (engine instanceof IDebugEngine) {
            boolean suspendOnStartup = false;
            try {
                suspendOnStartup = configuration.getAttribute("Suspend on startup", false);
            }
            catch (CoreException coreException) {}
            boolean suspendOnScriptLoad = false;
            try {
                suspendOnScriptLoad = configuration.getAttribute("Suspend on script load", false);
            }
            catch (CoreException coreException) {}
            boolean showDynamicCode = false;
            try {
                showDynamicCode = configuration.getAttribute("Display dynamic code", false);
            }
            catch (CoreException coreException) {}
            ((IDebugEngine)engine).setupDebugger(launch, suspendOnStartup, suspendOnScriptLoad, showDynamicCode);
        }
    }
}

