/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ease.IScriptable;
import org.eclipse.ease.ScriptResult;

public class Script {
    private final Object fCommand;
    private final ScriptResult fResult;
    private String fCodeBuffer = null;
    private final String fTitle;

    public Script(String title, Object command) {
        this.fTitle = title;
        this.fCommand = command;
        this.fResult = new ScriptResult();
    }

    public Script(Object command) {
        this(null, command);
    }

    public InputStream getCodeStream() throws Exception {
        return new ByteArrayInputStream(this.getCode().getBytes());
    }

    public String getCode() throws Exception {
        if (this.fCodeBuffer != null) {
            return this.fCodeBuffer;
        }
        if (this.fCommand instanceof String) {
            return (String)this.fCommand;
        }
        if (this.fCommand instanceof InputStream) {
            return this.bufferStream((InputStream)this.fCommand);
        }
        if (this.fCommand instanceof Reader) {
            return this.bufferReader((Reader)this.fCommand);
        }
        if (this.fCommand instanceof IScriptable) {
            return this.bufferStream(((IScriptable)this.fCommand).getSourceCode());
        }
        Object scriptable = Platform.getAdapterManager().getAdapter(this.fCommand, IScriptable.class);
        if (scriptable != null) {
            return this.bufferStream(((IScriptable)scriptable).getSourceCode());
        }
        if (this.fCommand != null) {
            this.fCodeBuffer = this.fCommand.toString();
            return this.fCodeBuffer;
        }
        return null;
    }

    private String bufferReader(Reader command) throws IOException {
        this.fCodeBuffer = Script.toString(command);
        return this.fCodeBuffer;
    }

    private String bufferStream(InputStream command) throws IOException {
        this.fCodeBuffer = Script.toString(command);
        return this.fCodeBuffer;
    }

    public final Object getCommand() {
        return this.fCommand;
    }

    public final ScriptResult getResult() {
        return this.fResult;
    }

    public final void setResult(Object result) {
        this.fResult.setResult(result);
        if (this.fCommand instanceof InputStream) {
            try {
                ((InputStream)this.fCommand).close();
            }
            catch (IOException iOException) {}
        } else if (this.fCommand instanceof Reader) {
            try {
                ((Reader)this.fCommand).close();
            }
            catch (IOException iOException) {}
        }
    }

    public final void setException(Exception e) {
        this.fResult.setException(e);
        if (this.fCommand instanceof InputStream) {
            try {
                ((InputStream)this.fCommand).close();
            }
            catch (IOException iOException) {}
        } else if (this.fCommand instanceof Reader) {
            try {
                ((Reader)this.fCommand).close();
            }
            catch (IOException iOException) {}
        }
    }

    public Object getFile() {
        if (this.fCommand instanceof IFile || this.fCommand instanceof File) {
            return this.fCommand;
        }
        return null;
    }

    public boolean isDynamic() {
        return !(this.fCommand instanceof URL) && this.getFile() == null;
    }

    private static String toString(InputStream stream) throws IOException {
        return Script.toString(new InputStreamReader(stream));
    }

    private static String toString(Reader reader) throws IOException {
        StringBuffer out = new StringBuffer();
        char[] buffer = new char[1024];
        int bytes = 0;
        do {
            if ((bytes = reader.read(buffer)) <= 0) continue;
            out.append(buffer, 0, bytes);
        } while (bytes != -1);
        return out.toString();
    }

    public String toString() {
        if (this.fCommand instanceof IFile) {
            return ((IFile)this.fCommand).getName();
        }
        if (this.fCommand instanceof File) {
            return ((File)this.fCommand).getName();
        }
        return "(unknown script source)";
    }

    public String getTitle() {
        return this.fTitle;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fCommand == null ? 0 : this.fCommand.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Script other = (Script)obj;
        return !(this.fCommand == null ? other.fCommand != null : !this.fCommand.equals(other.fCommand));
    }
}

