/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ease.debugging.IEventProcessor;
import org.eclipse.ease.debugging.events.IDebugEvent;
import org.eclipse.ease.debugging.events.IDebuggerEvent;
import org.eclipse.ease.debugging.events.IModelRequest;

public class EventDispatchJob
extends Job {
    private static final boolean DEBUG = true;
    private final List<IDebugEvent> fEvents = new ArrayList<IDebugEvent>();
    private boolean fTerminated = false;
    private final IEventProcessor fHost;
    private final IEventProcessor fDebugger;

    public EventDispatchJob(IEventProcessor host, IEventProcessor debugger) {
        super(debugger + " event dispatcher");
        this.fHost = host;
        this.fDebugger = debugger;
        this.setSystem(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(IDebugEvent event) {
        List<IDebugEvent> list = this.fEvents;
        synchronized (list) {
            if (!this.fEvents.contains(event)) {
                if (event instanceof IDebuggerEvent) {
                    System.out.println("Debugger ---> " + event);
                } else if (event instanceof IModelRequest) {
                    System.out.println("Target   ---> " + event);
                }
                this.fEvents.add(event);
                this.fEvents.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        while (!this.fTerminated) {
            if (!monitor.isCanceled()) {
                IDebugEvent event = null;
                List<IDebugEvent> list = this.fEvents;
                synchronized (list) {
                    if (!this.fEvents.isEmpty()) {
                        event = this.fEvents.remove(0);
                    }
                }
                if (event != null) {
                    this.handleEvent(event);
                }
            } else {
                this.terminate();
            }
            List<IDebugEvent> list = this.fEvents;
            synchronized (list) {
                if (this.fEvents.isEmpty()) {
                    try {
                        this.fEvents.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        return Status.OK_STATUS;
    }

    private void handleEvent(IDebugEvent event) {
        if (event instanceof IDebuggerEvent) {
            System.out.println("\t\t! Target  : " + event);
        } else if (event instanceof IModelRequest) {
            System.out.println("\t\t! Debugger: " + event);
        }
        if (event instanceof IDebuggerEvent) {
            this.fHost.handleEvent(event);
        } else if (event instanceof IModelRequest) {
            this.fDebugger.handleEvent(event);
        } else {
            throw new RuntimeException("Unknown event detected: " + event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.fTerminated = true;
        EventDispatchJob eventDispatchJob = this;
        synchronized (eventDispatchJob) {
            ((Object)((Object)this)).notifyAll();
        }
    }
}

