/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class ResourceTools {
    private static final String PROJECT_SCHEME = "project";

    @Deprecated
    private ResourceTools() {
    }

    public static Object resolveFile(Object location, Object parent, boolean exists) {
        Object candidate;
        if (location == null) {
            return null;
        }
        Object parentObject = parent;
        if (parent != null && !(parent instanceof IResource) && !(parent instanceof File) && (parentObject = ResourceTools.resolveFile(parent, null, true)) == null) {
            parentObject = ResourceTools.resolveFolder(parent, null, true);
        }
        if ((candidate = ResourceTools.resolveAbsolute(location, parentObject, false)) == null && parentObject != null) {
            candidate = ResourceTools.resolveRelativeFile(location, parentObject, exists);
        }
        if (candidate instanceof IFile) {
            return ((IFile)candidate).exists() || !exists ? candidate : null;
        }
        if (candidate instanceof File && (((File)candidate).isFile() || !exists)) {
            return ((File)candidate).exists() || !exists ? candidate : null;
        }
        return null;
    }

    public static Object resolveFolder(Object location, Object parent, boolean exists) {
        Object candidate;
        if (location == null) {
            return null;
        }
        Object parentObject = parent;
        if (parent != null && !(parent instanceof IResource) && !(parent instanceof File) && (parentObject = ResourceTools.resolveFile(parent, null, true)) == null) {
            parentObject = ResourceTools.resolveFolder(parent, null, true);
        }
        if ((candidate = ResourceTools.resolveAbsolute(location, parentObject, true)) == null && parentObject != null) {
            candidate = ResourceTools.resolveRelativeFolder(location, parentObject, exists);
        }
        if (candidate instanceof IContainer) {
            return ((IContainer)candidate).exists() || !exists ? candidate : null;
        }
        if (candidate instanceof File && (((File)candidate).isDirectory() || !exists)) {
            return ((File)candidate).exists() || !exists ? candidate : null;
        }
        return null;
    }

    private static Object resolveAbsolute(Object location, Object parent, boolean isFolder) {
        if (location instanceof IFile) {
            return location;
        }
        if (location instanceof String) {
            try {
                location = URI.create((String)location);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (location instanceof URI) {
            try {
                location = new File((URI)location);
            }
            catch (Exception exception) {}
        }
        if (location instanceof File) {
            return location;
        }
        String reference = location.toString();
        if (reference.startsWith(PROJECT_SCHEME)) {
            if (parent instanceof IResource) {
                if (isFolder) {
                    return ((IResource)parent).getProject().getFolder((IPath)new Path(reference.substring(PROJECT_SCHEME.length() + 3)));
                }
                return ((IResource)parent).getProject().getFile((IPath)new Path(reference.substring(PROJECT_SCHEME.length() + 3)));
            }
        } else {
            if (reference.startsWith("workspace")) {
                if (isFolder) {
                    Path path = new Path(reference.substring("workspace".length() + 3));
                    if (path.segmentCount() > 1) {
                        return ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
                    }
                    return ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                }
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(reference.substring("workspace".length() + 3)));
            }
            File systemFile = new File(reference);
            if (systemFile.isAbsolute()) {
                return systemFile;
            }
        }
        return null;
    }

    private static Object resolveRelativeFile(Object location, Object parent, boolean exists) {
        String reference = location.toString();
        if (parent instanceof IResource) {
            IFile relativeFile = null;
            if (parent instanceof IContainer) {
                relativeFile = ((IContainer)parent).getFile((IPath)new Path(reference));
            } else if (parent instanceof IResource) {
                relativeFile = ((IResource)parent).getParent().getFile((IPath)new Path(reference));
            }
            if (relativeFile.exists() || !exists) {
                return relativeFile;
            }
        } else if (parent instanceof File) {
            File systemFile = null;
            systemFile = ((File)parent).isDirectory() ? new File(String.valueOf(((File)parent).getAbsolutePath()) + File.separator + reference) : new File(String.valueOf(((File)parent).getParentFile().getAbsolutePath()) + File.separator + reference);
            if (systemFile.exists() && systemFile.isFile() || !exists) {
                return systemFile;
            }
        }
        return null;
    }

    private static Object resolveRelativeFolder(Object location, Object parent, boolean exists) {
        String reference = location.toString();
        if (parent instanceof IResource) {
            IFolder relativeFolder = null;
            if (parent instanceof IContainer) {
                relativeFolder = ((IContainer)parent).getFolder((IPath)new Path(reference));
            } else if (parent instanceof IResource) {
                relativeFolder = ((IResource)parent).getParent().getFolder((IPath)new Path(reference));
            }
            if (relativeFolder.exists() || !exists) {
                return relativeFolder;
            }
        } else if (parent instanceof File) {
            File systemFolder = null;
            systemFolder = ((File)parent).isDirectory() ? new File(String.valueOf(((File)parent).getAbsolutePath()) + File.separator + reference) : new File(String.valueOf(((File)parent).getParentFile().getAbsolutePath()) + File.separator + reference);
            if (systemFolder.exists() && systemFolder.isDirectory() || !exists) {
                return systemFolder;
            }
        }
        return null;
    }

    public static String toAbsoluteLocation(Object location, Object parent) {
        Object file = ResourceTools.resolveFile(location, parent, true);
        if (file instanceof IResource) {
            return "workspace:/" + ((IResource)file).getFullPath().toPortableString();
        }
        if (file instanceof File) {
            return ((File)file).toURI().toASCIIString();
        }
        Object folder = ResourceTools.resolveFolder(location, parent, true);
        if (folder instanceof IResource) {
            return "workspace:/" + ((IResource)folder).getFullPath().toPortableString();
        }
        if (folder instanceof File) {
            return ((File)file).toURI().toASCIIString();
        }
        return location.toString();
    }

    public static boolean exists(String location) {
        if (ResourceTools.resolveFile(location, null, true) != null) {
            return true;
        }
        try {
            URI uri = URI.create(location);
            InputStream stream = uri.toURL().openStream();
            if (stream != null) {
                stream.close();
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public static Object getResource(String location) {
        Object file = ResourceTools.resolveFile(location, null, true);
        if (file != null) {
            return file;
        }
        file = ResourceTools.resolveFolder(location, null, true);
        if (file != null) {
            return file;
        }
        try {
            return URI.create(location);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static InputStream getInputStream(String location) {
        try {
            Object resource = ResourceTools.getResource(location);
            if (resource instanceof IFile) {
                return ((IFile)resource).getContents();
            }
            if (resource instanceof File) {
                return new FileInputStream((File)resource);
            }
            if (resource instanceof URI) {
                return ((URI)resource).toURL().openStream();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static URI toURI(IPath path) {
        if (path == null) {
            return null;
        }
        if (path.isAbsolute()) {
            return ResourceTools.toURI(path.toFile().getAbsolutePath());
        }
        try {
            return new URI(ResourceTools.escapeColons(path.toString()));
        }
        catch (URISyntaxException uRISyntaxException) {
            return ResourceTools.toURI(path.toFile().getAbsolutePath());
        }
    }

    public static URI toURI(String pathString) {
        if (File.separatorChar != '/') {
            pathString = pathString.replace(File.separatorChar, '/');
        }
        int length = pathString.length();
        StringBuffer pathBuf = new StringBuffer(length + 1);
        if (length > 0 && pathString.charAt(0) != '/') {
            pathBuf.append('/');
        }
        if (pathString.startsWith("//")) {
            pathBuf.append('/').append('/');
        }
        pathBuf.append(pathString);
        try {
            return new URI("file", null, pathBuf.toString(), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(pathString).toURI();
        }
    }

    private static String escapeColons(String string) {
        if (string.indexOf(58) == -1) {
            return string;
        }
        int length = string.length();
        StringBuffer result = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            char c = string.charAt(i);
            if (c == ':') {
                result.append("%3A");
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static IPath toPath(String location) {
        Object resource = ResourceTools.resolveAbsolute(location, null, true);
        if (resource == null) {
            resource = ResourceTools.resolveAbsolute(location, null, false);
        }
        return resource instanceof IResource ? ((IResource)resource).getFullPath() : null;
    }
}

