/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.modeling;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class EMFMarkerUtil {
    private EMFMarkerUtil() {
    }

    public static void addMarkerFor(EObject toLog, String message, int severity) throws CoreException {
        IResource resource = EMFMarkerUtil.findResourceFor(toLog);
        if (resource != null) {
            IMarker marker = resource.createMarker("org.eclipse.emf.ecore.diagnostic");
            marker.setAttribute("severity", severity);
            marker.setAttribute("uri", (Object)EcoreUtil.getURI((EObject)toLog).toString());
            marker.setAttribute("message", (Object)message);
        } else {
            StringBuffer uriMessage = new StringBuffer();
            if (toLog.eResource() != null && toLog.eResource().getURI() != null) {
                URI uri = toLog.eResource().getURI();
                uriMessage.append(" ").append(uri.toString());
                if (uri.isFile() || uri.isPlatform()) {
                    Status status = new Status(4, "org.eclipse.ease.modules.modeling", 4, "Cannot create marker for resource" + uriMessage.toString(), null);
                    throw new CoreException((IStatus)status);
                }
            }
        }
    }

    public static void removeMarkerFor(EObject toRemove) throws CoreException {
        IResource resource = EMFMarkerUtil.findResourceFor(toRemove);
        if (resource != null) {
            IMarker[] iMarkerArray = resource.findMarkers("org.eclipse.emf.ecore.diagnostic", false, 2);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                String markerUri = (String)marker.getAttribute("uri");
                if (markerUri != null && markerUri.equals(EcoreUtil.getURI((EObject)toRemove).toString())) {
                    marker.delete();
                }
                ++n2;
            }
        } else {
            Status status = new Status(4, "org.eclipse.ease.modules.modeling", "Cannot delete marker from a null resource");
            throw new CoreException((IStatus)status);
        }
    }

    public static void removeAllMarkersFor(Resource resource) throws CoreException {
        IResource file = EMFMarkerUtil.findResourceFor(resource);
        if (file != null) {
            IMarker[] iMarkerArray = file.findMarkers("org.eclipse.emf.ecore.diagnostic", false, 2);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                marker.delete();
                ++n2;
            }
        } else {
            Status status = new Status(4, "org.eclipse.ease.modules.modeling", "Cannot delete markers from a null resource");
            throw new CoreException((IStatus)status);
        }
    }

    public static IResource findResourceFor(EObject toResolve) {
        return EMFMarkerUtil.findResourceFor(toResolve.eResource());
    }

    private static IResource findResourceFor(Resource toResolve) {
        String relativePath;
        if (toResolve != null && (relativePath = toResolve.getURI().toPlatformString(true)) != null) {
            return ResourcesPlugin.getWorkspace().getRoot().findMember(relativePath);
        }
        return null;
    }
}

