/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.modules.IEnvironment;
import org.eclipse.ease.modules.IScriptFunctionModifier;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;

public abstract class AbstractCodeFactory
implements ICodeFactory {
    protected String getParameterName(Annotation[] parameterAnnotations) {
        Annotation[] annotationArray = parameterAnnotations;
        int n = parameterAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annot = annotationArray[n2];
            if (annot instanceof ScriptParameter) {
                ScriptParameter namedParameter = (ScriptParameter)annot;
                return namedParameter.name();
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String getDefaultValue(ICodeFactory.Parameter parameter) {
        String defaultStringValue = parameter.getDefaultValue().replaceAll("\\r", "\\\\r").replaceAll("\\n", "\\\\n");
        Class<String> clazz = parameter.getClazz();
        if ("org.eclipse.ease.modules.ScriptParameter.null".equals(defaultStringValue)) {
            return this.getNullString();
        }
        if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
            try {
                return Integer.toString(Integer.parseInt(defaultStringValue));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
            try {
                return Long.toString(Long.parseLong(defaultStringValue));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (Float.class.equals(clazz) || Float.TYPE.equals(clazz)) {
            try {
                return Float.toString(Float.parseFloat(defaultStringValue));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
            try {
                return Double.toString(Double.parseDouble(defaultStringValue));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
            return Boolean.parseBoolean(defaultStringValue) ? this.getTrueString() : this.getFalseString();
        }
        if ("org.eclipse.ease.modules.ScriptParameter.undefined".equals(defaultStringValue)) {
            try {
                clazz.getConstructor(new Class[0]);
                return this.classInstantiation(clazz, null);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        try {
            clazz.getConstructor(String.class);
            return this.classInstantiation(clazz, new String[]{"\"" + defaultStringValue + "\""});
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (clazz.isAssignableFrom(String.class)) {
            return this.classInstantiation(String.class, new String[]{"\"" + defaultStringValue + "\""});
        }
        return this.getNullString();
    }

    public static Collection<String> getMethodNames(Method method) {
        HashSet<String> methodNames = new HashSet<String>();
        methodNames.add(method.getName());
        WrapToScript wrapAnnotation = method.getAnnotation(WrapToScript.class);
        if (wrapAnnotation != null) {
            String[] stringArray = wrapAnnotation.alias().split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (!name.trim().isEmpty()) {
                    methodNames.add(name.trim());
                }
                ++n2;
            }
        }
        return methodNames;
    }

    public static String getPreExecutionCode(IEnvironment environment, Method method) {
        StringBuffer code = new StringBuffer();
        for (Object module : environment.getModules()) {
            if (!(module instanceof IScriptFunctionModifier)) continue;
            code.append(((IScriptFunctionModifier)module).getPreExecutionCode(method));
        }
        return code.toString();
    }

    public static String getPostExecutionCode(IEnvironment environment, Method method) {
        StringBuffer code = new StringBuffer();
        for (Object module : environment.getModules()) {
            if (!(module instanceof IScriptFunctionModifier)) continue;
            code.append(((IScriptFunctionModifier)module).getPostExecutionCode(method));
        }
        return code.toString();
    }

    protected abstract String getNullString();

    protected String getTrueString() {
        return Boolean.TRUE.toString();
    }

    protected String getFalseString() {
        return Boolean.FALSE.toString();
    }

    @Override
    public String createFunctionCall(Method method, Object ... parameters) {
        StringBuilder code = new StringBuilder();
        code.append(method.getName()).append('(');
        Object[] objectArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Object parameter = objectArray[n2];
            if (parameter instanceof String) {
                code.append('\"').append(((String)parameter).replace("\"", "\\\"")).append('\"');
            } else if (parameter == null) {
                code.append(this.getNullString());
            } else {
                code.append(parameter.toString());
            }
            code.append(", ");
            ++n2;
        }
        if (parameters.length > 0) {
            code.delete(code.length() - 2, code.length());
        }
        code.append(");");
        return code.toString();
    }
}

