/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.ui.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.ease.modules.unittest.components.TestSuiteModel;
import org.eclipse.ease.modules.unittest.ui.editor.AbstractEditorPage;
import org.eclipse.ease.modules.unittest.ui.editor.VariablesDragListener;
import org.eclipse.ease.modules.unittest.ui.editor.VariablesDropSupport;
import org.eclipse.ease.modules.unittest.ui.editor.VariablesTreeContentProvider;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;

public class Variables
extends AbstractEditorPage {
    public static final String VARIABLES_EDITOR_ID = "org.eclipse.ease.editor.variables";
    private static final String DEFAULT_VARIABLE_CONTENT = "\"my content\"";
    private static final String NAME_NEW_VARIABLE_GROUP = "myGroup";
    public static final String EMPTY_STRING = "";
    private static final Pattern VARIABLE_NAME_PATTERN = Pattern.compile("([a-zA-Z_$][0-9a-zA-Z_$]*)");
    private Tree fTree;
    private TreeViewer fTreeViewer;

    public Variables(String id, String title) {
        super(id, title);
    }

    public Variables(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        managedForm.getForm().getBody().setLayout((Layout)new GridLayout(2, false));
        Label lblDefineVariablesThat = new Label(managedForm.getForm().getBody(), 0);
        lblDefineVariablesThat.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        managedForm.getToolkit().adapt((Control)lblDefineVariablesThat, true, true);
        lblDefineVariablesThat.setText("Define variables that will be visible in your scripts. Ordering is important if variables depend on each other.");
        Composite composite = new Composite(managedForm.getForm().getBody(), 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 4));
        managedForm.getToolkit().adapt(composite);
        managedForm.getToolkit().paintBordersFor(composite);
        TreeColumnLayout tcl_composite = new TreeColumnLayout();
        composite.setLayout((Layout)tcl_composite);
        Tree tree = new Tree(composite, 67586);
        this.fTreeViewer = new TreeViewer(tree);
        this.fTree = this.fTreeViewer.getTree();
        this.fTree.setHeaderVisible(true);
        this.fTree.setLinesVisible(true);
        managedForm.getToolkit().paintBordersFor((Composite)this.fTree);
        this.fTreeViewer.setContentProvider((IContentProvider)new VariablesTreeContentProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.fTreeViewer);
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.fTreeViewer, 0);
        TreeColumn tblclmnVariable = treeViewerColumn.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnVariable, (ColumnLayoutData)new ColumnWeightData(100, 100, true));
        tblclmnVariable.setText("Variable");
        treeViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TestSuiteModel.Variable) {
                    return ((TestSuiteModel.Variable)element).getName();
                }
                if (element instanceof IPath) {
                    return ((IPath)element).lastSegment();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof TestSuiteModel.Variable) {
                    return DebugUITools.getImage((String)"IMG_VIEW_VARIABLES");
                }
                if (element instanceof IPath) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                return super.getImage(element);
            }
        });
        treeViewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.fTreeViewer){

            protected void setValue(Object element, Object value) {
                if (element instanceof TestSuiteModel.Variable) {
                    String newVariableName;
                    String oldVariableName;
                    if (Variables.this.checkName(value.toString()) && !(oldVariableName = ((TestSuiteModel.Variable)element).getName()).equals(newVariableName = value.toString())) {
                        ((TestSuiteModel.Variable)element).setName(value.toString());
                        Variables.this.fTreeViewer.update(element, null);
                        Variables.this.setDirty();
                    }
                } else if (element instanceof IPath) {
                    VariablesTreeContentProvider treeContentProvider = (VariablesTreeContentProvider)Variables.this.fTreeViewer.getContentProvider();
                    IPath node = (IPath)element;
                    if (!node.lastSegment().equals(value.toString())) {
                        List variables = Variables.this.getModel().getVariables();
                        treeContentProvider.updateVariablesForRenamedNode(variables, node, value.toString());
                        treeContentProvider.exchangePrefixPaths(node, (String)value);
                        Variables.this.setDirty();
                    }
                }
                Variables.this.updateTreeViewerToLevel();
            }

            protected Object getValue(Object element) {
                if (element instanceof TestSuiteModel.Variable) {
                    return ((TestSuiteModel.Variable)element).getName();
                }
                if (element instanceof IPath) {
                    return ((IPath)element).lastSegment();
                }
                return Variables.EMPTY_STRING;
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)Variables.this.fTree);
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        this.fTreeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof TestSuiteModel.Variable && e2 instanceof TestSuiteModel.Variable) {
                    return ((TestSuiteModel.Variable)e1).getName().compareToIgnoreCase(((TestSuiteModel.Variable)e2).getName());
                }
                if (e1 instanceof IPath && e2 instanceof IPath) {
                    return e1.toString().compareTo(e2.toString());
                }
                return super.compare(viewer, e1, e2);
            }

            public int category(Object element) {
                return element instanceof IPath ? 1 : 2;
            }
        });
        TreeViewerColumn treeViewerColumn_1 = new TreeViewerColumn(this.fTreeViewer, 0);
        TreeColumn tblclmnContent = treeViewerColumn_1.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnContent, (ColumnLayoutData)new ColumnWeightData(100, 100, true));
        tblclmnContent.setText("Content");
        treeViewerColumn_1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TestSuiteModel.Variable) {
                    return ((TestSuiteModel.Variable)element).getContent();
                }
                if (element instanceof IPath) {
                    return Variables.EMPTY_STRING;
                }
                return super.getText(element);
            }
        });
        treeViewerColumn_1.setEditingSupport(new EditingSupport((ColumnViewer)this.fTreeViewer){

            protected void setValue(Object element, Object value) {
                String newVariableContent;
                String oldVariableContent;
                if (element instanceof TestSuiteModel.Variable && !(oldVariableContent = ((TestSuiteModel.Variable)element).getContent()).equals(newVariableContent = value.toString())) {
                    ((TestSuiteModel.Variable)element).setContent(newVariableContent);
                    Variables.this.setDirty();
                    Variables.this.fTreeViewer.update(element, null);
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof TestSuiteModel.Variable) {
                    return ((TestSuiteModel.Variable)element).getContent();
                }
                return Variables.EMPTY_STRING;
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)Variables.this.fTree);
            }

            protected boolean canEdit(Object element) {
                return element instanceof TestSuiteModel.Variable;
            }
        });
        TreeViewerColumn treeViewerColumn_3 = new TreeViewerColumn(this.fTreeViewer, 0);
        TreeColumn tblclmnDescription = treeViewerColumn_3.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnDescription, (ColumnLayoutData)new ColumnWeightData(100, 20, true));
        tblclmnDescription.setText("Description");
        treeViewerColumn_3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TestSuiteModel.Variable) {
                    return ((TestSuiteModel.Variable)element).getDescription();
                }
                if (element instanceof IPath) {
                    return Variables.EMPTY_STRING;
                }
                return super.getText(element);
            }
        });
        treeViewerColumn_3.setEditingSupport(new EditingSupport((ColumnViewer)this.fTreeViewer){

            protected void setValue(Object element, Object value) {
                if (element instanceof TestSuiteModel.Variable) {
                    ((TestSuiteModel.Variable)element).setDescription(value.toString());
                    Variables.this.setDirty();
                    Variables.this.fTreeViewer.update(element, null);
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof TestSuiteModel.Variable) {
                    return ((TestSuiteModel.Variable)element).getDescription();
                }
                return Variables.EMPTY_STRING;
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)Variables.this.fTree);
            }

            protected boolean canEdit(Object element) {
                return element instanceof TestSuiteModel.Variable;
            }
        });
        this.initializeDnD();
        this.update();
        MenuManager contextMenu = new MenuManager(EMPTY_STRING, VARIABLES_EDITOR_ID);
        Menu menu = contextMenu.createContextMenu((Control)this.fTreeViewer.getTree());
        contextMenu.setRemoveAllWhenShown(true);
        this.fTreeViewer.getTree().setMenu(menu);
        this.getEditorSite().registerContextMenu(VARIABLES_EDITOR_ID, contextMenu, (ISelectionProvider)this.fTreeViewer, false);
    }

    @Override
    protected String getPageTitle() {
        return "Variables";
    }

    @Override
    protected void update() {
        this.fTreeViewer.setInput((Object)this.getModel().getVariables());
        this.fTreeViewer.refresh();
    }

    private void initializeDnD() {
        Transfer[] transferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.fTreeViewer.addDragSupport(2, transferTypes, (DragSourceListener)new VariablesDragListener(this.fTreeViewer));
        VariablesDropSupport dropSupport = new VariablesDropSupport(this.fTreeViewer, this.getModel());
        this.fTreeViewer.addDropSupport(2, transferTypes, (DropTargetListener)dropSupport);
    }

    private void updateTreeViewerToLevel() {
        Object[] elements = this.fTreeViewer.getExpandedElements();
        this.fTreeViewer.refresh();
        this.fTreeViewer.setExpandedElements(elements);
    }

    private String createVariable() {
        String newName = "myVariable";
        int index = 1;
        while (!this.checkName(newName)) {
            newName = "myVariable_" + Integer.toString(index++);
        }
        return newName;
    }

    private boolean checkName(String newName) {
        if (VARIABLE_NAME_PATTERN.matcher(newName).matches()) {
            for (TestSuiteModel.Variable variable : this.getModel().getVariables()) {
                if (!newName.equals(variable.getName())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String createGroupName(Object[] childrenGroup) {
        String name = NAME_NEW_VARIABLE_GROUP;
        int index = 1;
        while (!Variables.checkNameSubgroup(name, childrenGroup)) {
            name = "myGroup " + Integer.toString(index++);
        }
        return String.valueOf(name) + Path.ROOT.toString();
    }

    public static boolean checkNameSubgroup(String name, Object[] childrenGroup) {
        Object[] objectArray = childrenGroup;
        int n = childrenGroup.length;
        int n2 = 0;
        while (n2 < n) {
            String childName;
            Object child = objectArray[n2];
            if (child instanceof IPath && (childName = ((IPath)child).lastSegment()).equals(name)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void createGroup(IPath parentGroupPath) {
        VariablesTreeContentProvider contentProvider = (VariablesTreeContentProvider)this.fTreeViewer.getContentProvider();
        String name = Variables.createGroupName(contentProvider.getChildren(parentGroupPath));
        IPath newPath = parentGroupPath.append(name);
        contentProvider.addPath(newPath);
        this.updateTreeViewerToLevel();
    }

    private void addVariableToGroup() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        if (selection.size() == 1) {
            Object selectedNode = selection.getFirstElement();
            if (selectedNode instanceof IPath) {
                IPath currentGroup = (IPath)selectedNode;
                this.getModel().addVariable(this.createVariable(), DEFAULT_VARIABLE_CONTENT, null, currentGroup);
            } else if (selectedNode instanceof TestSuiteModel.Variable) {
                TestSuiteModel.Variable currentVariable = (TestSuiteModel.Variable)selectedNode;
                this.getModel().addVariable(this.createVariable(), DEFAULT_VARIABLE_CONTENT, null, currentVariable.getPath());
            }
        } else {
            this.getModel().addVariable(this.createVariable(), DEFAULT_VARIABLE_CONTENT, null, (IPath)Path.ROOT);
        }
    }

    private void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        for (Object node : selection.toList()) {
            if (node instanceof TestSuiteModel.Variable) {
                this.getModel().removeVariable((TestSuiteModel.Variable)node);
                continue;
            }
            if (!(node instanceof IPath)) continue;
            this.removeVariableGroup((IPath)node);
        }
        this.setDirty();
        this.updateTreeViewerToLevel();
    }

    private void removeVariableGroup(IPath node) {
        List variables = this.getModel().getVariables();
        ArrayList<TestSuiteModel.Variable> variablesSelected = new ArrayList<TestSuiteModel.Variable>();
        for (TestSuiteModel.Variable variable : variables) {
            if (!variable.getPath().uptoSegment(node.segmentCount()).equals((Object)node.makeAbsolute())) continue;
            variablesSelected.add(variable);
        }
        for (TestSuiteModel.Variable variableSelected : variablesSelected) {
            this.getModel().removeVariable(variableSelected);
        }
        VariablesTreeContentProvider treeContentProvider = (VariablesTreeContentProvider)this.fTreeViewer.getContentProvider();
        treeContentProvider.removeMatchingPaths(node);
    }

    public TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    public void addGroup(IPath node) {
        this.createGroup(node);
        this.updateTreeViewerToLevel();
    }

    public void addVariable() {
        this.addVariableToGroup();
        this.setDirty();
        this.updateTreeViewerToLevel();
    }

    public void removeSelectedNodes() {
        this.remove();
        this.setDirty();
        this.updateTreeViewerToLevel();
    }
}

