/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest;

import org.eclipse.ease.modules.unittest.components.TestEntity;
import org.eclipse.ease.modules.unittest.components.TestFile;
import org.eclipse.ease.modules.unittest.components.TestSuite;

public class Statistics {
    private int mTestSets = 0;
    private int mTests = 0;
    private int mErrors = 0;
    private int mFailures = 0;
    private int mOverallTestFiles = 0;
    private int mValidCount = 0;

    public void reset() {
        this.mTestSets = 0;
        this.mTests = 0;
        this.mErrors = 0;
        this.mFailures = 0;
        this.mValidCount = 0;
    }

    public void incrementTestSetCount() {
        ++this.mTestSets;
    }

    public void incrementTestCount() {
        ++this.mTests;
    }

    public void incrementErrorCount() {
        ++this.mErrors;
    }

    public void incrementFailureCount() {
        ++this.mFailures;
    }

    public int getTestSetCount() {
        return this.mTestSets;
    }

    public int getOverallTestSetCount() {
        return this.mOverallTestFiles;
    }

    public int getTestCount() {
        return this.mTests;
    }

    public int getErrorCount() {
        return this.mErrors;
    }

    public int getFailureCount() {
        return this.mFailures;
    }

    public void setOverallTestFileCount(int sets) {
        this.mOverallTestFiles = sets;
    }

    public int getPassCount() {
        return this.mValidCount;
    }

    public void load(TestSuite testSuite) {
        this.reset();
        this.mOverallTestFiles += testSuite.getChildren().size();
        for (TestFile testFile : testSuite.getChildren()) {
            for (TestEntity testEntity : testFile.getChildren()) {
                switch (testEntity.getStatus()) {
                    case PASS: {
                        this.incrementValidCount();
                        break;
                    }
                    case ERROR: {
                        this.incrementErrorCount();
                        break;
                    }
                    case FAILURE: {
                        this.incrementFailureCount();
                        break;
                    }
                }
            }
        }
    }

    public void incrementValidCount() {
        ++this.mValidCount;
    }
}

