/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ui.completion.AbstractCompletionProvider;
import org.eclipse.ease.ui.completion.IHelpResolver;
import org.eclipse.ease.ui.completion.provider.JavaMethodCompletionProvider;
import org.eclipse.ease.ui.completion.provider.JavaPackagesCompletionProvider;
import org.eclipse.ease.ui.help.hovers.JavaClassHelpResolver;
import org.eclipse.ease.ui.tools.Timer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class JavaClassCompletionProvider
extends AbstractCompletionProvider {
    private static Map<String, Collection<String>> CLASSES = null;

    @Override
    public boolean isActive(ICompletionContext context) {
        return super.isActive(context) && (context.getType() == ICompletionContext.Type.PACKAGE || context.getType() == ICompletionContext.Type.NONE && context.getFilter().length() >= 3 && Character.isUpperCase(context.getFilter().charAt(0)));
    }

    @Override
    protected void prepareProposals(ICompletionContext context) {
        if (JavaClassCompletionProvider.getClasses().get(context.getPackage()) != null) {
            for (String className : JavaClassCompletionProvider.getClasses().get(context.getPackage())) {
                if (!this.matchesFilter(className)) continue;
                JavaClassHelpResolver helpResolver = new JavaClassHelpResolver(context.getPackage(), className);
                ImageDescriptor descriptor = JavaClassCompletionProvider.getImage(context.getPackage(), className);
                this.addProposal(className, className, descriptor, 80, (IHelpResolver)helpResolver);
            }
        } else {
            String filter = context.getFilter();
            Pattern classPattern = Pattern.compile(String.valueOf(filter) + ".*");
            for (Map.Entry<String, Collection<String>> packageEntry : JavaClassCompletionProvider.getClasses().entrySet()) {
                for (String candidate : packageEntry.getValue()) {
                    if (!classPattern.matcher(candidate).matches()) continue;
                    JavaClassHelpResolver helpResolver = new JavaClassHelpResolver(packageEntry.getKey(), candidate);
                    ImageDescriptor descriptor = JavaClassCompletionProvider.getImage(packageEntry.getKey(), candidate);
                    StyledString styledString = new StyledString(candidate);
                    styledString.append(" - " + packageEntry.getKey(), StyledString.QUALIFIER_STYLER);
                    this.addProposal(styledString, String.valueOf(packageEntry.getKey()) + "." + candidate, descriptor, 80, (IHelpResolver)helpResolver);
                }
            }
        }
    }

    private static ImageDescriptor getImage(String packageName, String className) {
        ImageDescriptor descriptor = null;
        try {
            Class<?> clazz = JavaClassCompletionProvider.class.getClassLoader().loadClass(String.valueOf(packageName) + "." + className.replace('.', '$'));
            if (clazz.isEnum()) {
                descriptor = JavaMethodCompletionProvider.getSharedImage("org.eclipse.jdt.ui.enum_obj.gif");
            } else if (clazz.isInterface()) {
                descriptor = JavaMethodCompletionProvider.getSharedImage("org.eclipse.jdt.ui.int_obj.gif");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (descriptor == null) {
            descriptor = JavaMethodCompletionProvider.getSharedImage("org.eclipse.jdt.ui.class_obj.gif");
        }
        return descriptor;
    }

    private static Map<String, Collection<String>> getClasses() {
        if (CLASSES == null) {
            CLASSES = new HashMap<String, Collection<String>>();
            Timer timer = new Timer();
            try {
                String fullQualifiedName;
                URL url = new URL("platform:/plugin/org.eclipse.ease.ui/resources/java" + System.getProperty("java.runtime.version").charAt(2) + " classes.txt");
                InputStream inputStream = url.openConnection().getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                while ((fullQualifiedName = reader.readLine()) != null) {
                    JavaClassCompletionProvider.addClass(fullQualifiedName);
                }
                reader.close();
            }
            catch (IOException e) {
                Logger.error((String)"org.eclipse.ease.ui", (String)"Cannot read class list for code completion", (Throwable)e);
            }
            Logger.trace((String)"org.eclipse.ease.ui", (boolean)TRACE_CODE_COMPLETION, (String)("Load java classes took: " + timer.getMilliSeconds() + " ms"));
            timer = new Timer();
            BundleContext context = FrameworkUtil.getBundle(JavaClassCompletionProvider.class).getBundleContext();
            Bundle[] bundleArray = context.getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                String packageName;
                String fullQualifiedName;
                Bundle bundle = bundleArray[n2];
                Collection<String> exportedPackages = JavaPackagesCompletionProvider.getExportedPackages(bundle);
                boolean signedContent = false;
                try {
                    String line;
                    URL manifest = bundle.getEntry("/META-INF/MANIFEST.MF");
                    InputStream inputStream = manifest.openConnection().getInputStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                    while ((line = reader.readLine()) != null) {
                        if (!line.startsWith("Name:") || !line.endsWith(".class") || line.contains("$") || line.contains("package-info")) continue;
                        fullQualifiedName = line.substring(5, line.length() - 6).trim().replace('/', '.');
                        String string = packageName = fullQualifiedName.contains(".") ? fullQualifiedName.substring(0, fullQualifiedName.lastIndexOf(46)) : "";
                        if (exportedPackages.contains(packageName)) {
                            JavaClassCompletionProvider.addClass(fullQualifiedName);
                        }
                        signedContent = true;
                    }
                }
                catch (IOException e) {
                    Logger.error((String)"org.eclipse.ease.ui", (String)("Could not parse manifest of bundle \"" + bundle.getBundleId() + "\""), (Throwable)e);
                }
                if (!signedContent) {
                    try {
                        File bundleFile = FileLocator.getBundleFile((Bundle)bundle);
                        if (bundleFile.isDirectory()) {
                            for (String packageName2 : exportedPackages) {
                                String packagePath = String.valueOf(bundleFile.getAbsolutePath()) + File.separatorChar + packageName2.replace('.', File.separatorChar);
                                File packageFile = new File(packagePath);
                                if (!packageFile.isDirectory()) continue;
                                String[] stringArray = packageFile.list();
                                int n3 = stringArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    String candidate = stringArray[n4];
                                    if (candidate.endsWith(".class") && !candidate.contains("$")) {
                                        JavaClassCompletionProvider.addClass(String.valueOf(packageName2) + "." + candidate.substring(0, candidate.length() - 6));
                                    }
                                    ++n4;
                                }
                            }
                        } else if (bundleFile.isFile()) {
                            JarFile jarFile = new JarFile(bundleFile);
                            Enumeration<JarEntry> entries = jarFile.entries();
                            while (entries.hasMoreElements()) {
                                String candidate = entries.nextElement().getName();
                                if (!candidate.endsWith(".class") || candidate.contains("$")) continue;
                                fullQualifiedName = candidate.substring(0, candidate.length() - 6).replace('/', '.');
                                String string = packageName = fullQualifiedName.contains(".") ? fullQualifiedName.substring(0, fullQualifiedName.lastIndexOf(46)) : "";
                                if (!exportedPackages.contains(packageName)) continue;
                                JavaClassCompletionProvider.addClass(fullQualifiedName);
                            }
                            jarFile.close();
                        }
                    }
                    catch (IOException e) {
                        Logger.error((String)"org.eclipse.ease.ui", (String)("Cannot resolve location for bundle \"" + bundle.getBundleId() + "\""), (Throwable)e);
                    }
                }
                ++n2;
            }
            Logger.trace((String)"org.eclipse.ease.ui", (boolean)TRACE_CODE_COMPLETION, (String)("Load eclipse classes took: " + timer.getMilliSeconds() + " ms"));
        }
        return CLASSES;
    }

    private static void addClass(String fullQualifiedName) {
        String packageName = JavaClassCompletionProvider.getPackage(fullQualifiedName);
        if (!CLASSES.containsKey(packageName)) {
            CLASSES.put(packageName, new HashSet());
        }
        CLASSES.get(packageName).add(fullQualifiedName.substring(packageName.length() + 1));
    }

    private static String getPackage(String className) {
        int lastDot = className.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        String candidate = className.substring(0, lastDot);
        if (JavaPackagesCompletionProvider.containsPackage(candidate)) {
            return candidate;
        }
        return JavaClassCompletionProvider.getPackage(candidate);
    }
}

