/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.help.hovers;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.ui.help.hovers.ModuleHelp;
import org.eclipse.swt.widgets.Combo;

public class EditorToolTipGenerator {
    protected static String getSelectedToken(Combo fInputCombo) {
        int caretPosition;
        String input = String.valueOf(fInputCombo.getText()) + ' ';
        int inputLength = input.length();
        int textStartPosition = 0;
        int textEndPosition = inputLength - 1;
        int i = caretPosition = fInputCombo.getCaretPosition();
        while (i >= 0) {
            if (input.charAt(i) == ' ') {
                textStartPosition = i;
                break;
            }
            --i;
        }
        int j = caretPosition;
        while (j < inputLength) {
            if (input.charAt(j) == ' ' || input.charAt(j) == '(') {
                textEndPosition = j;
                break;
            }
            ++j;
        }
        String selectedText = input.substring(textStartPosition, textEndPosition);
        String selectedToken = selectedText.trim();
        return selectedToken;
    }

    protected static String getToolTipText(String text) {
        String toolTipText = "";
        List<ModuleDefinition> fLoadedModules = Collections.emptyList();
        block0: for (ModuleDefinition definition : fLoadedModules) {
            for (Field field : definition.getFields()) {
                if (!field.getName().equals(text)) continue;
                toolTipText = ModuleHelp.getConstantHelpTip(field);
                if (toolTipText != null) break;
                return String.format("Public member of module %s with type %s.", definition.getName(), field.getType().getName());
            }
            for (Method method : definition.getMethods()) {
                if (!method.getName().equals(text)) continue;
                toolTipText = ModuleHelp.getMethodHelpTip(method);
                if (toolTipText != null) continue block0;
                StringBuilder sb = new StringBuilder();
                sb.append(String.format("Public method of module %s.\n", definition.getName()));
                sb.append("Signature and overloads:\n");
                for (Method overload : definition.getMethods()) {
                    if (!overload.getName().equals(method.getName())) continue;
                    sb.append(overload.toGenericString());
                    sb.append("\n");
                }
                return sb.toString();
            }
        }
        if (toolTipText == "") {
            return null;
        }
        return toolTipText;
    }
}

