/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ease.IScriptable;
import org.eclipse.ease.ScriptResult;
import org.eclipse.ease.tools.ResourceTools;

public class Script {
    private final Object fCommand;
    private final ScriptResult fResult;
    private String fCodeBuffer = null;
    private final String fTitle;
    private final boolean fIsShell;

    public Script(String title, Object command, boolean isShell) {
        this.fTitle = title;
        this.fCommand = command;
        this.fResult = new ScriptResult();
        this.fIsShell = isShell;
    }

    public Script(String title, Object command) {
        this(title, command, false);
    }

    public Script(Object command) {
        this(null, command);
    }

    public InputStream getCodeStream() throws Exception {
        return new ByteArrayInputStream(this.getCode().getBytes());
    }

    public String getCode() throws Exception {
        if (this.fCodeBuffer != null) {
            return this.fCodeBuffer;
        }
        if (this.fCommand instanceof String) {
            return (String)this.fCommand;
        }
        if (this.fCommand instanceof StringBuilder) {
            return this.fCommand.toString();
        }
        if (this.fCommand instanceof InputStream) {
            return this.bufferStream((InputStream)this.fCommand);
        }
        if (this.fCommand instanceof Reader) {
            return this.bufferReader((Reader)this.fCommand);
        }
        if (this.fCommand instanceof IScriptable) {
            return this.bufferStream(((IScriptable)this.fCommand).getSourceCode());
        }
        Object scriptable = Platform.getAdapterManager().getAdapter(this.fCommand, IScriptable.class);
        if (scriptable != null) {
            return this.bufferStream(((IScriptable)scriptable).getSourceCode());
        }
        if (this.fCommand != null) {
            this.fCodeBuffer = this.fCommand.toString();
            return this.fCodeBuffer;
        }
        return null;
    }

    private String bufferReader(Reader command) throws IOException {
        this.fCodeBuffer = ResourceTools.toString(command);
        return this.fCodeBuffer;
    }

    private String bufferStream(InputStream command) throws IOException {
        this.fCodeBuffer = ResourceTools.toString(command);
        return this.fCodeBuffer;
    }

    public final Object getCommand() {
        return this.fCommand;
    }

    public final ScriptResult getResult() {
        return this.fResult;
    }

    public final void setResult(Object result) {
        this.fResult.setResult(result);
        this.closeInput();
    }

    public final void setException(Throwable e) {
        this.fResult.setException(e);
        this.closeInput();
    }

    private void closeInput() {
        if (this.fCommand instanceof InputStream) {
            try {
                ((InputStream)this.fCommand).close();
            }
            catch (IOException iOException) {}
        } else if (this.fCommand instanceof Reader) {
            try {
                ((Reader)this.fCommand).close();
            }
            catch (IOException iOException) {}
        }
    }

    public Object getFile() {
        if (this.fCommand instanceof IFile || this.fCommand instanceof File) {
            return this.fCommand;
        }
        return null;
    }

    public boolean isDynamic() {
        return !(this.fCommand instanceof URL) && this.getFile() == null;
    }

    public String toString() {
        return this.getTitle() != null ? this.getTitle() : "(unknown script source)";
    }

    public String getTitle() {
        if (this.fTitle != null) {
            return this.fTitle;
        }
        if (this.fCommand instanceof IFile) {
            return ((IFile)this.fCommand).getName();
        }
        if (this.fCommand instanceof File) {
            return ((File)this.fCommand).getName();
        }
        if (this.fCommand instanceof URI) {
            return this.fCommand.toString();
        }
        if (this.fCommand instanceof URL) {
            return this.fCommand.toString();
        }
        return null;
    }

    public boolean isShellMode() {
        return this.fIsShell;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fCommand == null ? 0 : this.fCommand.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Script other = (Script)obj;
        return !(this.fCommand == null ? other.fCommand != null : !this.fCommand.equals(other.fCommand));
    }
}

