/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.runtime;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TestStatus implements Enumerator
{
    NOT_RUN(0, "NOT_RUN", "NOT_RUN"),
    FINISHED(1, "FINISHED", "FINISHED"),
    DISABLED(2, "DISABLED", "DISABLED"),
    PASS(3, "PASS", "PASS"),
    FAILURE(4, "FAILURE", "FAILURE"),
    ERROR(5, "ERROR", "ERROR"),
    RUNNING(6, "RUNNING", "RUNNING");

    public static final int NOT_RUN_VALUE = 0;
    public static final int FINISHED_VALUE = 1;
    public static final int DISABLED_VALUE = 2;
    public static final int PASS_VALUE = 3;
    public static final int FAILURE_VALUE = 4;
    public static final int ERROR_VALUE = 5;
    public static final int RUNNING_VALUE = 6;
    private static final TestStatus[] VALUES_ARRAY;
    public static final List<TestStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TestStatus[]{NOT_RUN, FINISHED, DISABLED, PASS, FAILURE, ERROR, RUNNING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TestStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TestStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TestStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TestStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TestStatus get(int value) {
        switch (value) {
            case 0: {
                return NOT_RUN;
            }
            case 1: {
                return FINISHED;
            }
            case 2: {
                return DISABLED;
            }
            case 3: {
                return PASS;
            }
            case 4: {
                return FAILURE;
            }
            case 5: {
                return ERROR;
            }
            case 6: {
                return RUNNING;
            }
        }
        return null;
    }

    private TestStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

