/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ease.ExitException;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.Script;
import org.eclipse.ease.modules.AbstractEnvironment;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class EnvironmentModule
extends AbstractEnvironment {
    public static final String MODULE_NAME = "/System/Environment";
    public static final String MODULE_PREFIX = "__MOD_";
    private static final Pattern VALID_TOPICS_PATTERN = Pattern.compile("[\\w ]+(?:\\(\\))?");

    @Override
    @WrapToScript
    public Object wrap(Object toBeWrapped, @ScriptParameter(defaultValue="false") boolean useCustomNamespace) {
        String identifier = this.getScriptEngine().getSaveVariableName(EnvironmentModule.getWrappedVariableName(toBeWrapped));
        boolean reloaded = this.getScriptEngine().hasVariable(identifier);
        this.getScriptEngine().setVariable(identifier, toBeWrapped);
        Logger.trace("org.eclipse.ease", ICodeFactory.TRACE_MODULE_WRAPPER, "wrapping object: " + toBeWrapped.toString());
        Object result = this.createWrappers(toBeWrapped, identifier, reloaded, useCustomNamespace);
        this.fireModuleEvent(toBeWrapped, reloaded ? 2 : 1);
        return result;
    }

    public static final String getWrappedVariableName(Object toBeWrapped) {
        return (MODULE_PREFIX + toBeWrapped.getClass().getName()).replace('.', '_');
    }

    private Object createWrappers(Object instance, String identifier, boolean reload, boolean useCustomNamespace) {
        ICodeFactory codeFactory = this.getCodeFactory();
        if (codeFactory == null) {
            return null;
        }
        String wrapperCode = codeFactory.createWrapper(this, instance, identifier, useCustomNamespace, this.getScriptEngine());
        if (useCustomNamespace) {
            return this.getScriptEngine().inject(new Script("Wrapper(" + instance.getClass().getSimpleName() + ")", wrapperCode));
        }
        this.getScriptEngine().inject(new Script("Wrapper(" + instance.getClass().getSimpleName() + ")", wrapperCode));
        return instance;
    }

    @WrapToScript
    public final Object execute(Object data) {
        return this.getScriptEngine().inject(data);
    }

    @WrapToScript
    public final void exit(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object value) {
        throw new ExitException(value);
    }

    @WrapToScript
    public final Object include(String filename) {
        Object file = ResourceTools.resolve(filename, this.getScriptEngine().getExecutedFile());
        if (file != null) {
            return this.getScriptEngine().inject(file);
        }
        throw new RuntimeException("Cannot locate '" + filename + "'");
    }

    @Override
    @WrapToScript
    public IScriptEngine getScriptEngine() {
        Job currentJob;
        IScriptEngine engine = super.getScriptEngine();
        if (engine == null && (currentJob = Job.getJobManager().currentJob()) instanceof IScriptEngine) {
            return (IScriptEngine)currentJob;
        }
        return engine;
    }

    private ICodeFactory getCodeFactory() {
        return ScriptService.getCodeFactory(this.getScriptEngine());
    }

    @WrapToScript
    public boolean loadJar(Object location) throws MalformedURLException {
        if (!(location instanceof URL)) {
            Object file = ResourceTools.resolve(location, this.getScriptEngine().getExecutedFile());
            if (file instanceof IFile) {
                file = ((IFile)file).getLocation().toFile();
            }
            location = file instanceof File ? ((File)file).toURI().toURL() : new URL(location.toString());
        }
        if (location instanceof URL) {
            this.getScriptEngine().registerJar((URL)location);
            return true;
        }
        return false;
    }

    @WrapToScript
    public void help(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String topic) {
        if (!VALID_TOPICS_PATTERN.matcher(topic).matches()) {
            this.printError("Invalid help topic to look for: \"" + topic + "\"");
            return;
        }
        if (PlatformUI.isWorkbenchRunning()) {
            if (topic != null) {
                for (Object module : this.getModules()) {
                    ModuleDefinition definition = ModuleDefinition.getDefinition(module);
                    if (definition == null) continue;
                    for (Method method : definition.getMethods()) {
                        if (!this.matchesMethod(method, topic)) continue;
                        String link = definition.getHelpLocation(method.getName());
                        Display.getDefault().asyncExec(() -> PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(link));
                        return;
                    }
                    for (Field field : definition.getFields()) {
                        if (!this.matchesField(field, topic)) continue;
                        String link = definition.getHelpLocation(field.getName());
                        Display.getDefault().asyncExec(() -> PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(link));
                        return;
                    }
                }
                Display.getDefault().asyncExec(() -> PlatformUI.getWorkbench().getHelpSystem().search(topic));
            } else {
                Display.getDefault().asyncExec(() -> PlatformUI.getWorkbench().getHelpSystem().displayHelp());
            }
        }
    }

    private boolean matchesField(Field field, String name) {
        if (name.equalsIgnoreCase(field.getName())) {
            return true;
        }
        WrapToScript wrapAnnotation = field.getAnnotation(WrapToScript.class);
        if (wrapAnnotation != null) {
            String[] stringArray = wrapAnnotation.alias().split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String alias = stringArray[n2];
                if (name.equalsIgnoreCase(alias.trim())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean matchesMethod(Method method, String name) {
        if (name.equalsIgnoreCase(method.getName())) {
            return true;
        }
        WrapToScript wrapAnnotation = method.getAnnotation(WrapToScript.class);
        if (wrapAnnotation != null) {
            String[] stringArray = wrapAnnotation.alias().split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String alias = stringArray[n2];
                if (name.equalsIgnoreCase(alias.trim())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

