/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.keywordhandler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ui.scripts.Activator;
import org.eclipse.ease.ui.scripts.keywordhandler.ScriptContributionFactory;
import org.eclipse.ease.ui.scripts.keywordhandler.ScriptContributionItem;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ToolbarHandler
implements EventHandler {
    public static final boolean TRACE_UI_INTEGRATION = Activator.getDefault().isDebugging() && "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.ease.ui.scripts/debug/UIIntegration"));
    private static final String VIEW_ATTRIBUTE_NAME = "name";
    private final Job fUpdateUIJob = new UIIntegrationJob();
    private List<Event> fKeywordEvents = new ArrayList<Event>();
    private List<Event> fRefreshEvents = new ArrayList<Event>();
    private final Map<String, ScriptContributionFactory> fContributionFactories = new HashMap<String, ScriptContributionFactory>();

    public Collection<Location> toLocations(String value) {
        HashSet<Location> locations = new HashSet<Location>();
        String[] stringArray = value.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            locations.add(new Location(this.getHandlerType(), part));
            ++n2;
        }
        return locations;
    }

    public ToolbarHandler() {
        IEventBroker eventBroker = (IEventBroker)PlatformUI.getWorkbench().getService(IEventBroker.class);
        eventBroker.subscribe("org/eclipse/ease/scripts/keyword/name", (EventHandler)this);
        eventBroker.subscribe("org/eclipse/ease/scripts/keyword/image", (EventHandler)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        IScript script = (IScript)event.getProperty("script");
        String keyword = (String)event.getProperty("keyword");
        ToolbarHandler toolbarHandler = this;
        synchronized (toolbarHandler) {
            if ("image".equals(keyword) || VIEW_ATTRIBUTE_NAME.equals(keyword)) {
                if (script.getKeywords().get(this.getHandlerType()) != null) {
                    this.fRefreshEvents.add(event);
                    this.fUpdateUIJob.schedule(300L);
                }
            } else {
                this.fKeywordEvents.add(event);
                this.fUpdateUIJob.schedule(300L);
            }
        }
    }

    protected void addContribution(IScript script, String value) {
        for (Location location : this.toLocations(value)) {
            Logger.trace((String)"org.eclipse.ease.ui.scripts", (boolean)TRACE_UI_INTEGRATION, (String)"org.eclipse.ease.ui.scripts", (String)("Adding script \"" + script.getName() + "\" to " + location.fScheme + ":" + location.fViewID));
            if (location.fViewID == null) continue;
            IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(location.fViewID);
            this.getContributionFactory(location.getID()).addScript(script);
            if (!(view instanceof ViewPart) || view.getViewSite() == null) continue;
            this.getContributionFactory(location.getID()).setAffectedContribution((IContributionManager)view.getViewSite().getActionBars().getToolBarManager());
            view.getViewSite().getActionBars().getToolBarManager().add((IContributionItem)new ScriptContributionItem(script));
            view.getViewSite().getActionBars().updateActionBars();
        }
    }

    protected void removeContribution(IScript script, String value) {
        for (Location location : this.toLocations(value)) {
            IViewPart view;
            Logger.trace((String)"org.eclipse.ease.ui.scripts", (boolean)TRACE_UI_INTEGRATION, (String)"org.eclipse.ease.ui.scripts", (String)("Removing script \"" + script.getName() + "\" from " + location.fScheme + ":" + location.fViewID));
            this.getContributionFactory(location.getID()).removeScript(script);
            if (location.fViewID == null || !((view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(location.fViewID)) instanceof ViewPart) || view.getViewSite() == null) continue;
            view.getViewSite().getActionBars().getToolBarManager().remove(script.getLocation());
            view.getViewSite().getActionBars().updateActionBars();
        }
    }

    protected ScriptContributionFactory getContributionFactory(String location) {
        if (!this.fContributionFactories.containsKey(location)) {
            this.fContributionFactories.put(location, new ScriptContributionFactory(location));
        }
        return this.fContributionFactories.get(location);
    }

    protected String getHandlerType() {
        return "toolbar";
    }

    public static class Location {
        public String fScheme;
        public String fViewID;
        public String fName = null;

        public Location(String scheme, String location) {
            IConfigurationElement[] config;
            this.fScheme = scheme;
            String[] tokens = location.split("\\|");
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.views");
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                if ("view".equals(e.getName())) {
                    String id = e.getAttribute("id");
                    if (id.equals(tokens[0])) {
                        this.fViewID = id;
                        break;
                    }
                    String name = e.getAttribute(ToolbarHandler.VIEW_ATTRIBUTE_NAME);
                    if (name.equals(tokens[0])) {
                        this.fViewID = id;
                        break;
                    }
                }
                ++n2;
            }
            if (this.fViewID != null && tokens.length >= 2 && !tokens[1].isEmpty()) {
                this.fName = tokens[1];
            }
        }

        public String getID() {
            return String.valueOf(this.fScheme) + ":" + this.fViewID;
        }
    }

    private class UIIntegrationJob
    extends UIJob {
        private UIIntegrationJob() {
            super("Update toolbar scripts");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            IScript script;
            List refreshEvents;
            List keywordEvents;
            if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null) {
                PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){

                    public void windowOpened(IWorkbenchWindow window) {
                    }

                    public void windowDeactivated(IWorkbenchWindow window) {
                    }

                    public void windowClosed(IWorkbenchWindow window) {
                    }

                    public void windowActivated(IWorkbenchWindow window) {
                        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
                        UIIntegrationJob.this.schedule(300L);
                    }
                });
                return Status.CANCEL_STATUS;
            }
            ToolbarHandler toolbarHandler = ToolbarHandler.this;
            synchronized (toolbarHandler) {
                keywordEvents = ToolbarHandler.this.fKeywordEvents;
                ToolbarHandler.this.fKeywordEvents = new ArrayList();
                refreshEvents = ToolbarHandler.this.fRefreshEvents;
                ToolbarHandler.this.fRefreshEvents = new ArrayList();
            }
            HashSet<IScript> processedScripts = new HashSet<IScript>();
            for (Event event : keywordEvents) {
                script = (IScript)event.getProperty("script");
                processedScripts.add(script);
                String value = (String)event.getProperty("value");
                String oldValue = (String)event.getProperty("oldValue");
                if (oldValue != null && !oldValue.isEmpty()) {
                    ToolbarHandler.this.removeContribution(script, oldValue);
                }
                if (value == null || value.isEmpty()) continue;
                ToolbarHandler.this.addContribution(script, value);
            }
            for (Event event : refreshEvents) {
                script = (IScript)event.getProperty("script");
                if (processedScripts.contains(script)) continue;
                ToolbarHandler.this.removeContribution(script, script.getKeywords().get(ToolbarHandler.this.getHandlerType()));
                ToolbarHandler.this.addContribution(script, script.getKeywords().get(ToolbarHandler.this.getHandlerType()));
            }
            return Status.OK_STATUS;
        }
    }
}

