/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python.jython.debugger;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptEngineException;
import org.eclipse.ease.ScriptObjectType;
import org.eclipse.ease.debugging.EaseDebugFrame;
import org.eclipse.ease.debugging.ScriptStackTrace;
import org.eclipse.ease.debugging.dispatcher.IEventProcessor;
import org.eclipse.ease.debugging.model.EaseDebugVariable;
import org.eclipse.ease.lang.python.debugger.IPythonDebugEngine;
import org.eclipse.ease.lang.python.debugger.PythonDebugger;
import org.eclipse.ease.lang.python.debugger.PythonEventDispatchJob;
import org.eclipse.ease.lang.python.debugger.ResourceHelper;
import org.eclipse.ease.lang.python.debugger.model.PythonDebugTarget;
import org.eclipse.ease.lang.python.jython.JythonScriptEngine;
import org.eclipse.ease.lang.python.jython.debugger.JythonDebugger;
import org.python.core.Py;
import org.python.core.PyBoolean;
import org.python.core.PyDictionary;
import org.python.core.PyFloat;
import org.python.core.PyInstance;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;

public class JythonDebuggerEngine
extends JythonScriptEngine
implements IPythonDebugEngine {
    public static final String ENGINE_ID = "org.eclipse.ease.python.jythonDebugger";
    private PythonDebugger fDebugger = null;

    public JythonDebuggerEngine() {
        super("Jython Debugger");
        this.setDebugger(new JythonDebugger((IDebugEngine)this, false));
    }

    public void setDebugger(PythonDebugger debugger) {
        this.fDebugger = debugger;
    }

    protected void setupEngine() throws ScriptEngineException {
        super.setupEngine();
        if (this.fDebugger != null) {
            try {
                InputStream stream = ResourceHelper.getResourceStream((String)"org.eclipse.ease.lang.python", (String)"pysrc/edb.py");
                this.internalSetVariable("_pyease_debugger", Py.java2py((Object)this.fDebugger));
                super.internalExecute(new Script("Load Python debugger", (Object)stream), (Object)"edb.py", "Load Python Debugger");
            }
            catch (Throwable e) {
                throw new ScriptEngineException("Failed to load Python Debugger", e);
            }
        }
    }

    protected Object internalExecute(Script script, Object reference, String fileName) throws Exception {
        if (this.fDebugger != null) {
            return this.fDebugger.execute(script);
        }
        return super.internalExecute(script, reference, fileName);
    }

    public void setupDebugger(ILaunch launch, boolean suspendOnStartup, boolean suspendOnScriptLoad, boolean showDynamicCode) {
        PythonDebugTarget target = new PythonDebugTarget(launch, suspendOnStartup, suspendOnScriptLoad, showDynamicCode);
        launch.addDebugTarget((IDebugTarget)target);
        JythonDebugger debugger = new JythonDebugger((IDebugEngine)this, showDynamicCode);
        this.setDebugger(debugger);
        new PythonEventDispatchJob((IEventProcessor)target, (IEventProcessor)debugger);
    }

    public ScriptStackTrace getExceptionStackTrace() {
        return null;
    }

    public ScriptStackTrace getExceptionStackTrace(Object thread) {
        return null;
    }

    public Object removeVariable(String name) {
        throw new UnsupportedOperationException();
    }

    public Collection<EaseDebugVariable> getVariables(Object scope) {
        ArrayList<EaseDebugVariable> variables = new ArrayList<EaseDebugVariable>();
        if (scope instanceof EaseDebugFrame) {
            for (Map.Entry entry : ((EaseDebugFrame)scope).getVariables().entrySet()) {
                variables.add(this.createVariable((String)entry.getKey(), entry.getValue()));
            }
        } else {
            for (Map.Entry entry : this.getVariables().entrySet()) {
                variables.add(this.createVariable((String)entry.getKey(), entry.getValue()));
            }
        }
        return variables;
    }

    public ScriptObjectType getType(Object object) {
        if (object instanceof PyDictionary) {
            return ScriptObjectType.NATIVE_OBJECT;
        }
        if (object instanceof PyInstance) {
            return ScriptObjectType.NATIVE_OBJECT;
        }
        if (object != null && object.getClass().isArray()) {
            return ScriptObjectType.NATIVE_ARRAY;
        }
        return super.getType(object);
    }

    protected EaseDebugVariable createVariable(String name, Object value) {
        if (value instanceof PyNone) {
            return super.createVariable(name, null);
        }
        if (value instanceof PyString) {
            return super.createVariable(name, Py.tojava((PyObject)((PyObject)value), String.class));
        }
        if (value instanceof PyInteger) {
            return super.createVariable(name, Py.tojava((PyObject)((PyObject)value), Integer.class));
        }
        if (value instanceof PyLong) {
            return super.createVariable(name, Py.tojava((PyObject)((PyObject)value), Long.class));
        }
        if (value instanceof PyFloat) {
            return super.createVariable(name, Py.tojava((PyObject)((PyObject)value), Float.class));
        }
        if (value instanceof PyBoolean) {
            return super.createVariable(name, Py.tojava((PyObject)((PyObject)value), Boolean.class));
        }
        EaseDebugVariable variable = super.createVariable(name, value);
        if (value instanceof PyDictionary) {
            variable.getValue().setValueString("object{" + this.getDefinedVariables(value).size() + "}");
            variable.setType(EaseDebugVariable.Type.NATIVE_OBJECT);
        }
        if (value instanceof PyInstance) {
            variable.getValue().setValueString("object{" + this.getDefinedVariables(value).size() + "}");
            variable.setType(EaseDebugVariable.Type.NATIVE_OBJECT);
        }
        if (value != null && value.getClass().isArray()) {
            variable.getValue().setValueString("array[" + this.getDefinedVariables(value).size() + "]");
            variable.setType(EaseDebugVariable.Type.NATIVE_ARRAY);
        }
        return variable;
    }

    protected Collection<EaseDebugVariable> getDefinedVariables(Object scope) {
        if (scope instanceof PyDictionary) {
            ArrayList<EaseDebugVariable> childObjects = new ArrayList<EaseDebugVariable>();
            for (Object id : ((PyDictionary)scope).keySet()) {
                Object object = ((PyDictionary)scope).get(id);
                if (!this.acceptVariable(object)) continue;
                childObjects.add(this.createVariable(id.toString(), object));
            }
            return childObjects;
        }
        if (scope instanceof PyInstance) {
            ArrayList<EaseDebugVariable> childObjects = new ArrayList<EaseDebugVariable>();
            PyObject fields = ((PyInstance)scope).__dict__;
            if (fields instanceof PyStringMap) {
                Object[] objectArray = ((PyStringMap)fields).keys().toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object id = objectArray[n2];
                    PyObject value = fields.__finditem__(id.toString());
                    if (this.acceptVariable(value)) {
                        childObjects.add(this.createVariable(id.toString(), value));
                    }
                    ++n2;
                }
            }
            return childObjects;
        }
        if (scope != null && scope.getClass().isArray()) {
            ArrayList<EaseDebugVariable> childObjects = new ArrayList<EaseDebugVariable>();
            Object[] array = (Object[])scope;
            int index = 0;
            while (index < array.length) {
                childObjects.add(this.createVariable("[" + Integer.toString(index) + "]", array[index]));
                ++index;
            }
            return childObjects;
        }
        return super.getDefinedVariables(scope);
    }

    protected boolean acceptVariable(Object value) {
        return true;
    }
}

