/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.spi.common.ui.composites;

import org.eclipse.emf.ecp.internal.common.ui.Messages;
import org.eclipse.emf.ecp.spi.common.ui.CompositeProvider;
import org.eclipse.emf.ecp.spi.common.ui.ECPViewerFilter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractFilteredSelectionComposite<T extends StructuredViewer>
implements CompositeProvider {
    private T viewer;
    private Object[] selection;

    @Override
    public Composite createUI(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(composite);
        Label filterLabel = new Label(composite, 16384);
        filterLabel.setText(Messages.AbstractModelElementHelper_FilterLabel);
        final Text filterInput = new Text(composite, 128);
        filterInput.setMessage(Messages.AbstractModelElementHelper_FilterText);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)filterInput);
        this.viewer = this.createViewer(composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).minSize(0, 150).span(2, 1).applyTo(this.viewer.getControl());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractFilteredSelectionComposite.this.selection = ((IStructuredSelection)AbstractFilteredSelectionComposite.this.viewer.getSelection()).toArray();
            }
        });
        this.viewer.addFilter((ViewerFilter)this.getFilter());
        filterInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = filterInput.getText();
                AbstractFilteredSelectionComposite.this.getFilter().setSearchTerm(text);
                AbstractFilteredSelectionComposite.this.expandViewer();
                if (text != null && text.length() == 0) {
                    AbstractFilteredSelectionComposite.this.collapsViewer();
                }
                AbstractFilteredSelectionComposite.this.viewer.refresh();
            }
        });
        return composite;
    }

    protected void expandViewer() {
    }

    protected void collapsViewer() {
    }

    public T getViewer() {
        return this.viewer;
    }

    public Object[] getSelection() {
        return this.selection;
    }

    protected abstract T createViewer(Composite var1);

    protected abstract ECPViewerFilter getFilter();
}

