/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.Spliterator;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Comparables;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.VisibleForTesting;

public class Spliterators {
    private static final String SPLITERATOR_DISTINCT = "DISTINCT";
    private static final String SPLITERATOR_SORTED = "SORTED";
    private static final String SPLITERATOR_ORDERED = "ORDERED";
    private static final String SPLITERATOR_SIZED = "SIZED";
    private static final String SPLITERATOR_NONNULL = "NONNULL";
    private static final String SPLITERATOR_IMMUTABLE = "IMMUTABLE";
    private static final String SPLITERATOR_CONCURRENT = "CONCURRENT";
    private static final String SPLITERATOR_SUBSIZED = "SUBSIZED";
    private static final Spliterators INSTANCE = new Spliterators();
    private final Iterables iterables = Iterables.instance();

    public static Spliterators instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    void setFailures(Failures failures) {
        this.iterables.failures = failures;
    }

    public void assertHasCharacteristics(AssertionInfo info, Spliterator<?> actual, int ... characteristics) {
        Comparables.assertNotNull(info, actual);
        Set<String> actualCharacteristicNames = Spliterators.characteristicNames(actual.characteristics());
        Set<String> expectedCharacteristicNames = Spliterators.characteristicNames(characteristics);
        this.iterables.assertContains(info, actualCharacteristicNames, expectedCharacteristicNames.toArray(new String[0]));
    }

    public void assertHasOnlyCharacteristics(AssertionInfo info, Spliterator<?> actual, int ... characteristics) {
        Comparables.assertNotNull(info, actual);
        Set<String> actualCharacteristicNames = Spliterators.characteristicNames(actual.characteristics());
        Set<String> expectedCharacteristicNames = Spliterators.characteristicNames(characteristics);
        this.iterables.assertContainsOnly(info, actualCharacteristicNames, expectedCharacteristicNames.toArray(new String[0]));
    }

    private static Set<String> characteristicNames(int[] characteristics) {
        HashSet<String> names = new HashSet<String>();
        for (int characteristic : characteristics) {
            names.addAll(Spliterators.characteristicNames(characteristic));
        }
        return names;
    }

    private static Set<String> characteristicNames(int characteristics) {
        HashSet<String> names = new HashSet<String>();
        if (Spliterators.hasCharacteristic(characteristics, 1)) {
            names.add(SPLITERATOR_DISTINCT);
        }
        if (Spliterators.hasCharacteristic(characteristics, 4)) {
            names.add(SPLITERATOR_SORTED);
        }
        if (Spliterators.hasCharacteristic(characteristics, 16)) {
            names.add(SPLITERATOR_ORDERED);
        }
        if (Spliterators.hasCharacteristic(characteristics, 64)) {
            names.add(SPLITERATOR_SIZED);
        }
        if (Spliterators.hasCharacteristic(characteristics, 256)) {
            names.add(SPLITERATOR_NONNULL);
        }
        if (Spliterators.hasCharacteristic(characteristics, 1024)) {
            names.add(SPLITERATOR_IMMUTABLE);
        }
        if (Spliterators.hasCharacteristic(characteristics, 4096)) {
            names.add(SPLITERATOR_CONCURRENT);
        }
        if (Spliterators.hasCharacteristic(characteristics, 16384)) {
            names.add(SPLITERATOR_SUBSIZED);
        }
        return names;
    }

    private static boolean hasCharacteristic(int characteristics, int expectedCharacteristic) {
        return (characteristics & expectedCharacteristic) == expectedCharacteristic;
    }
}

