/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia.permissions;

import jakarta.security.jacc.EJBRoleRefPermission;
import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.WebRoleRefPermission;
import java.security.Permission;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.exousia.constraints.transformer.ConstraintsToPermissionsTransformer;
import org.glassfish.exousia.mapping.SecurityRoleRef;
import org.glassfish.exousia.permissions.JakartaPermissions;

public class RolesToPermissionsTransformer {
    static final Logger logger = Logger.getLogger(ConstraintsToPermissionsTransformer.class.getName());
    public static final String ANY_AUTHENTICATED_CALLER_ROLE = "**";
    private static final String CLASS_NAME = ConstraintsToPermissionsTransformer.class.getSimpleName();
    private static final BiFunction<String, String, Permission> CREATE_BEAN_REF = EJBRoleRefPermission::new;
    private static final BiFunction<String, String, Permission> CREATE_WEB_REF = WebRoleRefPermission::new;

    public static JakartaPermissions createWebRoleRefPermission(Set<String> declaredRoles, Map<String, List<SecurityRoleRef>> servletRoleMappings) throws PolicyContextException {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "createWebRoleRefPermission");
            logger.log(Level.FINE, "Jakarta Authorization: role-reference translation: Processing WebRoleRefPermission");
        }
        JakartaPermissions jakartaPermissions = new JakartaPermissions();
        ArrayList<String> servletScopedRoleNames = new ArrayList<String>();
        boolean rolesetContainsAnyAuthUserRole = declaredRoles.contains(ANY_AUTHENTICATED_CALLER_ROLE);
        for (Map.Entry<String, List<SecurityRoleRef>> servletEntry : servletRoleMappings.entrySet()) {
            RolesToPermissionsTransformer.addPermissionsForRoleRefRoles(CREATE_WEB_REF, servletEntry, servletScopedRoleNames, jakartaPermissions.getPerRole());
            logger.fine("Jakarta Authorization: role-reference translation: Going through the list of roles not present in RoleRef elements and creating WebRoleRefPermissions ");
            RolesToPermissionsTransformer.addPermissionsForNonRoleRefRoles(CREATE_WEB_REF, declaredRoles, servletScopedRoleNames, servletEntry.getKey(), jakartaPermissions.getPerRole());
            if (servletScopedRoleNames.contains(ANY_AUTHENTICATED_CALLER_ROLE) || rolesetContainsAnyAuthUserRole) continue;
            RolesToPermissionsTransformer.addAnyAuthenticatedUserRoleRef(CREATE_WEB_REF, jakartaPermissions.getPerRole(), servletEntry.getKey());
        }
        RolesToPermissionsTransformer.addGlobalPermissionsForAllRoles(declaredRoles, jakartaPermissions.getPerRole());
        if (!rolesetContainsAnyAuthUserRole) {
            RolesToPermissionsTransformer.addAnyAuthenticatedUserRoleRef(CREATE_WEB_REF, jakartaPermissions.getPerRole(), "");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "createWebRoleRefPermission");
        }
        return jakartaPermissions;
    }

    public static JakartaPermissions createEnterpriseBeansRoleRefPermission(Set<String> declaredRoles, Map<String, List<SecurityRoleRef>> beanRoleMappings) throws PolicyContextException {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "createWebRoleRefPermission");
            logger.log(Level.FINE, "Jakarta Authorization: role-reference translation: Processing WebRoleRefPermission");
        }
        JakartaPermissions jakartaPermissions = new JakartaPermissions();
        ArrayList<String> beanScopedRoleNames = new ArrayList<String>();
        boolean rolesetContainsAnyAuthUserRole = declaredRoles.contains(ANY_AUTHENTICATED_CALLER_ROLE);
        for (Map.Entry<String, List<SecurityRoleRef>> beanEntry : beanRoleMappings.entrySet()) {
            RolesToPermissionsTransformer.addPermissionsForRoleRefRoles(CREATE_BEAN_REF, beanEntry, beanScopedRoleNames, jakartaPermissions.getPerRole());
            logger.fine("Jakarta Authorization: role-reference translation: Going through the list of roles not present in RoleRef elements and creating WebRoleRefPermissions ");
            RolesToPermissionsTransformer.addPermissionsForNonRoleRefRoles(CREATE_BEAN_REF, declaredRoles, beanScopedRoleNames, beanEntry.getKey(), jakartaPermissions.getPerRole());
            if (beanScopedRoleNames.contains(ANY_AUTHENTICATED_CALLER_ROLE) || rolesetContainsAnyAuthUserRole) continue;
            RolesToPermissionsTransformer.addAnyAuthenticatedUserRoleRef(CREATE_BEAN_REF, jakartaPermissions.getPerRole(), beanEntry.getKey());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "createEnterpriseBeansRoleRefPermission");
        }
        return jakartaPermissions;
    }

    private static void addGlobalPermissionsForAllRoles(Collection<String> declaredRoles, Map<String, Permissions> roleMap) {
        for (String role : declaredRoles) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Jakarta Authorization: role-reference translation: Looking at Role =  " + role);
            }
            RolesToPermissionsTransformer.addToRoleMap(roleMap, role, (Permission)new WebRoleRefPermission("", role));
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("Jakarta Authorization: role-reference translation: RoleRef  = " + role + " is added for jsp's that can't be mapped to servlets");
            logger.fine("Jakarta Authorization: role-reference translation: Permission added for above role-ref =" + role + " ");
        }
    }

    private static void addPermissionsForRoleRefRoles(BiFunction<String, String, Permission> createComponent, Map.Entry<String, List<SecurityRoleRef>> roleEntry, Collection<String> componentScopedRoleNames, Map<String, Permissions> roleMap) {
        for (SecurityRoleRef securityRoleRef : roleEntry.getValue()) {
            componentScopedRoleNames.add(securityRoleRef.getRoleName());
            String globalRole = securityRoleRef.getRoleLink();
            RolesToPermissionsTransformer.addToRoleMap(roleMap, globalRole, createComponent.apply(roleEntry.getKey(), securityRoleRef.getRoleName()));
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("Jakarta Authorization: role-reference translation: RoleRefPermission created with name = " + roleEntry.getKey() + " and action = " + securityRoleRef.getRoleName() + " added to role  = " + globalRole);
        }
    }

    private static void addPermissionsForNonRoleRefRoles(BiFunction<String, String, Permission> createComponent, Collection<String> declaredRoles, Collection<String> roleRefRoles, String componentName, Map<String, Permissions> roleMap) {
        for (String role : declaredRoles) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Jakarta Authorization: role-reference translation: Looking at Role =  " + role);
            }
            if (roleRefRoles.contains(role)) continue;
            RolesToPermissionsTransformer.addToRoleMap(roleMap, role, createComponent.apply(componentName, role));
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("Jakarta Authorization: role-reference translation: RoleRef  = " + role + " is added for = " + componentName);
            logger.fine("Jakarta Authorization: role-reference translation: Permission added for above role-ref =" + componentName + " " + role);
        }
    }

    private static void addAnyAuthenticatedUserRoleRef(BiFunction<String, String, Permission> createComponent, Map<String, Permissions> roleMap, String name) throws PolicyContextException {
        RolesToPermissionsTransformer.addToRoleMap(roleMap, ANY_AUTHENTICATED_CALLER_ROLE, createComponent.apply(name, ANY_AUTHENTICATED_CALLER_ROLE));
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Jakarta Authorization: any authenticated user role-reference translation: Permission added for role-ref =" + name + " **");
        }
    }

    private static void addToRoleMap(Map<String, Permissions> roleMap, String role, Permission permission) {
        roleMap.computeIfAbsent(role, e -> new Permissions()).add(permission);
    }
}

