/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.template;

import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.xml.templateinfo.TemplateInfo;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.InputSource;

public class TemplateInfoHolder {
    private static final LocalStringsImpl _strings = new LocalStringsImpl(TemplateInfoHolder.class);
    private static final String TEMPLATE_INFO_SCHEMA_PATH = "xsd/schema/template-info.xsd";
    private TemplateInfo _templateInfo;
    private String _location;

    public TemplateInfoHolder(InputStream inputSteam, String location) throws DomainException {
        try {
            this._templateInfo = this.parse(inputSteam);
        }
        catch (Exception e) {
            throw new DomainException(_strings.get("failedToParse", new Object[]{TEMPLATE_INFO_SCHEMA_PATH}));
        }
        this._location = location;
    }

    public TemplateInfo getTemplateInfo() {
        return this._templateInfo;
    }

    public String getLocation() {
        return this._location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TemplateInfo parse(InputStream configStream) throws Exception {
        if (configStream == null) {
            throw new DomainException("Invalid stream");
        }
        try {
            URL schemaUrl = this.getClass().getClassLoader().getResource(TEMPLATE_INFO_SCHEMA_PATH);
            JAXBContext context = JAXBContext.newInstance((String)TemplateInfo.class.getPackage().getName());
            Unmarshaller unmarshaller = context.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(schemaUrl);
            unmarshaller.setSchema(schema);
            InputSource is = new InputSource(configStream);
            SAXSource source = new SAXSource(is);
            Object obj = unmarshaller.unmarshal((Source)source);
            TemplateInfo templateInfo = obj instanceof JAXBElement ? (TemplateInfo)((JAXBElement)obj).getValue() : (TemplateInfo)obj;
            return templateInfo;
        }
        finally {
            try {
                configStream.close();
                configStream = null;
            }
            catch (IOException iOException) {}
        }
    }
}

