/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.handlers;

import com.sun.data.provider.RowKey;
import com.sun.jsftemplating.component.dataprovider.MultipleListDataProvider;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.component.TableRowGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import org.glassfish.admingui.common.util.GuiUtil;

public class TableHandlers {
    public static void getSelectedSingleMapRows(HandlerContext handlerCtx) {
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("TableRowGroup");
        MultipleListDataProvider dp = (MultipleListDataProvider)trg.getSourceData();
        ArrayList<Object> selectedList = new ArrayList<Object>();
        try {
            RowKey[] rowKeys = trg.getSelectedRowKeys();
            for (int i = 0; i < rowKeys.length; ++i) {
                Object[] multiDataRows = (Object[])dp.getObject(rowKeys[i]);
                Object oneMap = multiDataRows[0];
                selectedList.add(oneMap);
            }
            handlerCtx.setOutputValue("selectedRows", selectedList);
        }
        catch (Exception ex) {
            GuiUtil.prepareException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getSelectedTableRowKeys(HandlerContext handlerCtx) {
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("tableRowGroup");
        handlerCtx.setOutputValue("rowKeys", (Object)trg.getSelectedRowKeys());
    }

    public static void deleteTableRows(HandlerContext handlerCtx) {
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("tableRowGroup");
        RowKey[] keys = (RowKey[])handlerCtx.getInputValue("rowKeys");
        MultipleListDataProvider dp = (MultipleListDataProvider)trg.getSourceData();
        for (RowKey key : keys) {
            dp.removeRow(key);
        }
    }

    public static void commitTableRowGroup(HandlerContext handlerCtx) {
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("tableRowGroup");
        MultipleListDataProvider dp = (MultipleListDataProvider)trg.getSourceData();
        dp.commitChanges();
    }

    public static void getTableListFromProperties(HandlerContext handlerCtx) {
        ArrayList data = new ArrayList();
        Map props = (Map)handlerCtx.getInputValue("Properties");
        if (props != null) {
            for (Map.Entry e : props.entrySet()) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                Object value = e.getValue();
                String valString = value == null ? "" : value.toString();
                oneRow.put("name", e.getKey());
                oneRow.put("value", valString);
                oneRow.put("selected", false);
                data.add(oneRow);
            }
        }
        handlerCtx.setOutputValue("TableList", data);
    }

    public static void getAllSingleMapRows(HandlerContext handlerCtx) {
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("TableRowGroup");
        MultipleListDataProvider dp = (MultipleListDataProvider)trg.getSourceData();
        List data = dp.getLists();
        try {
            handlerCtx.setOutputValue("Rows", data.get(0));
        }
        catch (Exception ex) {
            System.out.println("!!!! getAllSingleMapRows() Throws Exception: " + ex.toString());
        }
    }

    public static void addRowToTable(HandlerContext handlerCtx) {
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("TableRowGroup");
        List names = (List)handlerCtx.getInputValue("NameList");
        List defaults = (List)handlerCtx.getInputValue("DefaultValueList");
        Boolean hasSelected = (Boolean)handlerCtx.getInputValue("HasSelected");
        MultipleListDataProvider dp = (MultipleListDataProvider)trg.getSourceData();
        List data = dp.getLists();
        ListIterator li = data.listIterator();
        if (li.hasNext()) {
            List list = (List)li.next();
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (names != null) {
                ListIterator ni;
                if (defaults != null) {
                    if (names.size() != defaults.size()) {
                        throw new IllegalArgumentException("NameList.size(" + names.size() + ") does not match DefaultValueList.size(" + defaults.size() + ")!");
                    }
                    ni = names.listIterator();
                    ListIterator dv = defaults.listIterator();
                    while (ni.hasNext() && dv.hasNext()) {
                        String name = (String)ni.next();
                        String value = (String)dv.next();
                        if ("#{true}".equals(value)) {
                            map.put(name, true);
                            continue;
                        }
                        if ("#{false}".equals(value)) {
                            map.put(name, false);
                            continue;
                        }
                        map.put(name, value);
                    }
                } else {
                    ni = names.listIterator();
                    while (ni.hasNext()) {
                        String name = (String)ni.next();
                        map.put(name, "");
                    }
                }
            } else if (defaults == null) {
                map.put("name", "");
                map.put("value", "");
            }
            list.add(0, map);
            if (li.hasNext()) {
                list = (List)li.next();
                map = new HashMap();
                list.add(0, map);
            }
            if (hasSelected == null) {
                map.put("selected", false);
            } else if (hasSelected.booleanValue()) {
                map.put("selected", false);
            }
            while (li.hasNext()) {
                list = (List)li.next();
                map = new HashMap();
                list.add(0, map);
            }
        }
    }

    public static void convertListToArrayList(HandlerContext handlerCtx) {
        List tableList = (List)handlerCtx.getInputValue("TableList");
        String name = (String)handlerCtx.getInputValue("Name");
        if (GuiUtil.isEmpty((String)name)) {
            name = "name";
        }
        if (tableList != null) {
            ListIterator li = tableList.listIterator();
            ArrayList<String> names = new ArrayList<String>();
            while (li.hasNext()) {
                Map props = (Map)li.next();
                String val = (String)props.get(name);
                if (GuiUtil.isEmpty((String)val)) continue;
                names.add(val);
            }
            handlerCtx.setOutputValue("NameList", names);
        }
    }

    public static void getAddRemoveProps(HandlerContext handlerCtx) {
        List newList = (List)handlerCtx.getInputValue("NewList");
        ArrayList names = (ArrayList)handlerCtx.getInputValue("NameList");
        Map oldList = (Map)handlerCtx.getInputValue("OldList");
        ListIterator li = newList.listIterator();
        ArrayList<String> removeProps = new ArrayList<String>();
        Iterator iter = oldList.keySet().iterator();
        HashMap<String, String> addProps = new HashMap<String, String>();
        while (li.hasNext()) {
            String newvalue;
            String oldvalue;
            String name;
            Map props = (Map)li.next();
            if (!oldList.containsKey(props.get("name")) && (name = (String)props.get("name")) != null && !name.trim().equals("")) {
                addProps.put((String)props.get("name"), (String)props.get("value"));
            }
            if (!oldList.containsKey(props.get("name")) || (oldvalue = (String)oldList.get(props.get("name"))).equals(newvalue = (String)props.get("value"))) continue;
            removeProps.add((String)props.get("name"));
            String name2 = (String)props.get("name");
            if (name2 == null || name2.trim().equals("")) continue;
            addProps.put((String)props.get("name"), (String)props.get("value"));
        }
        if (iter != null) {
            while (iter.hasNext()) {
                Object key = iter.next();
                if (names.contains(key)) continue;
                removeProps.add((String)key);
            }
        }
        handlerCtx.setOutputValue("AddProps", addProps);
        handlerCtx.setOutputValue("RemoveProps", removeProps);
    }

    public static void convertRowsToProperties(HandlerContext handlerCtx) {
        List newList = (List)handlerCtx.getInputValue("NewList");
        ListIterator li = newList.listIterator();
        HashMap<String, String> addProps = new HashMap<String, String>();
        while (li.hasNext()) {
            Map props = (Map)li.next();
            String name = (String)props.get("name");
            if (name == null || name.trim().equals("")) continue;
            if (addProps.containsKey(name)) {
                GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.duplicatePropTableKey", (Object[])new Object[]{name}));
                return;
            }
            addProps.put(name, (String)props.get("value"));
        }
        handlerCtx.setOutputValue("AddProps", addProps);
    }

    public static void getProperties(HandlerContext handlerCtx) {
        List newList = (List)handlerCtx.getInputValue("NewList");
        ListIterator li = newList.listIterator();
        Properties addProps = new Properties();
        while (li.hasNext()) {
            String value;
            Map props = (Map)li.next();
            String name = (String)props.get("name");
            if (name == null || name.trim().equals("") || (value = (String)props.get("value")) == null || value.trim().equals("")) continue;
            addProps.put(name, value);
        }
        handlerCtx.setOutputValue("AddProps", (Object)addProps);
    }
}

