/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.util.fileStreamer;

import com.sun.jsftemplating.util.fileStreamer.BaseContext;
import com.sun.jsftemplating.util.fileStreamer.ContentSource;
import com.sun.jsftemplating.util.fileStreamer.FileStreamer;
import com.sun.jsftemplating.util.fileStreamer.ResourceContentSource;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;

public class FacesStreamerContext
extends BaseContext {
    private static final String INIT_DONE = "__jsft_StreamContextInitialized";
    public static final String FACES_CONTEXT = "facesContext";
    public static final String DEFAULT_DISPOSITION = "attachment";

    public FacesStreamerContext(FacesContext ctx) {
        this.setFacesContext(ctx);
        this.init();
    }

    protected synchronized void init() {
        String end;
        String path;
        FacesContext ctx = this.getFacesContext();
        if (ctx == null) {
            return;
        }
        ExternalContext extCtx = ctx.getExternalContext();
        boolean initDone = extCtx.getApplicationMap().containsKey(INIT_DONE);
        if (initDone) {
            return;
        }
        String sources = extCtx.getInitParameter("ContentSources");
        FileStreamer fs = this.getFileStreamer();
        if (sources != null && sources.trim().length() != 0) {
            StringTokenizer tokens = new StringTokenizer(sources, " \t\n\r\f,;:");
            while (tokens.hasMoreTokens()) {
                fs.registerContentSource(tokens.nextToken());
            }
        }
        String allow = extCtx.getInitParameter("com.sun.jsftemplating.FS_ALLOW_PATHS");
        ArrayList<String> paths = new ArrayList<String>();
        if (allow != null) {
            StringTokenizer tok = new StringTokenizer(allow, ",:;");
            while (tok.hasMoreTokens()) {
                path = tok.nextToken();
                end = path.endsWith("/") ? "/" : "";
                paths.add(ResourceContentSource.normalize(path) + end);
            }
        } else {
            paths.add("");
        }
        this.setAllowedPaths(extCtx, paths);
        String deny = extCtx.getInitParameter("com.sun.jsftemplating.FS_DENY_PATHS");
        paths = new ArrayList();
        if (deny != null) {
            StringTokenizer tok = new StringTokenizer(deny, ",:;");
            while (tok.hasMoreTokens()) {
                path = tok.nextToken();
                end = path.endsWith("/") ? "/" : "";
                paths.add(ResourceContentSource.normalize(path) + end);
            }
        } else {
            paths.add("WEB-INF/");
            paths.add("META-INF/");
        }
        this.setDeniedPaths(extCtx, paths);
        if (ctx != null) {
            extCtx.getApplicationMap().put(INIT_DONE, true);
        }
    }

    @Override
    public FileStreamer getFileStreamer() {
        return FileStreamer.getFileStreamer(this.getFacesContext());
    }

    @Override
    public ContentSource getContentSource() {
        ContentSource src = (ContentSource)this.getAttribute("_contentSource");
        if (src != null) {
            return src;
        }
        FacesContext ctx = this.getFacesContext();
        String id = (String)ctx.getExternalContext().getRequestParameterMap().get("contentSourceId");
        if (id == null) {
            id = "resourceCS";
        }
        if ((src = this.getFileStreamer().getContentSource(id)) == null) {
            throw new RuntimeException("The ContentSource with id '" + id + "' is not registered!");
        }
        this.setAttribute("_contentSource", src);
        return src;
    }

    @Override
    public boolean hasPermission(ContentSource src) {
        String filename = src.getResourcePath(this);
        ExternalContext extCtx = this.getFacesContext().getExternalContext();
        boolean ok = false;
        List<String> paths = this.getAllowedPaths(extCtx);
        for (String path : paths) {
            if (!filename.startsWith(path)) continue;
            ok = true;
            break;
        }
        if (ok) {
            paths = this.getDeniedPaths(extCtx);
            for (String path : paths) {
                if ((!path.startsWith("*") || !filename.endsWith(path.substring(1))) && !filename.startsWith(path)) continue;
                ok = false;
                break;
            }
        }
        return ok;
    }

    public List<String> getAllowedPaths(ExternalContext extCtx) {
        return (List)extCtx.getApplicationMap().get("__jsft_AllowPath");
    }

    public void setAllowedPaths(ExternalContext ctx, List<String> paths) {
        ctx.getApplicationMap().put("__jsft_AllowPath", paths);
    }

    public void setDeniedPaths(ExternalContext ctx, List<String> paths) {
        ctx.getApplicationMap().put("__jsft_DenyPath", paths);
    }

    public List<String> getDeniedPaths(ExternalContext extCtx) {
        return (List)extCtx.getApplicationMap().get("__jsft_DenyPath");
    }

    @Override
    public void writeHeader(ContentSource source) {
        String contentType;
        ServletResponse resp = (ServletResponse)this.getFacesContext().getExternalContext().getResponse();
        long longTime = source.getLastModified(this);
        if (longTime != -1L) {
            HttpServletResponse httpResponse = (HttpServletResponse)resp;
            httpResponse.setDateHeader("Last-Modified", longTime);
            httpResponse.setDateHeader("Expires", new Date().getTime() + 1708667904L);
        }
        if ((contentType = (String)this.getAttribute("ContentType")) == null) {
            String ext = (String)this.getAttribute("extension");
            if (ext != null) {
                contentType = FileStreamer.getMimeType(ext);
            }
            if (contentType == null) {
                contentType = FileStreamer.getDefaultMimeType();
            }
        }
        ((HttpServletResponse)resp).setHeader("Content-type", contentType);
        String disposition = (String)this.getAttribute("disposition");
        String filename = (String)this.getAttribute("filename");
        if (disposition == null) {
            if (filename != null) {
                ((HttpServletResponse)resp).setHeader("Content-Disposition", "attachment;filename=\"" + filename + "\"");
            }
        } else {
            if (filename != null) {
                disposition = disposition + ";filename=\"" + filename + "\"";
            }
            ((HttpServletResponse)resp).setHeader("Content-Disposition", disposition);
        }
    }

    @Override
    public void sendError(int code, String msg) throws IOException {
        HttpServletResponse resp = (HttpServletResponse)this.getFacesContext().getExternalContext().getResponse();
        if (msg == null) {
            resp.sendError(code);
        } else {
            resp.sendError(code, msg);
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.getFacesContext().getExternalContext().getResponseOutputStream();
    }

    public FacesContext getFacesContext() {
        return (FacesContext)this.getAttribute(FACES_CONTEXT);
    }

    protected void setFacesContext(FacesContext ctx) {
        this.setAttribute(FACES_CONTEXT, ctx);
    }
}

