/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.ListManager;
import com.sun.webui.jsf.component.ListSelector;
import com.sun.webui.jsf.model.Separator;
import com.sun.webui.jsf.model.list.EndGroup;
import com.sun.webui.jsf.model.list.ListItem;
import com.sun.webui.jsf.model.list.StartGroup;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.render.Renderer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public abstract class ListRendererBase
extends Renderer {
    private static final boolean DEBUG = false;
    public static final String[] STRING_ATTRIBUTES = new String[]{"onBlur", "onClick", "onDblClick", "onFocus", "onMouseDown", "onMouseUp", "onMouseOver", "onMouseMove", "onMouseOut", "onKeyPress", "onKeyDown", "onKeyUp", "onSelect"};
    protected static final String SEPARATOR = "|";

    protected static void renderListComponent(ListSelector component, FacesContext context, String[] styles) throws IOException {
        boolean readonly = component.isReadOnly();
        if (readonly) {
            component.setRequired(false);
        }
        UIComponent label = component.getLabelComponent();
        ResponseWriter writer = context.getResponseWriter();
        String id = component.getClientId(context);
        boolean spanRendered = false;
        if (label != null) {
            ListRendererBase.renderOpenEncloser(component, context, "span", styles[8]);
            spanRendered = true;
            writer.writeText((Object)"\n", null);
            if (!component.isLabelOnTop() && component.getRows() > 1) {
                Map attributes = label.getAttributes();
                Object styleClass = attributes.get("styleClass");
                if (styleClass == null) {
                    attributes.put("styleClass", styles[9]);
                } else if (!styleClass.toString().contains(styles[9])) {
                    attributes.put("styleClass", styleClass + " " + styles[9]);
                }
            }
            RenderingUtilities.renderComponent(label, context);
            writer.writeText((Object)"\n", null);
            if (component.isLabelOnTop()) {
                writer.startElement("br", (UIComponent)component);
                writer.endElement("br");
                writer.writeText((Object)"\n", null);
            }
            writer.writeText((Object)"\n", null);
            id = id.concat("_list");
        }
        if (readonly) {
            UIComponent value = component.getReadOnlyValueComponent();
            if (label == null) {
                value.getAttributes().put("style", component.getStyle());
                value.getAttributes().put("styleClass", component.getStyleClass());
            }
            RenderingUtilities.renderComponent(value, context);
        } else {
            ListRendererBase.recordRenderedValue((UIComponent)component);
            ListRendererBase.renderList(component, id, context, styles, label == null);
        }
        if (label != null) {
            context.getResponseWriter().endElement("span");
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    protected static void renderOpenEncloser(ListManager component, FacesContext context, String element, String hiddenStyle) throws IOException {
        String id = component.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.writeText((Object)"\n", null);
        writer.startElement(element, (UIComponent)component);
        writer.writeAttribute("id", (Object)id, "id");
        String style = component.getStyle();
        if (style != null && style.length() > 0) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        style = component.getStyleClass();
        if (component.isVisible()) {
            if (style != null && style.length() > 0) {
                writer.writeAttribute("class", (Object)style, "class");
            }
        } else {
            style = style == null ? hiddenStyle : style + " " + hiddenStyle;
            writer.writeAttribute("class", (Object)style, "class");
        }
        writer.writeText((Object)"\n", null);
    }

    protected static void renderHiddenValue(UIComponent component, FacesContext context, ResponseWriter writer, String hiddenStyle) throws IOException {
        ListManager listManager = (ListManager)component;
        ListRendererBase.recordRenderedValue(component);
        String hiddenID = component.getClientId(context).concat("_list_value");
        String hiddenLabelID = component.getClientId(context).concat("_hiddenlabel");
        String[] values = listManager.getValueAsStringArray(context);
        writer.startElement("label", component);
        writer.writeAttribute("id", (Object)hiddenLabelID, null);
        writer.writeAttribute("for", (Object)hiddenID, "for");
        writer.writeAttribute("class", (Object)hiddenStyle, null);
        writer.endElement("label");
        writer.startElement("select", component);
        writer.writeAttribute("id", (Object)hiddenID, null);
        writer.writeAttribute("name", (Object)hiddenID, null);
        writer.writeAttribute("multiple", (Object)"true", null);
        writer.writeAttribute("class", (Object)hiddenStyle, null);
        writer.writeText((Object)"\n", null);
        for (int counter = 0; counter < values.length; ++counter) {
            writer.startElement("option", component);
            writer.writeAttribute("selected", (Object)"selected", null);
            writer.writeAttribute("value", (Object)values[counter], null);
            writer.writeText((Object)values[counter], null);
            writer.endElement("option");
            writer.writeText((Object)"\n", null);
        }
        writer.endElement("select");
    }

    protected static void renderList(ListManager component, String id, FacesContext context, String[] styles) throws IOException {
        ListRendererBase.renderList(component, id, context, styles, false);
    }

    private static void renderList(ListManager listManager, String id, FacesContext context, String[] styles, boolean renderUserStyles) throws IOException {
        String tooltip;
        int size;
        String styleClass = styles[1];
        if (listManager.isDisabled()) {
            styleClass = styles[2];
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("select", (UIComponent)listManager);
        if (renderUserStyles) {
            String compStyleClass;
            String style = listManager.getStyle();
            if (style != null && style.length() > 0) {
                writer.writeAttribute("style", (Object)style, null);
            }
            if ((compStyleClass = ListRendererBase.getStyleClass(listManager, styles[8])) != null && compStyleClass.length() > 0) {
                styleClass = compStyleClass + " " + styleClass;
            }
        }
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("id", (Object)id, null);
        if (listManager.mainListSubmits()) {
            writer.writeAttribute("name", (Object)id, null);
        }
        if ((size = listManager.getRows()) < 1) {
            size = 12;
        }
        writer.writeAttribute("size", (Object)String.valueOf(size), null);
        if (listManager.isMultiple()) {
            writer.writeAttribute("multiple", (Object)"multiple", null);
        }
        if (listManager.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if ((tooltip = listManager.getToolTip()) != null) {
            writer.writeAttribute("title", (Object)tooltip, null);
        }
        writer.writeAttribute("onchange", (Object)styles[0], null);
        int tabindex = listManager.getTabIndex();
        if (tabindex > 0 && tabindex < Short.MAX_VALUE) {
            writer.writeAttribute("tabindex", (Object)String.valueOf(tabindex), "tabindex");
        }
        RenderingUtilities.writeStringAttributes((UIComponent)listManager, writer, STRING_ATTRIBUTES);
        writer.writeText((Object)"\n", null);
        ListRendererBase.renderListOptions((UIComponent)listManager, listManager.getListItems(context, true), writer, styles);
        writer.endElement("select");
        writer.writeText((Object)"\n", null);
    }

    protected static void renderListOptions(UIComponent component, Iterator optionsIterator, ResponseWriter writer, String[] styles) throws IOException {
        boolean noSeparator = true;
        while (optionsIterator.hasNext()) {
            Object option = optionsIterator.next();
            if (option instanceof Separator) {
                ListRendererBase.renderSeparator(component, writer, styles[7]);
                continue;
            }
            if (option instanceof StartGroup) {
                StartGroup group = (StartGroup)option;
                if (!noSeparator) {
                    ListRendererBase.renderSeparator(component, writer, styles[7]);
                }
                writer.startElement("optgroup", component);
                writer.writeAttribute("label", (Object)group.getLabel(), null);
                writer.writeAttribute("class", (Object)styles[6], null);
                writer.write("\n");
                noSeparator = true;
                continue;
            }
            if (option instanceof EndGroup) {
                writer.endElement("optgroup");
                writer.write("\n");
                if (optionsIterator.hasNext()) {
                    ListRendererBase.renderSeparator(component, writer, styles[7]);
                }
                noSeparator = true;
                continue;
            }
            ListRendererBase.renderListOption(component, (ListItem)option, writer, styles);
            noSeparator = false;
        }
    }

    protected static void renderListOption(UIComponent list, ListItem listItem, ResponseWriter writer, String[] styles) throws IOException {
        boolean title;
        String styleClass = styles[3];
        if (listItem.isDisabled()) {
            styleClass = styles[4];
        } else if (listItem.isSelected()) {
            styleClass = styles[5];
        }
        writer.writeText((Object)"\t", null);
        writer.startElement("option", list);
        writer.writeAttribute("class", (Object)styleClass, null);
        String itemValue = listItem.getValue();
        if (itemValue != null) {
            writer.writeAttribute("value", (Object)itemValue, null);
        }
        if (listItem.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (listItem.isSelected()) {
            writer.writeAttribute("selected", (Object)"selected", null);
        }
        if (title = listItem.isTitle()) {
            writer.write("&#8212; ");
        }
        writer.write(listItem.getLabel());
        if (title) {
            writer.write(" &#8212;");
        }
        writer.endElement("option");
        writer.writeText((Object)"\n", null);
    }

    protected static void renderSeparator(UIComponent component, ResponseWriter writer, String style) throws IOException {
        if (!(component instanceof ListSelector)) {
            return;
        }
        ListSelector selector = (ListSelector)component;
        if (!selector.isSeparators()) {
            return;
        }
        writer.writeText((Object)"\t", null);
        writer.startElement("option", component);
        writer.writeAttribute("class", (Object)style, null);
        writer.writeAttribute("disabled", (Object)"disabled", null);
        int numEms = selector.getSeparatorLength();
        StringBuilder labelBuffer = new StringBuilder();
        for (int em = 0; em < numEms; ++em) {
            labelBuffer.append("-");
        }
        writer.writeText((Object)labelBuffer.toString(), null);
        writer.endElement("option");
        writer.writeText((Object)"\n", null);
    }

    protected static void renderReadOnlyList(ListManager component, UIComponent label, FacesContext context, String hiddenStyle) throws IOException {
        UIComponent value = component.getReadOnlyValueComponent();
        ListRendererBase.renderOpenEncloser(component, context, "span", hiddenStyle);
        if (label != null) {
            RenderingUtilities.renderComponent(label, context);
        }
        RenderingUtilities.renderComponent(value, context);
        context.getResponseWriter().endElement("span");
    }

    private static String getStyleClass(ListManager component, String hiddenStyle) {
        String style = component.getStyleClass();
        if (style != null && style.length() == 0) {
            style = null;
        }
        if (!component.isVisible()) {
            style = style == null ? hiddenStyle : style + " " + hiddenStyle;
        }
        return style;
    }

    public void decode(FacesContext context, UIComponent component) {
        String id = component.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        Object valueObject = params.get(id);
        if (valueObject == null) {
            id = id.concat("_list");
        }
        ListRendererBase.decode(context, component, id);
    }

    protected static void decode(FacesContext context, UIComponent component, String id) {
        ListManager lmComponent = (ListManager)component;
        if (lmComponent.isReadOnly()) {
            return;
        }
        Map params = context.getExternalContext().getRequestParameterValuesMap();
        Object p = params.get(id);
        String[] values = p == null ? new String[]{} : (String[])p;
        if (values.length > 1) {
            ArrayList<String> newParams = new ArrayList<String>();
            for (int i = 0; i < values.length; ++i) {
                if ("com_sun_webui_jsf_NONESELECTED".equals(values[i])) continue;
                newParams.add(values[i]);
            }
            values = newParams.toArray(new String[newParams.size()]);
        } else if (values.length == 1 && "com_sun_webui_jsf_NONESELECTED".equals(values[0])) {
            return;
        }
        if (values.length > 0 || !lmComponent.isDisabled()) {
            lmComponent.setSubmittedValue(values);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected static String[] getUserInput(FacesContext context, UIComponent component) {
        String id = component.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterValuesMap();
        String[] values = null;
        if (params.containsKey(id)) {
            values = (String[])params.get(id);
        }
        if (values == null) {
            values = new String[]{};
        }
        return values;
    }

    private static void recordRenderedValue(UIComponent component) {
        if (component instanceof EditableValueHolder && ((EditableValueHolder)component).getSubmittedValue() == null) {
            ConversionUtilities.setRenderedValue(component, ((EditableValueHolder)component).getValue());
        }
    }

    private static void log(String msg) {
        LogUtil.finest(ListRendererBase.class.getName() + "::" + msg);
    }
}

