/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.lang.annotation.Annotation;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestUtil;
import org.glassfish.admingui.common.util.TargetUtil;
import org.glassfish.api.admin.InstanceState;

public class ClusterHandler {
    public static final String CLUSTER_RESOURCE_NAME = "org.glassfish.cluster.admingui.Strings";
    public static final String RUNNING = "RUNNING";
    public static final String NOT_RUNNING = "NOT_RUNNING";
    public static final String PARTIALLY_RUNNING = "PARTIALLY_RUNNING";

    public static void getClusterStatusSummary(HandlerContext handlerCtx) {
        block6: {
            Map statusMap = (Map)handlerCtx.getInputValue("statusMap");
            int running = 0;
            int notRunning = 0;
            int requireRestart = 0;
            int unknown = 0;
            try {
                for (Object value : statusMap.values()) {
                    if (value.toString().equals(InstanceState.StateType.RUNNING.getDescription())) {
                        ++running;
                        continue;
                    }
                    if (value.toString().equals(InstanceState.StateType.NOT_RUNNING.getDescription())) {
                        ++notRunning;
                        continue;
                    }
                    if (value.toString().equals(InstanceState.StateType.RESTART_REQUIRED.getDescription())) {
                        ++requireRestart;
                        continue;
                    }
                    ++unknown;
                    GuiUtil.getLogger().severe("Unknown Status");
                }
                handlerCtx.setOutputValue("disableEjb", (Object)(notRunning <= 0 ? 1 : 0));
                handlerCtx.setOutputValue("disableStart", (Object)(notRunning <= 0 ? 1 : 0));
                handlerCtx.setOutputValue("disableStop", (Object)(running + requireRestart <= 0 ? 1 : 0));
                handlerCtx.setOutputValue("numRunning", (Object)(running > 0 ? GuiUtil.getMessage(CLUSTER_RESOURCE_NAME, "cluster.number.instance.running", new String[]{"" + running, GuiUtil.getCommonMessage("status.image.RUNNING")}) : ""));
                handlerCtx.setOutputValue("numNotRunning", (Object)(notRunning > 0 ? GuiUtil.getMessage(CLUSTER_RESOURCE_NAME, "cluster.number.instance.notRunning", new String[]{"" + notRunning, GuiUtil.getCommonMessage("status.image.NOT_RUNNING")}) : ""));
                handlerCtx.setOutputValue("numRequireRestart", (Object)(requireRestart > 0 ? GuiUtil.getMessage(CLUSTER_RESOURCE_NAME, "cluster.number.instance.requireRestart", new String[]{"" + requireRestart, GuiUtil.getCommonMessage("status.image.REQUIRES_RESTART")}) : ""));
            }
            catch (Exception ex) {
                handlerCtx.setOutputValue("numRunning", (Object)GuiUtil.getMessage(CLUSTER_RESOURCE_NAME, "cluster.status.unknown"));
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage("log.error.getClusterStatusSummary") + ex.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block6;
                ex.printStackTrace();
            }
        }
    }

    public static void isClusterName(HandlerContext handlerCtx) {
        if (!TargetUtil.isCluster((String)handlerCtx.getInputValue("clusterName"))) {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.NoSuchCluster"));
            handlerCtx.setOutputValue("exists", (Object)false);
        } else {
            handlerCtx.setOutputValue("exists", (Object)true);
        }
    }

    public static void isInstanceName(HandlerContext handlerCtx) {
        if (!TargetUtil.isInstance((String)handlerCtx.getInputValue("instanceName"))) {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.NoSuchInstance"));
            handlerCtx.setOutputValue("exists", (Object)false);
        } else {
            handlerCtx.setOutputValue("exists", (Object)true);
        }
    }

    public static void isConfigName(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("configName");
        List config = TargetUtil.getConfigs();
        if (!config.contains(configName)) {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.NoSuchConfig"));
            handlerCtx.setOutputValue("exists", (Object)false);
        } else {
            handlerCtx.setOutputValue("exists", (Object)true);
        }
    }

    public static void saveInstanceWeight(HandlerContext handlerCtx) {
        List rows = (List)handlerCtx.getInputValue("rows");
        ArrayList<String> errorInstances = new ArrayList<String>();
        Map<String, Object> response = null;
        String prefix = GuiUtil.getSessionValue("REST_URL") + "/servers/server/";
        for (Map oneRow : rows) {
            String instanceName = (String)oneRow.get("encodedName");
            HashMap<String, Object> attrsMap = new HashMap<String, Object>();
            attrsMap.put("lbWeight", oneRow.get("lbWeight"));
            try {
                response = RestUtil.restRequest(prefix + instanceName, attrsMap, "post", null, false);
            }
            catch (Exception ex) {
                GuiUtil.getLogger().severe(GuiUtil.getCommonMessage("LOG_SAVE_INSTANCE_WEIGHT_ERROR", new Object[]{prefix + instanceName, attrsMap}));
                response = null;
            }
            if (response != null) continue;
            errorInstances.add(instanceName);
        }
        if (errorInstances.size() > 0) {
            String details = GuiUtil.getMessage(CLUSTER_RESOURCE_NAME, "instance.error.updateWeight", new String[]{"" + errorInstances});
            GuiUtil.handleError(handlerCtx, details);
        }
    }

    public static void clusterAction(HandlerContext handlerCtx) {
        String action = (String)handlerCtx.getInputValue("action");
        List rows = (List)handlerCtx.getInputValue("rows");
        String errorMsg = null;
        String prefix = GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster/";
        for (Map oneRow : rows) {
            String clusterName = (String)oneRow.get("name");
            String endpoint = prefix + clusterName + "/" + action;
            String method = "post";
            if (action.equals("delete-cluster")) {
                Map clusterInstanceMap = (Map)handlerCtx.getInputValue("extraInfo");
                List instanceNameList = (List)clusterInstanceMap.get(clusterName);
                for (String instanceName : instanceNameList) {
                    errorMsg = ClusterHandler.deleteInstance(instanceName);
                    if (errorMsg == null) continue;
                    GuiUtil.prepareAlert("error", GuiUtil.getMessage("msg.Error"), errorMsg);
                    return;
                }
                endpoint = prefix + clusterName;
                method = "delete";
            }
            try {
                GuiUtil.getLogger().info(endpoint);
                RestUtil.restRequest(endpoint, null, method, null, false);
            }
            catch (Exception ex) {
                GuiUtil.prepareAlert("error", GuiUtil.getMessage("msg.Error"), ex.getMessage());
                return;
            }
        }
    }

    public static void instanceAction(HandlerContext handlerCtx) {
        String action = (String)handlerCtx.getInputValue("action");
        List rows = (List)handlerCtx.getInputValue("rows");
        String prefix = GuiUtil.getSessionValue("REST_URL") + "/servers/server/";
        for (Map oneRow : rows) {
            String instanceName = (String)oneRow.get("name");
            if (action.equals("delete-instance")) {
                String errorMsg = ClusterHandler.deleteInstance(instanceName);
                if (errorMsg == null) continue;
                GuiUtil.prepareAlert("error", GuiUtil.getMessage("msg.Error"), errorMsg);
                return;
            }
            try {
                String endpoint = prefix + instanceName + "/" + action;
                GuiUtil.getLogger().info(endpoint);
                RestUtil.restRequest(endpoint, null, "post", null, false);
            }
            catch (Exception ex) {
                String endpoint = prefix + instanceName + "/" + action;
                GuiUtil.getLogger().severe(GuiUtil.getCommonMessage("LOG_ERROR_INSTANCE_ACTION", new Object[]{endpoint, "null"}));
                GuiUtil.prepareAlert("error", GuiUtil.getMessage("msg.Error"), ex.getMessage());
                return;
            }
        }
        if (action.equals("stop-instance")) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void nodeAction(HandlerContext handlerCtx) {
        String action = (String)handlerCtx.getInputValue("action");
        HashMap nodeInstanceMap = (HashMap)handlerCtx.getInputValue("nodeInstanceMap");
        if (nodeInstanceMap == null) {
            nodeInstanceMap = new HashMap();
        }
        List rows = (List)handlerCtx.getInputValue("rows");
        String prefix = GuiUtil.getSessionValue("REST_URL") + "/nodes/";
        for (Map oneRow : rows) {
            String localhostNodeName;
            String nodeName = (String)oneRow.get("name");
            if (nodeName.equals(localhostNodeName = (String)GuiUtil.getSessionValue("localhostNodeName"))) {
                GuiUtil.prepareAlert("error", GuiUtil.getMessage("msg.Error"), GuiUtil.getMessage(CLUSTER_RESOURCE_NAME, "node.error.removeLocalhost", new String[]{localhostNodeName}));
                return;
            }
            List instancesList = (List)nodeInstanceMap.get(nodeName);
            if (instancesList != null && instancesList.size() != 0) {
                GuiUtil.prepareAlert("error", GuiUtil.getMessage("msg.Error"), GuiUtil.getMessage(CLUSTER_RESOURCE_NAME, "nodes.instanceExistError", new String[]{nodeName, nodeInstanceMap.get(nodeName).toString()}));
                return;
            }
            if (action.equals("delete-node")) {
                try {
                    String endpoint = prefix + "node/" + nodeName;
                    GuiUtil.getLogger().info(endpoint);
                    RestUtil.restRequest(endpoint, null, "DELETE", null, false);
                    continue;
                }
                catch (Exception ex) {
                    GuiUtil.getLogger().severe(GuiUtil.getCommonMessage("LOG_NODE_ACTION_ERROR", new Object[]{prefix + nodeName, "DELETE", "null"}));
                    GuiUtil.prepareAlert("error", GuiUtil.getMessage("msg.Error"), ex.getMessage());
                    return;
                }
            }
            HashMap<String, Object> payload = null;
            String type = (String)oneRow.get("type");
            Object endpoint = "";
            if (!action.equals("delete-node-uninstall")) continue;
            try {
                if ("CONFIG".equals(type)) {
                    endpoint = prefix + "delete-node-config";
                    payload = new HashMap<String, Object>();
                    payload.put("id", nodeName);
                } else if ("SSH".equals(type)) {
                    endpoint = prefix + "delete-node-ssh";
                    payload = new HashMap();
                    payload.put("id", nodeName);
                    payload.put("uninstall", "true");
                } else {
                    GuiUtil.getLogger().info((String)endpoint);
                }
                RestUtil.restRequest((String)endpoint, payload, "DELETE", null, false);
            }
            catch (Exception ex) {
                GuiUtil.getLogger().severe(GuiUtil.getCommonMessage("LOG_NODE_ACTION_ERROR", new Object[]{endpoint, "", payload}));
                GuiUtil.prepareAlert("error", GuiUtil.getMessage("msg.Error"), ex.getMessage());
                return;
            }
        }
    }

    public static void createClusterInstances(HandlerContext handlerCtx) {
        String clusterName = (String)handlerCtx.getInputValue("clusterName");
        List instanceRow = (List)handlerCtx.getInputValue("instanceRow");
        HashMap<String, Object> attrsMap = new HashMap<String, Object>();
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/create-instance";
        for (Map oneInstance : instanceRow) {
            attrsMap.put("name", oneInstance.get("name"));
            attrsMap.put("cluster", clusterName);
            attrsMap.put("node", oneInstance.get("node"));
            try {
                GuiUtil.getLogger().info(endpoint);
                GuiUtil.getLogger().info(((Object)attrsMap).toString());
                RestUtil.restRequest(endpoint, attrsMap, "post", null, false);
                String wt = (String)oneInstance.get("weight");
                if (GuiUtil.isEmpty(wt)) continue;
                String encodedInstanceName = URLEncoder.encode((String)oneInstance.get("name"), "UTF-8");
                String ep = GuiUtil.getSessionValue("REST_URL") + "/servers/server/" + encodedInstanceName;
                HashMap<String, Object> wMap = new HashMap<String, Object>();
                wMap.put("lbWeight", wt);
                RestUtil.restRequest(ep, wMap, "post", null, false);
            }
            catch (Exception ex) {
                GuiUtil.getLogger().severe(GuiUtil.getCommonMessage("LOG_CREATE_CLUSTER_INSTANCE", new Object[]{clusterName, endpoint, attrsMap}));
                GuiUtil.prepareException(handlerCtx, ex);
            }
        }
    }

    public static void getDeploymentTargets(HandlerContext handlerCtx) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("server");
        try {
            List instances;
            List clusterList = (List)handlerCtx.getInputValue("clusterList");
            if (clusterList != null) {
                for (String oneCluster : clusterList) {
                    result.add(oneCluster);
                }
            }
            if ((instances = (List)handlerCtx.getInputValue("listInstanceProps")) != null) {
                for (Map instance : instances) {
                    result.add((String)instance.get("name"));
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe(ex.getLocalizedMessage());
        }
        handlerCtx.setOutputValue("result", result);
    }

    private static String deleteInstance(String instanceName) {
        try {
            String endpoint = GuiUtil.getSessionValue("REST_URL") + "/servers/server/" + instanceName + "/delete-instance";
            GuiUtil.getLogger().info(endpoint);
            RestUtil.restRequest(endpoint, null, "post", null, false);
            return null;
        }
        catch (Exception ex) {
            String endpoint = GuiUtil.getSessionValue("REST_URL") + "/servers/server/" + instanceName + "/delete-instance\n";
            GuiUtil.getLogger().severe(GuiUtil.getCommonMessage("LOG_DELETE_INSTANCE", new Object[]{endpoint, "null"}));
            return ex.getMessage();
        }
    }

    public static void listClusters(HandlerContext handlerCtx) {
        List clusters = TargetUtil.getClusters();
        handlerCtx.setOutputValue("clusters", (Object)clusters);
    }

    public static void listConfigs(HandlerContext handlerCtx) {
        List configs = TargetUtil.getConfigs();
        handlerCtx.setOutputValue("configs", (Object)configs);
    }

    public static void listInstances(HandlerContext handlerCtx) {
        ArrayList instances = new ArrayList();
        HashMap statusMap = new HashMap();
        HashMap uptimeMap = new HashMap();
        List keys = (List)handlerCtx.getInputValue("optionKeys");
        List values = (List)handlerCtx.getInputValue("optionValues");
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        if (keys != null && values != null) {
            for (int i = 0; i < keys.size(); ++i) {
                attrs.put((String)keys.get(i), values.get(i));
            }
        }
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/list-instances";
        try {
            List instanceList;
            Map<String, Object> responseMap = RestUtil.restRequest(endpoint, attrs, "GET", handlerCtx, false);
            Map extraPropertiesMap = (Map)((Map)responseMap.get("data")).get("extraProperties");
            if (extraPropertiesMap != null && (instanceList = (List)extraPropertiesMap.get("instanceList")) != null) {
                for (Map oneInstance : instanceList) {
                    instances.add(oneInstance.get("name"));
                    statusMap.put(oneInstance.get("name"), oneInstance.get("status"));
                    uptimeMap.put(oneInstance.get("name"), oneInstance.get("uptime"));
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe(GuiUtil.getCommonMessage("LOG_LIST_INSTANCES", new Object[]{endpoint, attrs}));
        }
        handlerCtx.setOutputValue("instances", instances);
        handlerCtx.setOutputValue("statusMap", statusMap);
        handlerCtx.setOutputValue("uptimeMap", uptimeMap);
        handlerCtx.setOutputValue("listEmpty", (Object)instances.isEmpty());
    }

    public static void getClusterNameForInstance(HandlerContext handlerCtx) {
        block3: {
            String instanceName = (String)handlerCtx.getInputValue("instanceName");
            try {
                ArrayList<String> clusterList = new ArrayList<String>(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster").keySet());
                for (String oneCluster : clusterList) {
                    ArrayList<String> serverRefs = new ArrayList<String>(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster/" + URLEncoder.encode(oneCluster, "UTF-8") + "/server-ref").keySet());
                    if (!serverRefs.contains(instanceName)) continue;
                    handlerCtx.setOutputValue("clusterName", (Object)oneCluster);
                    return;
                }
            }
            catch (Exception ex) {
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage("LOG_GET_CLUSTERNAME_FOR_INSTANCE"));
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block3;
                ex.printStackTrace();
            }
        }
    }

    public static void convertNodePswd(HandlerContext handlerCtx) {
        String pswd = (String)handlerCtx.getInputValue("pswd");
        if (GuiUtil.isEmpty(pswd)) {
            handlerCtx.setOutputValue("psSelected", (Object)1);
            return;
        }
        if (pswd.startsWith("${ALIAS=") && pswd.endsWith("}")) {
            String pswdAlias = pswd.substring(8, pswd.length() - 1);
            handlerCtx.setOutputValue("pswdAlias", (Object)pswdAlias);
            handlerCtx.setOutputValue("psSelected", (Object)3);
            return;
        }
        handlerCtx.setOutputValue("psSelected", (Object)2);
        handlerCtx.setOutputValue("pswdText", (Object)pswd);
    }

    public static void convertToAlias(HandlerContext handlerCtx) {
        String in = (String)handlerCtx.getInputValue("in");
        String out = null;
        if (!GuiUtil.isEmpty(in)) {
            out = "${ALIAS=" + in + "}";
        }
        handlerCtx.setOutputValue("out", (Object)out);
    }

    public static void changeClusterStatus(HandlerContext handlerCtx) {
        String Enabled = (String)handlerCtx.getInputValue("Enabled");
        String clusterName = (String)handlerCtx.getInputValue("clusterName");
        List selectedRows = (List)handlerCtx.getInputValue("selectedRows");
        boolean forLB = (Boolean)handlerCtx.getInputValue("forLB");
        for (Map oneRow : selectedRows) {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            String name = (String)oneRow.get("name");
            String endpoint = GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster/" + clusterName + "/server-ref/" + name;
            if (forLB) {
                attrs.put("lbEnabled", Enabled);
                RestUtil.restRequest(endpoint, attrs, "post", handlerCtx, false);
                continue;
            }
            attrs.put("enabled", Enabled);
            RestUtil.restRequest(endpoint, attrs, "post", handlerCtx, false);
        }
    }

    public static void getClusterForConfig(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("configName");
        String clusterName = null;
        Domain domain = (Domain)GuiUtil.getHabitat().getService(Domain.class, new Annotation[0]);
        for (Cluster cluster : domain.getClusters().getCluster()) {
            if (!cluster.getConfigRef().equals(configName)) continue;
            clusterName = cluster.getName();
            break;
        }
        if (clusterName != null) {
            handlerCtx.setOutputValue("cluster", clusterName);
        }
    }
}

