/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.descriptor;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InjectionInfo;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.LocaleEncodingMappingDescriptor;
import com.sun.enterprise.deployment.LocaleEncodingMappingListDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.NamedReferencePair;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.util.ComponentPostVisitor;
import com.sun.enterprise.deployment.util.ComponentVisitor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.web.AppListenerDescriptor;
import com.sun.enterprise.deployment.web.ContextParameter;
import com.sun.enterprise.deployment.web.EnvironmentEntry;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.deployment.web.MimeMapping;
import com.sun.enterprise.deployment.web.ResourceReference;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.SecurityRole;
import com.sun.enterprise.deployment.web.SecurityRoleReference;
import com.sun.enterprise.deployment.web.ServletFilter;
import com.sun.enterprise.deployment.web.ServletFilterMapping;
import com.sun.enterprise.deployment.web.SessionConfig;
import com.sun.enterprise.deployment.web.WebResourceCollection;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.DescriptorVisitor;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.security.common.Role;
import org.glassfish.web.deployment.descriptor.AbsoluteOrderingDescriptor;
import org.glassfish.web.deployment.descriptor.AppListenerDescriptorImpl;
import org.glassfish.web.deployment.descriptor.ErrorPageDescriptor;
import org.glassfish.web.deployment.descriptor.JspConfigDescriptorImpl;
import org.glassfish.web.deployment.descriptor.LoginConfigurationImpl;
import org.glassfish.web.deployment.descriptor.MimeMappingDescriptor;
import org.glassfish.web.deployment.descriptor.SecurityConstraintImpl;
import org.glassfish.web.deployment.descriptor.ServletFilterDescriptor;
import org.glassfish.web.deployment.descriptor.ServletFilterMappingDescriptor;
import org.glassfish.web.deployment.descriptor.SessionConfigDescriptor;
import org.glassfish.web.deployment.descriptor.WebComponentDescriptorImpl;
import org.glassfish.web.deployment.runtime.SunWebAppImpl;
import org.glassfish.web.deployment.util.WebBundleTracerVisitor;
import org.glassfish.web.deployment.util.WebBundleValidator;
import org.glassfish.web.deployment.util.WebBundleVisitor;

public class WebBundleDescriptorImpl
extends WebBundleDescriptor {
    private static final String DEPLOYMENT_DESCRIPTOR_DIR = "WEB-INF";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebBundleDescriptor.class);
    private Set<WebComponentDescriptor> webComponentDescriptors;
    private SessionConfig sessionConfig;
    private Set<MimeMapping> mimeMappings;
    private Set<String> welcomeFiles;
    private Set<ErrorPageDescriptor> errorPageDescriptors;
    private Vector<AppListenerDescriptor> appListenerDescriptors;
    private Set<ContextParameter> contextParameters;
    private Set<EjbReference> ejbReferences;
    private Set<ResourceReferenceDescriptor> resourceReferences;
    private Set<ResourceEnvReferenceDescriptor> resourceEnvRefReferences;
    private Set<MessageDestinationReferenceDescriptor> messageDestReferences;
    private Set<ServiceReferenceDescriptor> serviceReferences;
    private Set<LifecycleCallbackDescriptor> postConstructDescs = new HashSet<LifecycleCallbackDescriptor>();
    private Set<LifecycleCallbackDescriptor> preDestroyDescs = new HashSet<LifecycleCallbackDescriptor>();
    private Set<EntityManagerFactoryReferenceDescriptor> entityManagerFactoryReferences = new HashSet<EntityManagerFactoryReferenceDescriptor>();
    private Set<EntityManagerReferenceDescriptor> entityManagerReferences = new HashSet<EntityManagerReferenceDescriptor>();
    private boolean distributable = false;
    private boolean denyUncoveredHttpMethods = false;
    private Set<SecurityRoleDescriptor> securityRoles;
    private Set<SecurityConstraint> securityConstraints;
    private String contextRoot;
    private String requestCharacterEncoding;
    private String responseCharacterEncoding;
    private LoginConfiguration loginConfiguration;
    private Set<EnvironmentEntry> environmentEntries;
    private LocaleEncodingMappingListDescriptor localeEncodingMappingListDesc = null;
    private JspConfigDescriptorImpl jspConfigDescriptor = null;
    private Vector<ServletFilter> servletFilters = null;
    private Vector<ServletFilterMapping> servletFilterMappings = null;
    private AbsoluteOrderingDescriptor absOrdering = null;
    private SunWebApp sunWebApp = null;
    private Map<String, String> extensionProperty = null;
    private Map<String, String> jarName2WebFragNameMap = null;
    private Map<String, String> urlPattern2ServletName = null;
    private List<String> orderedLibs = new ArrayList<String>();
    private boolean showArchivedRealPathEnabled = true;
    private int servletReloadCheckSecs = 1;
    private Set<String> conflictedMimeMappingExtensions = null;

    public WebBundleDescriptor createWebBundleDescriptor() {
        return new WebBundleDescriptorImpl();
    }

    public void addWebBundleDescriptor(WebBundleDescriptor webBundleDescriptor) {
        this.getWelcomeFilesSet().addAll(webBundleDescriptor.getWelcomeFilesSet());
        this.addCommonWebBundleDescriptor(webBundleDescriptor, false);
    }

    public void addDefaultWebBundleDescriptor(WebBundleDescriptor webBundleDescriptor) {
        if (this.getWelcomeFilesSet().size() == 0) {
            this.getWelcomeFilesSet().addAll(webBundleDescriptor.getWelcomeFilesSet());
        }
        if (this.requestCharacterEncoding == null) {
            this.requestCharacterEncoding = webBundleDescriptor.getRequestCharacterEncoding();
        }
        if (this.responseCharacterEncoding == null) {
            this.responseCharacterEncoding = webBundleDescriptor.getResponseCharacterEncoding();
        }
        this.addCommonWebBundleDescriptor(webBundleDescriptor, true);
    }

    private void addCommonWebBundleDescriptor(WebBundleDescriptor wbd, boolean defaultDescriptor) {
        super.addBundleDescriptor((BundleDescriptor)wbd);
        WebBundleDescriptorImpl webBundleDescriptor = (WebBundleDescriptorImpl)wbd;
        for (WebComponentDescriptor webComponentDesc : webBundleDescriptor.getWebComponentDescriptors()) {
            WebComponentDescriptorImpl webComponentDescriptor = new WebComponentDescriptorImpl(webComponentDesc);
            webComponentDescriptor.setWebBundleDescriptor(null);
            ArrayList<String> removeUrlPatterns = null;
            for (String urlPattern : webComponentDescriptor.getUrlPatternsSet()) {
                String servletName = null;
                if (this.urlPattern2ServletName != null) {
                    servletName = this.urlPattern2ServletName.get(urlPattern);
                }
                if (servletName == null || servletName.equals(webComponentDescriptor.getCanonicalName())) continue;
                if (removeUrlPatterns == null) {
                    removeUrlPatterns = new ArrayList<String>();
                }
                removeUrlPatterns.add(urlPattern);
            }
            if (removeUrlPatterns != null) {
                webComponentDescriptor.getUrlPatternsSet().removeAll(removeUrlPatterns);
            }
            this.addWebComponentDescriptor(webComponentDescriptor);
        }
        this.getContextParametersSet().addAll(webBundleDescriptor.getContextParametersSet());
        if (this.conflictedMimeMappingExtensions == null) {
            this.conflictedMimeMappingExtensions = webBundleDescriptor.getConflictedMimeMappingExtensions();
        } else {
            this.conflictedMimeMappingExtensions.addAll(webBundleDescriptor.getConflictedMimeMappingExtensions());
        }
        this.combineMimeMappings(webBundleDescriptor.getMimeMappingsSet());
        for (ErrorPageDescriptor errPageDesc : webBundleDescriptor.getErrorPageDescriptorsSet()) {
            this.addErrorPageDescriptor(errPageDesc);
        }
        this.getAppListeners().addAll(webBundleDescriptor.getAppListeners());
        if (webBundleDescriptor.isDenyUncoveredHttpMethods()) {
            this.setDenyUncoveredHttpMethods(true);
        }
        this.combineSecurityConstraints(this.getSecurityConstraintsSet(), webBundleDescriptor.getSecurityConstraintsSet());
        this.combineServletFilters(webBundleDescriptor);
        this.combineServletFilterMappings(webBundleDescriptor);
        if (this.getLocaleEncodingMappingListDescriptor() == null) {
            this.setLocaleEncodingMappingListDescriptor(webBundleDescriptor.getLocaleEncodingMappingListDescriptor());
        }
        if (webBundleDescriptor.getJspConfigDescriptor() != null) {
            JspConfigDescriptorImpl jspConfigDesc = this.getJspConfigDescriptor();
            if (jspConfigDesc == null) {
                jspConfigDesc = new JspConfigDescriptorImpl();
                this.setJspConfigDescriptor(jspConfigDesc);
            }
            this.jspConfigDescriptor.add(webBundleDescriptor.getJspConfigDescriptor());
        }
        WebServicesDescriptor thisWebServices = this.getWebServices();
        WebServicesDescriptor otherWebServices = webBundleDescriptor.getWebServices();
        for (WebService ws : otherWebServices.getWebServices()) {
            thisWebServices.addWebService(new WebService(ws));
        }
        if (this.getSessionConfig() == null) {
            this.setSessionConfig(webBundleDescriptor.getSessionConfig());
        }
        this.combineLoginConfiguration(webBundleDescriptor);
        if (!defaultDescriptor) {
            boolean otherDistributable = webBundleDescriptor.isDistributable();
            this.setDistributable(this.distributable && otherDistributable);
        }
        this.combinePostConstructDescriptors(webBundleDescriptor);
        this.combinePreDestroyDescriptors(webBundleDescriptor);
        this.addJndiNameEnvironment((JndiNameEnvironment)webBundleDescriptor);
    }

    public void addJndiNameEnvironment(JndiNameEnvironment env) {
        this.combineEnvironmentEntries(env);
        this.combineResourceReferenceDescriptors(env);
        this.combineEjbReferenceDescriptors(env);
        this.combineServiceReferenceDescriptors(env);
        this.combineResourceEnvReferenceDescriptors(env);
        this.combineMessageDestinationReferenceDescriptors(env);
        this.combineEntityManagerReferenceDescriptors(env);
        this.combineEntityManagerFactoryReferenceDescriptors(env);
        this.combineAllResourceDescriptors(env);
    }

    public boolean isEmpty() {
        return this.webComponentDescriptors == null || this.webComponentDescriptors.isEmpty();
    }

    public String getDefaultSpecVersion() {
        return "5.0";
    }

    public Collection getNamedDescriptors() {
        return super.getNamedDescriptorsFrom((JndiNameEnvironment)this);
    }

    public Vector<NamedReferencePair> getNamedReferencePairs() {
        return super.getNamedReferencePairsFrom((JndiNameEnvironment)this);
    }

    public String getContextRoot() {
        if (this.getModuleDescriptor() != null && this.getModuleDescriptor().getContextRoot() != null) {
            return this.getModuleDescriptor().getContextRoot();
        }
        if (this.contextRoot == null) {
            this.contextRoot = "";
        }
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        if (this.getModuleDescriptor() != null) {
            this.getModuleDescriptor().setContextRoot(contextRoot);
        }
        this.contextRoot = contextRoot;
    }

    public String getRequestCharacterEncoding() {
        return this.requestCharacterEncoding;
    }

    public void setRequestCharacterEncoding(String requestCharacterEncoding) {
        this.requestCharacterEncoding = requestCharacterEncoding;
    }

    public String getResponseCharacterEncoding() {
        return this.responseCharacterEncoding;
    }

    public void setResponseCharacterEncoding(String responseCharacterEncoding) {
        this.responseCharacterEncoding = responseCharacterEncoding;
    }

    public Set<WebComponentDescriptor> getWebComponentDescriptors() {
        if (this.webComponentDescriptors == null) {
            this.webComponentDescriptors = new OrderedSet();
        }
        return this.webComponentDescriptors;
    }

    public void addWebComponentDescriptor(WebComponentDescriptor webComponentDescriptor) {
        String name = webComponentDescriptor.getCanonicalName();
        webComponentDescriptor.setWebBundleDescriptor((WebBundleDescriptor)this);
        WebComponentDescriptor resultDesc = this.combineWebComponentDescriptor(webComponentDescriptor);
        for (String up : resultDesc.getUrlPatternsSet()) {
            String oldName = this.getUrlPatternToServletNameMap().put(up, name);
            if (oldName == null || oldName.equals(name)) continue;
            throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionsameurlpattern", "Servlet [{0}] and Servlet [{1}] have the same url pattern: [{2}]", new Object[]{oldName, name, up}));
        }
    }

    protected WebComponentDescriptor combineWebComponentDescriptor(WebComponentDescriptor webComponentDescriptor) {
        WebComponentDescriptor resultDesc = null;
        String name = webComponentDescriptor.getCanonicalName();
        WebComponentDescriptor webCompDesc = this.getWebComponentByCanonicalName(name);
        if (webCompDesc != null) {
            resultDesc = webCompDesc;
            if (!webCompDesc.isConflict(webComponentDescriptor, true)) {
                webCompDesc.add(webComponentDescriptor, false, false);
            }
            String implFile = webCompDesc.getWebComponentImplementation();
            if (resultDesc.isConflict() && (implFile == null || implFile.length() == 0)) {
                throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionconflictwebcompwithoutimpl", "Two or more web fragments define the same Servlet with conflicting implementation class names that are not overridden by the web.xml"));
            }
            if (resultDesc.getConflictedInitParameterNames().size() > 0) {
                throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionconflictwebcompinitparam", "Two or more web fragments define the same Servlet with conflicting init param that are not overridden by the web.xml"));
            }
        } else {
            resultDesc = webComponentDescriptor;
            if (resultDesc.isConflict()) {
                throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionconflictwebcomp", "One or more web fragments define the same Servlet in a conflicting way, and the Servlet is not defined in web.xml"));
            }
            this.getWebComponentDescriptors().add(resultDesc);
        }
        return resultDesc;
    }

    public void removeWebComponentDescriptor(WebComponentDescriptor webComponentDescriptor) {
        webComponentDescriptor.setWebBundleDescriptor(null);
        this.getWebComponentDescriptors().remove(webComponentDescriptor);
        this.resetUrlPatternToServletNameMap();
    }

    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public void setSessionConfig(SessionConfig sessionConfig) {
        this.sessionConfig = sessionConfig;
    }

    public void setSessionConfig(SessionConfigDescriptor sessionConfigDesc) {
        this.sessionConfig = sessionConfigDesc;
    }

    public boolean hasServiceReferenceDescriptors() {
        if (this.serviceReferences == null) {
            return false;
        }
        return this.serviceReferences.size() != 0;
    }

    public Set<ServiceReferenceDescriptor> getServiceReferenceDescriptors() {
        if (this.serviceReferences == null) {
            this.serviceReferences = new OrderedSet();
        }
        return this.serviceReferences;
    }

    public void addServiceReferenceDescriptor(ServiceReferenceDescriptor serviceRef) {
        serviceRef.setBundleDescriptor((BundleDescriptor)this);
        this.getServiceReferenceDescriptors().add(serviceRef);
    }

    public void removeServiceReferenceDescriptor(ServiceReferenceDescriptor serviceRef) {
        serviceRef.setBundleDescriptor(null);
        this.getServiceReferenceDescriptors().remove(serviceRef);
    }

    public ServiceReferenceDescriptor getServiceReferenceByName(String name) {
        ServiceReferenceDescriptor sr = this._getServiceReferenceByName(name);
        if (sr != null) {
            return sr;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionwebapphasnoservicerefbyname", "This web app [{0}] has no service reference by the name of [{1}]", new Object[]{this.getName(), name}));
    }

    protected ServiceReferenceDescriptor _getServiceReferenceByName(String name) {
        for (ServiceReferenceDescriptor srd : this.getServiceReferenceDescriptors()) {
            if (!srd.getName().equals(name)) continue;
            return srd;
        }
        return null;
    }

    protected void combineServiceReferenceDescriptors(JndiNameEnvironment env) {
        for (Object oserviceRef : env.getServiceReferenceDescriptors()) {
            ServiceReferenceDescriptor serviceRef = (ServiceReferenceDescriptor)oserviceRef;
            ServiceReferenceDescriptor sr = this._getServiceReferenceByName(serviceRef.getName());
            if (sr != null) {
                this.combineInjectionTargets((EnvironmentProperty)sr, (EnvironmentProperty)serviceRef);
                continue;
            }
            if (env instanceof WebBundleDescriptor && ((WebBundleDescriptor)env).isConflictServiceReference()) {
                throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionconflictserviceref", "There are more than one service references defined in web fragments with the same name, but not overrided in web.xml"));
            }
            this.addServiceReferenceDescriptor(serviceRef);
        }
    }

    public Set<ResourceEnvReferenceDescriptor> getResourceEnvReferenceDescriptors() {
        if (this.resourceEnvRefReferences == null) {
            this.resourceEnvRefReferences = new OrderedSet();
        }
        return this.resourceEnvRefReferences;
    }

    public void addResourceEnvReferenceDescriptor(ResourceEnvReferenceDescriptor resourceEnvRefReference) {
        this.getResourceEnvReferenceDescriptors().add(resourceEnvRefReference);
    }

    public void removeResourceEnvReferenceDescriptor(ResourceEnvReferenceDescriptor resourceEnvRefReference) {
        this.getResourceEnvReferenceDescriptors().remove(resourceEnvRefReference);
    }

    public ResourceEnvReferenceDescriptor getResourceEnvReferenceByName(String name) {
        ResourceEnvReferenceDescriptor jrd = this._getResourceEnvReferenceByName(name);
        if (jrd != null) {
            return jrd;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionwebapphasnoresourceenvrefbyname", "This web app [{0}] has no resource environment reference by the name of [{1}]", new Object[]{this.getName(), name}));
    }

    protected ResourceEnvReferenceDescriptor _getResourceEnvReferenceByName(String name) {
        for (ResourceEnvReferenceDescriptor jdr : this.getResourceEnvReferenceDescriptors()) {
            if (!jdr.getName().equals(name)) continue;
            return jdr;
        }
        return null;
    }

    protected void combineResourceEnvReferenceDescriptors(JndiNameEnvironment env) {
        for (Object ojdRef : env.getResourceEnvReferenceDescriptors()) {
            ResourceEnvReferenceDescriptor jdRef = (ResourceEnvReferenceDescriptor)ojdRef;
            ResourceEnvReferenceDescriptor jdr = this._getResourceEnvReferenceByName(jdRef.getName());
            if (jdr != null) {
                this.combineInjectionTargets((EnvironmentProperty)jdr, (EnvironmentProperty)jdRef);
                continue;
            }
            if (env instanceof WebBundleDescriptor && ((WebBundleDescriptor)env).isConflictResourceEnvReference()) {
                throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionconflictresourceenvref", "There are more than one resource env references defined in web fragments with the same name, but not overrided in web.xml"));
            }
            this.addResourceEnvReferenceDescriptor(jdRef);
        }
    }

    public Set<MimeMapping> getMimeMappingsSet() {
        if (this.mimeMappings == null) {
            this.mimeMappings = new HashSet<MimeMapping>();
        }
        return this.mimeMappings;
    }

    public void setMimeMappings(Set<MimeMapping> mimeMappings) {
        this.mimeMappings = mimeMappings;
    }

    public Enumeration<MimeMapping> getMimeMappings() {
        return new Vector<MimeMapping>(this.getMimeMappingsSet()).elements();
    }

    public String addMimeMapping(MimeMapping mimeMapping) {
        MimeMapping resultMimeMapping = null;
        for (MimeMapping mm : this.getMimeMappingsSet()) {
            if (!mm.getExtension().equals(mimeMapping.getExtension())) continue;
            resultMimeMapping = mm;
            break;
        }
        if (resultMimeMapping == null) {
            resultMimeMapping = mimeMapping;
            this.getMimeMappingsSet().add(mimeMapping);
        }
        return resultMimeMapping.getMimeType();
    }

    public String addMimeMapping(MimeMappingDescriptor mimeMapping) {
        return this.addMimeMapping((MimeMapping)mimeMapping);
    }

    protected void combineMimeMappings(Set<MimeMapping> mimeMappings) {
        if (this.conflictedMimeMappingExtensions != null) {
            for (MimeMapping mm : this.getMimeMappingsSet()) {
                this.conflictedMimeMappingExtensions.remove(mm.getExtension());
            }
            if (this.conflictedMimeMappingExtensions.size() > 0) {
                throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionconflictMimeMapping", "There are more than one Mime mapping defined in web fragments with the same extension."));
            }
        }
        for (MimeMapping mimeMap : mimeMappings) {
            this.addMimeMapping(mimeMap);
        }
    }

    public Set<String> getConflictedMimeMappingExtensions() {
        if (this.conflictedMimeMappingExtensions == null) {
            this.conflictedMimeMappingExtensions = new HashSet<String>();
        }
        return this.conflictedMimeMappingExtensions;
    }

    public LocaleEncodingMappingListDescriptor getLocaleEncodingMappingListDescriptor() {
        return this.localeEncodingMappingListDesc;
    }

    public void setLocaleEncodingMappingListDescriptor(LocaleEncodingMappingListDescriptor lemListDesc) {
        this.localeEncodingMappingListDesc = lemListDesc;
    }

    public void addLocaleEncodingMappingDescriptor(LocaleEncodingMappingDescriptor lemDesc) {
        if (this.localeEncodingMappingListDesc == null) {
            this.localeEncodingMappingListDesc = new LocaleEncodingMappingListDescriptor();
        }
        this.localeEncodingMappingListDesc.addLocaleEncodingMapping(lemDesc);
    }

    public void removeMimeMapping(MimeMapping mimeMapping) {
        this.getMimeMappingsSet().remove(mimeMapping);
    }

    public Enumeration<String> getWelcomeFiles() {
        return new Vector<String>(this.getWelcomeFilesSet()).elements();
    }

    public Set<String> getWelcomeFilesSet() {
        if (this.welcomeFiles == null) {
            this.welcomeFiles = new OrderedSet();
        }
        return this.welcomeFiles;
    }

    public void addWelcomeFile(String fileUri) {
        this.getWelcomeFilesSet().add(fileUri);
    }

    public void removeWelcomeFile(String fileUri) {
        this.getWelcomeFilesSet().remove(fileUri);
    }

    public void setWelcomeFiles(Set<String> welcomeFiles) {
        this.welcomeFiles = welcomeFiles;
    }

    public Set<ErrorPageDescriptor> getErrorPageDescriptorsSet() {
        if (this.errorPageDescriptors == null) {
            this.errorPageDescriptors = new HashSet<ErrorPageDescriptor>();
        }
        return this.errorPageDescriptors;
    }

    public Enumeration<ErrorPageDescriptor> getErrorPageDescriptors() {
        return new Vector<ErrorPageDescriptor>(this.getErrorPageDescriptorsSet()).elements();
    }

    public void addErrorPageDescriptor(ErrorPageDescriptor errorPageDescriptor) {
        String errorSignifier = errorPageDescriptor.getErrorSignifierAsString();
        ErrorPageDescriptor errPageDesc = this.getErrorPageDescriptorBySignifier(errorSignifier);
        if (errPageDesc == null) {
            this.getErrorPageDescriptorsSet().add(errorPageDescriptor);
        }
    }

    public void removeErrorPageDescriptor(ErrorPageDescriptor errorPageDescriptor) {
        this.getErrorPageDescriptorsSet().remove(errorPageDescriptor);
    }

    public ErrorPageDescriptor getErrorPageDescriptorBySignifier(String signifier) {
        for (ErrorPageDescriptor next : this.getErrorPageDescriptorsSet()) {
            if (!next.getErrorSignifierAsString().equals(signifier)) continue;
            return next;
        }
        return null;
    }

    public Set<ContextParameter> getContextParametersSet() {
        if (this.contextParameters == null) {
            this.contextParameters = new OrderedSet();
        }
        return this.contextParameters;
    }

    public Enumeration<ContextParameter> getContextParameters() {
        return new Vector<ContextParameter>(this.getContextParametersSet()).elements();
    }

    public void addContextParameter(ContextParameter contextParameter) {
        this.getContextParametersSet().add(contextParameter);
    }

    public void addContextParameter(EnvironmentProperty contextParameter) {
        this.addContextParameter((ContextParameter)contextParameter);
    }

    public void removeContextParameter(ContextParameter contextParameter) {
        this.getContextParametersSet().remove(contextParameter);
    }

    public boolean isDistributable() {
        return this.distributable;
    }

    public void setDistributable(boolean distributable) {
        this.distributable = distributable;
    }

    public Enumeration<EjbReference> getEjbReferences() {
        return new Vector<EjbReference>(this.getEjbReferenceDescriptors()).elements();
    }

    public Set<EjbReference> getEjbReferenceDescriptors() {
        if (this.ejbReferences == null) {
            this.ejbReferences = new OrderedSet();
        }
        return this.ejbReferences;
    }

    public EjbReferenceDescriptor getEjbReferenceByName(String name) {
        return (EjbReferenceDescriptor)this.getEjbReference(name);
    }

    public EjbReference getEjbReference(String name) {
        EjbReference er = this._getEjbReference(name);
        if (er != null) {
            return er;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionwebapphasnoejbrefbyname", "This web app [{0}] has no ejb reference by the name of [{1}] ", new Object[]{this.getName(), name}));
    }

    protected EjbReference _getEjbReference(String name) {
        for (EjbReference er : this.getEjbReferenceDescriptors()) {
            if (!er.getName().equals(name)) continue;
            return er;
        }
        return null;
    }

    public ResourceReferenceDescriptor getResourceReferenceByName(String name) {
        ResourceReferenceDescriptor rrd = this._getResourceReferenceByName(name);
        if (rrd != null) {
            return rrd;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionwebapphasnoresourcerefbyname", "This web app [{0}] has no resource reference by the name of [{1}]", new Object[]{this.getName(), name}));
    }

    protected ResourceReferenceDescriptor _getResourceReferenceByName(String name) {
        for (ResourceReference resourceReference : this.getResourceReferenceDescriptors()) {
            if (!resourceReference.getName().equals(name)) continue;
            return (ResourceReferenceDescriptor)resourceReference;
        }
        return null;
    }

    public Set<ResourceReferenceDescriptor> getResourceReferenceDescriptors() {
        if (this.resourceReferences == null) {
            this.resourceReferences = new OrderedSet();
        }
        return this.resourceReferences;
    }

    public Set<EntityManagerFactoryReferenceDescriptor> getEntityManagerFactoryReferenceDescriptors() {
        return this.entityManagerFactoryReferences;
    }

    public EntityManagerFactoryReferenceDescriptor getEntityManagerFactoryReferenceByName(String name) {
        EntityManagerFactoryReferenceDescriptor emfr = this._getEntityManagerFactoryReferenceByName(name);
        if (emfr != null) {
            return emfr;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionwebapphasnoentitymgrfactoryrefbyname", "This web app [{0}] has no entity manager factory reference by the name of [{1}]", new Object[]{this.getName(), name}));
    }

    protected EntityManagerFactoryReferenceDescriptor _getEntityManagerFactoryReferenceByName(String name) {
        for (EntityManagerFactoryReferenceDescriptor next : this.getEntityManagerFactoryReferenceDescriptors()) {
            if (!next.getName().equals(name)) continue;
            return next;
        }
        return null;
    }

    public void addEntityManagerFactoryReferenceDescriptor(EntityManagerFactoryReferenceDescriptor reference) {
        reference.setReferringBundleDescriptor((BundleDescriptor)this);
        this.getEntityManagerFactoryReferenceDescriptors().add(reference);
    }

    protected void combineEntityManagerFactoryReferenceDescriptors(JndiNameEnvironment env) {
        for (EntityManagerFactoryReferenceDescriptor emfRef : env.getEntityManagerFactoryReferenceDescriptors()) {
            EntityManagerFactoryReferenceDescriptor emfr = this._getEntityManagerFactoryReferenceByName(emfRef.getName());
            if (emfr != null) {
                this.combineInjectionTargets((EnvironmentProperty)emfr, (EnvironmentProperty)emfRef);
                continue;
            }
            if (env instanceof WebBundleDescriptor && ((WebBundleDescriptor)env).isConflictEntityManagerFactoryReference()) {
                throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionconflictpersistenceunitref", "There are more than one persistence unit references defined in web fragments with the same name, but not overrided in web.xml"));
            }
            this.addEntityManagerFactoryReferenceDescriptor(emfRef);
        }
    }

    public Set<EntityManagerReferenceDescriptor> getEntityManagerReferenceDescriptors() {
        return this.entityManagerReferences;
    }

    public EntityManagerReferenceDescriptor getEntityManagerReferenceByName(String name) {
        EntityManagerReferenceDescriptor emr = this._getEntityManagerReferenceByName(name);
        if (emr != null) {
            return emr;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionwebapphasnoentitymgrrefbyname", "This web app [{0}] has no entity manager reference by the name of [{1}]", new Object[]{this.getName(), name}));
    }

    protected EntityManagerReferenceDescriptor _getEntityManagerReferenceByName(String name) {
        for (EntityManagerReferenceDescriptor next : this.getEntityManagerReferenceDescriptors()) {
            if (!next.getName().equals(name)) continue;
            return next;
        }
        return null;
    }

    public void addEntityManagerReferenceDescriptor(EntityManagerReferenceDescriptor reference) {
        reference.setReferringBundleDescriptor((BundleDescriptor)this);
        this.getEntityManagerReferenceDescriptors().add(reference);
    }

    protected void combineEntityManagerReferenceDescriptors(JndiNameEnvironment env) {
        for (EntityManagerReferenceDescriptor emRef : env.getEntityManagerReferenceDescriptors()) {
            EntityManagerReferenceDescriptor emr = this._getEntityManagerReferenceByName(emRef.getName());
            if (emr != null) {
                this.combineInjectionTargets((EnvironmentProperty)emr, (EnvironmentProperty)emRef);
                continue;
            }
            if (env instanceof WebBundleDescriptor && ((WebBundleDescriptor)env).isConflictEntityManagerReference()) {
                throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionconflictpersistencecontextref", "There are more than one persistence context references defined in web fragments with the same name, but not overrided in web.xml"));
            }
            this.addEntityManagerReferenceDescriptor(emRef);
        }
    }

    public Collection<? extends PersistenceUnitDescriptor> findReferencedPUs() {
        HashSet pus = new HashSet(WebBundleDescriptorImpl.findReferencedPUsViaPURefs((JndiNameEnvironment)this));
        pus.addAll(WebBundleDescriptorImpl.findReferencedPUsViaPCRefs((JndiNameEnvironment)this));
        if (this.extensions.containsKey(EjbBundleDescriptor.class)) {
            for (RootDeploymentDescriptor extension : (List)this.extensions.get(EjbBundleDescriptor.class)) {
                pus.addAll(((EjbBundleDescriptor)extension).findReferencedPUs());
            }
        }
        return pus;
    }

    public Set<EnvironmentEntry> getEnvironmentProperties() {
        return this.getEnvironmentEntrySet();
    }

    public void addEjbReferenceDescriptor(EjbReference ejbReference) {
        if (this.getEjbReferenceDescriptors().add(ejbReference)) {
            ejbReference.setReferringBundleDescriptor((BundleDescriptor)this);
        }
    }

    public void addEjbReferenceDescriptor(EjbReferenceDescriptor ejbReferenceDescriptor) {
        this.addEjbReferenceDescriptor((EjbReference)ejbReferenceDescriptor);
    }

    public void removeEjbReferenceDescriptor(EjbReferenceDescriptor ejbReferenceDescriptor) {
        this.removeEjbReferenceDescriptor((EjbReference)ejbReferenceDescriptor);
    }

    public void removeEjbReferenceDescriptor(EjbReference ejbReferenceDescriptor) {
        if (this.getEjbReferenceDescriptors().remove(ejbReferenceDescriptor)) {
            ejbReferenceDescriptor.setReferringBundleDescriptor(null);
        }
    }

    protected void combineEjbReferenceDescriptors(JndiNameEnvironment env) {
        for (Object oejbRef : env.getEjbReferenceDescriptors()) {
            EjbReference ejbRef = (EjbReference)oejbRef;
            EjbReferenceDescriptor ejbRefDesc = (EjbReferenceDescriptor)this._getEjbReference(ejbRef.getName());
            if (ejbRefDesc != null) {
                this.combineInjectionTargets((EnvironmentProperty)ejbRefDesc, (EnvironmentProperty)ejbRef);
                continue;
            }
            if (env instanceof WebBundleDescriptor && ((WebBundleDescriptor)env).isConflictEjbReference()) {
                throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionconflictejbref", "There are more than one ejb references defined in web fragments with the same name, but not overrided in web.xml"));
            }
            this.addEjbReferenceDescriptor(ejbRef);
        }
    }

    public Enumeration<ResourceReferenceDescriptor> getResourceReferences() {
        return new Vector<ResourceReferenceDescriptor>(this.getResourceReferenceDescriptors()).elements();
    }

    public void addResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        this.getResourceReferenceDescriptors().add(resourceReference);
    }

    public void removeResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        this.getResourceReferenceDescriptors().remove(resourceReference);
    }

    protected void combineResourceReferenceDescriptors(JndiNameEnvironment env) {
        for (Object oresRef : env.getResourceReferenceDescriptors()) {
            ResourceReferenceDescriptor resRef = (ResourceReferenceDescriptor)oresRef;
            ResourceReferenceDescriptor rrd = this._getResourceReferenceByName(resRef.getName());
            if (rrd != null) {
                this.combineInjectionTargets((EnvironmentProperty)rrd, (EnvironmentProperty)resRef);
                continue;
            }
            if (env instanceof WebBundleDescriptor && ((WebBundleDescriptor)env).isConflictResourceReference()) {
                throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionconflictresourceref", "There are more than one resource references defined in web fragments with the same name, but not overrided in web.xml"));
            }
            this.addResourceReferenceDescriptor(resRef);
        }
    }

    public Set<MessageDestinationReferenceDescriptor> getMessageDestinationReferenceDescriptors() {
        if (this.messageDestReferences == null) {
            this.messageDestReferences = new OrderedSet();
        }
        return this.messageDestReferences;
    }

    public void addMessageDestinationReferenceDescriptor(MessageDestinationReferenceDescriptor messageDestRef) {
        messageDestRef.setReferringBundleDescriptor((BundleDescriptor)this);
        this.getMessageDestinationReferenceDescriptors().add(messageDestRef);
    }

    public void removeMessageDestinationReferenceDescriptor(MessageDestinationReferenceDescriptor msgDestRef) {
        this.getMessageDestinationReferenceDescriptors().remove(msgDestRef);
    }

    public MessageDestinationReferenceDescriptor getMessageDestinationReferenceByName(String name) {
        MessageDestinationReferenceDescriptor mdr = this._getMessageDestinationReferenceByName(name);
        if (mdr != null) {
            return mdr;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionwebapphasnomsgdestrefbyname", "This web app [{0}] has no message destination reference by the name of [{1}]", new Object[]{this.getName(), name}));
    }

    protected MessageDestinationReferenceDescriptor _getMessageDestinationReferenceByName(String name) {
        for (MessageDestinationReferenceDescriptor mdr : this.getMessageDestinationReferenceDescriptors()) {
            if (!mdr.getName().equals(name)) continue;
            return mdr;
        }
        return null;
    }

    protected void combineMessageDestinationReferenceDescriptors(JndiNameEnvironment env) {
        for (Object omdRef : env.getMessageDestinationReferenceDescriptors()) {
            MessageDestinationReferenceDescriptor mdRef = (MessageDestinationReferenceDescriptor)omdRef;
            MessageDestinationReferenceDescriptor mdr = this._getMessageDestinationReferenceByName(mdRef.getName());
            if (mdr != null) {
                this.combineInjectionTargets((EnvironmentProperty)mdr, (EnvironmentProperty)mdRef);
                continue;
            }
            if (env instanceof WebBundleDescriptor && ((WebBundleDescriptor)env).isConflictMessageDestinationReference()) {
                throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionconflictmessagedestinationref", "There are more than one message destination references defined in web fragments with the same name, but not overrided in web.xml"));
            }
            this.addMessageDestinationReferenceDescriptor(mdRef);
        }
    }

    public Set<LifecycleCallbackDescriptor> getPostConstructDescriptors() {
        return this.postConstructDescs;
    }

    public void addPostConstructDescriptor(LifecycleCallbackDescriptor postConstructDesc) {
        String className = postConstructDesc.getLifecycleCallbackClass();
        boolean found = false;
        for (LifecycleCallbackDescriptor next : this.getPostConstructDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.getPostConstructDescriptors().add(postConstructDesc);
        }
    }

    public LifecycleCallbackDescriptor getPostConstructDescriptorByClass(String className) {
        return this.getPostConstructDescriptorByClass(className, (JndiNameEnvironment)this);
    }

    protected void combinePostConstructDescriptors(WebBundleDescriptor webBundleDescriptor) {
        LifecycleCallbackDescriptor lccd;
        boolean isFromXml = false;
        Iterator<LifecycleCallbackDescriptor> iterator = this.getPostConstructDescriptors().iterator();
        while (iterator.hasNext() && !(isFromXml = (lccd = iterator.next()).getMetadataSource() == MetadataSource.XML)) {
        }
        if (!isFromXml) {
            this.getPostConstructDescriptors().addAll(webBundleDescriptor.getPostConstructDescriptors());
        }
    }

    public Set<LifecycleCallbackDescriptor> getPreDestroyDescriptors() {
        return this.preDestroyDescs;
    }

    public void addPreDestroyDescriptor(LifecycleCallbackDescriptor preDestroyDesc) {
        String className = preDestroyDesc.getLifecycleCallbackClass();
        boolean found = false;
        for (LifecycleCallbackDescriptor next : this.getPreDestroyDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.getPreDestroyDescriptors().add(preDestroyDesc);
        }
    }

    public LifecycleCallbackDescriptor getPreDestroyDescriptorByClass(String className) {
        return this.getPreDestroyDescriptorByClass(className, (JndiNameEnvironment)this);
    }

    protected void combinePreDestroyDescriptors(WebBundleDescriptor webBundleDescriptor) {
        LifecycleCallbackDescriptor lccd;
        boolean isFromXml = false;
        Iterator<LifecycleCallbackDescriptor> iterator = this.getPreDestroyDescriptors().iterator();
        while (iterator.hasNext() && !(isFromXml = (lccd = iterator.next()).getMetadataSource() == MetadataSource.XML)) {
        }
        if (!isFromXml) {
            this.getPreDestroyDescriptors().addAll(webBundleDescriptor.getPreDestroyDescriptors());
        }
    }

    protected List<InjectionCapable> getInjectableResourcesByClass(String className, JndiNameEnvironment jndiNameEnv) {
        LinkedList<InjectionCapable> injectables = new LinkedList<InjectionCapable>();
        for (InjectionCapable next : this.getInjectableResources(jndiNameEnv)) {
            if (!next.isInjectable()) continue;
            for (InjectionTarget target : next.getInjectionTargets()) {
                if (!target.getClassName().equals(className)) continue;
                injectables.add(next);
            }
        }
        if (((WebBundleDescriptor)jndiNameEnv).hasWebServices()) {
            for (InjectionCapable next : this.getInjectableResources((JndiNameEnvironment)this)) {
                if (!next.isInjectable()) continue;
                for (InjectionTarget target : next.getInjectionTargets()) {
                    Iterator epIter = this.getWebServices().getEndpoints().iterator();
                    while (epIter.hasNext()) {
                        String servletImplClass = ((WebServiceEndpoint)epIter.next()).getServletImplClass();
                        if (!target.getClassName().equals(servletImplClass)) continue;
                        injectables.add(next);
                    }
                }
            }
        }
        return injectables;
    }

    public List<InjectionCapable> getInjectableResourcesByClass(String className) {
        return this.getInjectableResourcesByClass(className, (JndiNameEnvironment)this);
    }

    public InjectionInfo getInjectionInfoByClass(Class clazz) {
        return this.getInjectionInfoByClass(clazz, (JndiNameEnvironment)this);
    }

    public Enumeration<SecurityRoleDescriptor> getSecurityRoles() {
        Vector<SecurityRoleDescriptor> securityRoles = new Vector<SecurityRoleDescriptor>();
        for (Role r : super.getRoles()) {
            SecurityRoleDescriptor srd = new SecurityRoleDescriptor(r);
            securityRoles.add(srd);
        }
        return securityRoles.elements();
    }

    public void addSecurityRole(SecurityRole securityRole) {
        Role r = new Role(securityRole.getName());
        r.setDescription(securityRole.getDescription());
        super.addRole(r);
    }

    public void addSecurityRole(SecurityRoleDescriptor securityRole) {
        this.addSecurityRole((SecurityRole)securityRole);
    }

    public SecurityRoleReference getSecurityRoleReferenceByName(String compName, String roleName) {
        for (WebComponentDescriptor comp : this.getWebComponentDescriptors()) {
            SecurityRoleReference r;
            if (!comp.getCanonicalName().equals(compName) || (r = comp.getSecurityRoleReferenceByName(roleName)) == null) continue;
            return r;
        }
        return null;
    }

    protected void combineSecurityConstraints(Set<SecurityConstraint> firstScSet, Set<SecurityConstraint> secondScSet) {
        HashSet allUrlPatterns = new HashSet();
        for (SecurityConstraint sc : firstScSet) {
            for (WebResourceCollection wrc : sc.getWebResourceCollections()) {
                allUrlPatterns.addAll(wrc.getUrlPatterns());
            }
        }
        for (SecurityConstraint sc : secondScSet) {
            SecurityConstraintImpl newSc = new SecurityConstraintImpl((SecurityConstraintImpl)sc);
            boolean addSc = false;
            Iterator iter = newSc.getWebResourceCollections().iterator();
            while (iter.hasNext()) {
                WebResourceCollection wrc = (WebResourceCollection)iter.next();
                Set urlPatterns = wrc.getUrlPatterns();
                urlPatterns.removeAll(allUrlPatterns);
                boolean isEmpty = urlPatterns.size() == 0;
                boolean bl = addSc = addSc || !isEmpty;
                if (!isEmpty) continue;
                iter.remove();
            }
            if (!addSc) continue;
            firstScSet.add(newSc);
        }
    }

    public Set<SecurityConstraint> getSecurityConstraintsSet() {
        if (this.securityConstraints == null) {
            this.securityConstraints = new HashSet<SecurityConstraint>();
        }
        return this.securityConstraints;
    }

    public Enumeration<SecurityConstraint> getSecurityConstraints() {
        return new Vector<SecurityConstraint>(this.getSecurityConstraintsSet()).elements();
    }

    public Collection<SecurityConstraint> getSecurityConstraintsForUrlPattern(String urlPattern) {
        HashSet<SecurityConstraint> constraints = new HashSet<SecurityConstraint>();
        for (SecurityConstraint next : this.getSecurityConstraintsSet()) {
            boolean include = false;
            for (WebResourceCollection nextCol : next.getWebResourceCollections()) {
                for (String nextPattern : nextCol.getUrlPatterns()) {
                    if (urlPattern == null || !urlPattern.equals(nextPattern)) continue;
                    include = true;
                    break;
                }
                if (!include) continue;
                break;
            }
            if (!include) continue;
            constraints.add(next);
        }
        return constraints;
    }

    public void addSecurityConstraint(SecurityConstraint securityConstraint) {
        this.getSecurityConstraintsSet().add(securityConstraint);
    }

    public void addSecurityConstraint(SecurityConstraintImpl securityConstraint) {
        this.addSecurityConstraint((SecurityConstraint)securityConstraint);
    }

    public void removeSecurityConstraint(SecurityConstraint securityConstraint) {
        this.getSecurityConstraintsSet().remove(securityConstraint);
    }

    public JspConfigDescriptorImpl getJspConfigDescriptor() {
        return this.jspConfigDescriptor;
    }

    public void setJspConfigDescriptor(JspConfigDescriptorImpl jspC) {
        this.jspConfigDescriptor = jspC;
    }

    public Set<WebComponentDescriptor> getServletDescriptors() {
        HashSet<WebComponentDescriptor> servletDescriptors = new HashSet<WebComponentDescriptor>();
        for (WebComponentDescriptor next : this.getWebComponentDescriptors()) {
            if (!next.isServlet()) continue;
            servletDescriptors.add(next);
        }
        return servletDescriptors;
    }

    public Set<WebComponentDescriptor> getJspDescriptors() {
        HashSet<WebComponentDescriptor> jspDescriptors = new HashSet<WebComponentDescriptor>();
        for (WebComponentDescriptor next : this.getWebComponentDescriptors()) {
            if (next.isServlet()) continue;
            jspDescriptors.add(next);
        }
        return jspDescriptors;
    }

    public Set<EnvironmentEntry> getEnvironmentEntrySet() {
        if (this.environmentEntries == null) {
            this.environmentEntries = new OrderedSet();
        }
        return this.environmentEntries;
    }

    public Enumeration<EnvironmentEntry> getEnvironmentEntries() {
        return new Vector<EnvironmentEntry>(this.getEnvironmentEntrySet()).elements();
    }

    public void addEnvironmentEntry(EnvironmentEntry environmentEntry) {
        this.getEnvironmentEntrySet().add(environmentEntry);
    }

    protected EnvironmentProperty _getEnvironmentPropertyByName(String name) {
        for (EnvironmentEntry ev : this.getEnvironmentEntrySet()) {
            if (!ev.getName().equals(name)) continue;
            return (EnvironmentProperty)ev;
        }
        return null;
    }

    public EnvironmentProperty getEnvironmentPropertyByName(String name) {
        EnvironmentProperty envProp = this._getEnvironmentPropertyByName(name);
        if (envProp != null) {
            return envProp;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionwebapphasnoenvpropertybyname", "This web app [{0}] has no environment property by the name of [{1}]", new Object[]{this.getName(), name}));
    }

    public void removeEnvironmentProperty(EnvironmentProperty environmentProperty) {
        this.getEnvironmentEntrySet().remove(environmentProperty);
    }

    public void addEnvironmentProperty(EnvironmentProperty environmentProperty) {
        this.getEnvironmentEntrySet().add((EnvironmentEntry)environmentProperty);
    }

    public void removeEnvironmentEntry(EnvironmentEntry environmentEntry) {
        this.getEnvironmentEntrySet().remove(environmentEntry);
    }

    protected void combineEnvironmentEntries(JndiNameEnvironment env) {
        for (Object oenve : env.getEnvironmentProperties()) {
            EnvironmentEntry enve = (EnvironmentEntry)oenve;
            EnvironmentProperty envProp = this._getEnvironmentPropertyByName(enve.getName());
            if (envProp != null) {
                this.combineInjectionTargets(envProp, (EnvironmentProperty)enve);
                EnvironmentProperty envP = (EnvironmentProperty)enve;
                if (envProp.hasInjectionTargetFromXml() || envProp.isSetValueCalled() || !envP.isSetValueCalled()) continue;
                envProp.setValue(enve.getValue());
                continue;
            }
            if (env instanceof WebBundleDescriptor && ((WebBundleDescriptor)env).isConflictEnvironmentEntry()) {
                throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionconflictenventry", "There are more than one environment entries defined in web fragments with the same name, but not overrided in web.xml"));
            }
            this.addEnvironmentEntry(enve);
        }
    }

    public LoginConfiguration getLoginConfiguration() {
        return this.loginConfiguration;
    }

    public void setLoginConfiguration(LoginConfiguration loginConfiguration) {
        this.loginConfiguration = loginConfiguration;
    }

    public void setLoginConfiguration(LoginConfigurationImpl loginConfiguration) {
        this.setLoginConfiguration((LoginConfiguration)loginConfiguration);
    }

    protected void combineLoginConfiguration(WebBundleDescriptor webBundleDescriptor) {
        if (this.getLoginConfiguration() == null) {
            if (webBundleDescriptor.isConflictLoginConfig()) {
                throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionconflictloginconfig", "There are more than one login-config defined in web fragments with different values"));
            }
            this.setLoginConfiguration(webBundleDescriptor.getLoginConfiguration());
        }
    }

    public WebComponentDescriptor getWebComponentByName(String name) {
        for (WebComponentDescriptor next : this.getWebComponentDescriptors()) {
            if (!next.getName().equals(name)) continue;
            return next;
        }
        return null;
    }

    public WebComponentDescriptor getWebComponentByCanonicalName(String name) {
        for (WebComponentDescriptor next : this.getWebComponentDescriptors()) {
            if (!next.getCanonicalName().equals(name)) continue;
            return next;
        }
        return null;
    }

    public WebComponentDescriptor[] getWebComponentByImplName(String name) {
        ArrayList<WebComponentDescriptor> webCompList = new ArrayList<WebComponentDescriptor>();
        for (WebComponentDescriptor webComp : this.getWebComponentDescriptors()) {
            if (!webComp.getWebComponentImplementation().equals(name)) continue;
            webCompList.add(webComp);
        }
        return webCompList.toArray(new WebComponentDescriptor[webCompList.size()]);
    }

    public Vector<ServletFilter> getServletFilters() {
        if (this.servletFilters == null) {
            this.servletFilters = new Vector();
        }
        return this.servletFilters;
    }

    public Vector<ServletFilter> getServletFilterDescriptors() {
        return (Vector)this.getServletFilters().clone();
    }

    public void addServletFilter(ServletFilter ref) {
        String name = ref.getName();
        boolean found = false;
        for (ServletFilter servletFilter : this.getServletFilters()) {
            if (!name.equals(servletFilter.getName())) continue;
            found = true;
            break;
        }
        if (!found) {
            this.getServletFilters().addElement(ref);
        }
    }

    public void addServletFilter(ServletFilterDescriptor ref) {
        this.addServletFilter((ServletFilter)ref);
    }

    public void removeServletFilter(ServletFilter ref) {
        this.removeVectorItem(this.getServletFilters(), ref);
    }

    protected void combineServletFilters(WebBundleDescriptor webBundleDescriptor) {
        for (ServletFilter servletFilter : webBundleDescriptor.getServletFilters()) {
            ServletFilterDescriptor servletFilterDesc = (ServletFilterDescriptor)servletFilter;
            String name = servletFilter.getName();
            ServletFilterDescriptor aServletFilterDesc = null;
            for (ServletFilter sf : this.getServletFilters()) {
                if (!name.equals(sf.getName())) continue;
                aServletFilterDesc = (ServletFilterDescriptor)sf;
                break;
            }
            if (aServletFilterDesc != null) {
                if (!aServletFilterDesc.isConflict(servletFilterDesc)) {
                    if (aServletFilterDesc.getClassName().length() == 0) {
                        aServletFilterDesc.setClassName(servletFilter.getClassName());
                    }
                    if (aServletFilterDesc.isAsyncSupported() == null) {
                        aServletFilterDesc.setAsyncSupported(servletFilter.isAsyncSupported());
                    }
                }
                String className = aServletFilterDesc.getClassName();
                if (!servletFilterDesc.isConflict() || className != null && className.length() != 0) continue;
                throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionconflictfilterwithoutimpl", "Two or more web fragments define the same Filter with conflicting implementation class names that are not overridden by the web.xml"));
            }
            if (servletFilterDesc.isConflict()) {
                throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionconflictfilter", "One or more web fragments define the same Filter in a conflicting way, and the Filter is not defined in web.xml"));
            }
            this.getServletFilters().add(servletFilterDesc);
        }
    }

    public Vector<ServletFilterMapping> getServletFilterMappings() {
        if (this.servletFilterMappings == null) {
            this.servletFilterMappings = new Vector();
        }
        return this.servletFilterMappings;
    }

    public Vector<ServletFilterMapping> getServletFilterMappingDescriptors() {
        return (Vector)this.getServletFilterMappings().clone();
    }

    public void addServletFilterMapping(ServletFilterMapping ref) {
        if (!this.getServletFilterMappings().contains(ref)) {
            this.getServletFilterMappings().addElement(ref);
        }
    }

    public void addServletFilterMapping(ServletFilterMappingDescriptor ref) {
        this.addServletFilterMapping((ServletFilterMapping)ref);
    }

    public void removeServletFilterMapping(ServletFilterMapping ref) {
        this.removeVectorItem(this.getServletFilterMappings(), ref);
    }

    public void moveServletFilterMapping(ServletFilterMapping ref, int relPos) {
        this.moveVectorItem(this.getServletFilterMappings(), ref, relPos);
    }

    protected void combineServletFilterMappings(WebBundleDescriptor webBundleDescriptor) {
        ServletFilterMappingInfo sfmInfo;
        HashMap<String, ServletFilterMappingInfo> map = new HashMap<String, ServletFilterMappingInfo>();
        for (ServletFilterMapping sfMapping : this.getServletFilterMappings()) {
            sfmInfo = (ServletFilterMappingInfo)map.get(sfMapping.getName());
            if (sfmInfo == null) {
                sfmInfo = new ServletFilterMappingInfo();
                sfmInfo.servletFilterMapping = sfMapping;
                map.put(sfMapping.getName(), sfmInfo);
            }
            if (!sfmInfo.hasMapping) {
                boolean bl = sfmInfo.hasMapping = sfMapping.getServletNames().size() > 0 || sfMapping.getUrlPatterns().size() > 0;
            }
            if (sfmInfo.hasDispatcher) continue;
            sfmInfo.hasDispatcher = sfMapping.getDispatchers().size() > 0;
        }
        for (ServletFilterMapping sfMapping : webBundleDescriptor.getServletFilterMappings()) {
            sfmInfo = (ServletFilterMappingInfo)map.get(sfMapping.getName());
            if (sfmInfo != null) {
                if (!sfmInfo.hasMapping) {
                    sfmInfo.servletFilterMapping.getServletNames().addAll(sfMapping.getServletNames());
                    sfmInfo.servletFilterMapping.getUrlPatterns().addAll(sfMapping.getUrlPatterns());
                }
                if (sfmInfo.hasDispatcher) continue;
                sfmInfo.servletFilterMapping.getDispatchers().addAll(sfMapping.getDispatchers());
                continue;
            }
            this.addServletFilterMapping(sfMapping);
        }
    }

    public Vector<AppListenerDescriptor> getAppListeners() {
        if (this.appListenerDescriptors == null) {
            this.appListenerDescriptors = new Vector();
        }
        return this.appListenerDescriptors;
    }

    public Vector<AppListenerDescriptor> getAppListenerDescriptors() {
        return (Vector)this.getAppListeners().clone();
    }

    public void setAppListeners(Collection<? extends AppListenerDescriptor> c) {
        this.getAppListeners().clear();
        this.getAppListeners().addAll(c);
    }

    public void addAppListenerDescriptor(AppListenerDescriptor ref) {
        if (!this.getAppListeners().contains(ref)) {
            this.getAppListeners().addElement(ref);
        }
    }

    public void addAppListenerDescriptorToFirst(AppListenerDescriptor ref) {
        if (!this.getAppListeners().contains(ref)) {
            this.getAppListeners().add(0, ref);
        }
    }

    public void addAppListenerDescriptor(AppListenerDescriptorImpl ref) {
        this.addAppListenerDescriptor((AppListenerDescriptor)ref);
    }

    public void removeAppListenerDescriptor(AppListenerDescriptor ref) {
        this.removeVectorItem(this.getAppListeners(), ref);
    }

    public void moveAppListenerDescriptor(AppListenerDescriptor ref, int relPos) {
        this.moveVectorItem(this.getAppListeners(), ref, relPos);
    }

    public AbsoluteOrderingDescriptor getAbsoluteOrderingDescriptor() {
        return this.absOrdering;
    }

    public void setAbsoluteOrderingDescriptor(AbsoluteOrderingDescriptor absOrdering) {
        this.absOrdering = absOrdering;
    }

    public boolean isDenyUncoveredHttpMethods() {
        return this.denyUncoveredHttpMethods;
    }

    public void setDenyUncoveredHttpMethods(boolean denyUncoveredHttpMethods) {
        this.denyUncoveredHttpMethods = denyUncoveredHttpMethods;
    }

    public boolean isShowArchivedRealPathEnabled() {
        return this.showArchivedRealPathEnabled;
    }

    public void setShowArchivedRealPathEnabled(boolean enabled) {
        this.showArchivedRealPathEnabled = enabled;
    }

    public int getServletReloadCheckSecs() {
        return this.servletReloadCheckSecs;
    }

    public void setServletReloadCheckSecs(int secs) {
        this.servletReloadCheckSecs = secs;
    }

    public boolean hasWebServiceClients() {
        return !this.getServiceReferenceDescriptors().isEmpty();
    }

    protected boolean removeVectorItem(Vector<? extends Object> list, Object ref) {
        Iterator<? extends Object> i = list.iterator();
        while (i.hasNext()) {
            if (ref != i.next()) continue;
            i.remove();
            return true;
        }
        return false;
    }

    protected void moveVectorItem(Vector list, Object ref, int rpos) {
        int old_pos;
        int size = list.size();
        for (old_pos = size - 1; old_pos >= 0 && ref != list.elementAt(old_pos); --old_pos) {
        }
        if (old_pos < 0) {
            return;
        }
        int new_pos = old_pos + rpos;
        if (new_pos < 0) {
            new_pos = 0;
        } else if (new_pos >= size) {
            new_pos = size - 1;
        }
        if (new_pos == old_pos) {
            return;
        }
        list.removeElementAt(old_pos);
        list.insertElementAt(ref, new_pos);
    }

    public void visit(DescriptorVisitor aVisitor) {
        if (aVisitor instanceof WebBundleVisitor || aVisitor instanceof ComponentPostVisitor) {
            this.visit((ComponentVisitor)aVisitor);
        } else {
            super.visit(aVisitor);
        }
    }

    public void visit(ComponentVisitor aVisitor) {
        super.visit(aVisitor);
        aVisitor.accept((BundleDescriptor)this);
    }

    public void putJarNameWebFragmentNamePair(String jarName, String webFragName) {
        if (this.jarName2WebFragNameMap == null) {
            this.jarName2WebFragNameMap = new HashMap<String, String>();
        }
        this.jarName2WebFragNameMap.put(jarName, webFragName);
    }

    public Map<String, String> getJarNameToWebFragmentNameMap() {
        if (this.jarName2WebFragNameMap == null) {
            this.jarName2WebFragNameMap = new HashMap<String, String>();
        }
        return Collections.unmodifiableMap(this.jarName2WebFragNameMap);
    }

    public Map<String, String> getUrlPatternToServletNameMap() {
        if (this.urlPattern2ServletName == null) {
            this.urlPattern2ServletName = new HashMap<String, String>();
            for (WebComponentDescriptor wc : this.getWebComponentDescriptors()) {
                String name = wc.getCanonicalName();
                for (String up : wc.getUrlPatternsSet()) {
                    String oldName = this.urlPattern2ServletName.put(up, name);
                    if (oldName == null || oldName.equals(name)) continue;
                    throw new RuntimeException(localStrings.getLocalString("web.deployment.exceptionsameurlpattern", "Servlet [{0}] and Servlet [{1}] have the same url pattern: [{2}]", new Object[]{oldName, name, up}));
                }
            }
        }
        return this.urlPattern2ServletName;
    }

    public void resetUrlPatternToServletNameMap() {
        this.urlPattern2ServletName = null;
    }

    public List<String> getOrderedLibs() {
        return this.orderedLibs;
    }

    public void addOrderedLib(String libName) {
        this.orderedLibs.add(libName);
    }

    protected void combineInjectionTargets(EnvironmentProperty env1, EnvironmentProperty env2) {
        for (InjectionTarget injTarget : env2.getInjectionTargets()) {
            env1.addInjectionTarget(injTarget);
        }
    }

    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("\nWeb Bundle descriptor");
        toStringBuffer.append("\n");
        this.printCommon(toStringBuffer);
        if (this.sunWebApp != null) {
            toStringBuffer.append("\n ========== Runtime Descriptors =========");
            toStringBuffer.append("\n").append(this.sunWebApp.toString());
        }
    }

    public void printCommon(StringBuffer toStringBuffer) {
        String wname;
        super.print(toStringBuffer);
        toStringBuffer.append("\n context root ").append(this.getContextRoot());
        if (this.sessionConfig != null) {
            toStringBuffer.append(this.sessionConfig);
        }
        if ((wname = this.getName()) != null && wname.length() > 0) {
            toStringBuffer.append("\n name ").append(wname);
        }
        toStringBuffer.append("\n mimeMappings ").append(this.mimeMappings);
        toStringBuffer.append("\n welcomeFiles ").append(this.welcomeFiles);
        toStringBuffer.append("\n errorPageDescriptors ").append(this.errorPageDescriptors);
        toStringBuffer.append("\n appListenerDescriptors ").append(this.appListenerDescriptors);
        toStringBuffer.append("\n contextParameters ").append(this.contextParameters);
        toStringBuffer.append("\n ejbReferences ");
        if (this.ejbReferences != null) {
            this.printDescriptorSet(this.ejbReferences, toStringBuffer);
        }
        toStringBuffer.append("\n resourceEnvRefReferences ");
        if (this.resourceEnvRefReferences != null) {
            this.printDescriptorSet(this.resourceEnvRefReferences, toStringBuffer);
        }
        toStringBuffer.append("\n messageDestReferences ");
        if (this.messageDestReferences != null) {
            this.printDescriptorSet(this.messageDestReferences, toStringBuffer);
        }
        toStringBuffer.append("\n resourceReferences ");
        if (this.resourceReferences != null) {
            this.printDescriptorSet(this.resourceReferences, toStringBuffer);
        }
        toStringBuffer.append("\n serviceReferences ");
        if (this.serviceReferences != null) {
            this.printDescriptorSet(this.serviceReferences, toStringBuffer);
        }
        toStringBuffer.append("\n distributable ").append(this.distributable);
        toStringBuffer.append("\n denyUncoveredHttpMethods ").append(this.denyUncoveredHttpMethods);
        toStringBuffer.append("\n securityRoles ").append(this.securityRoles);
        toStringBuffer.append("\n securityConstraints ").append(this.securityConstraints);
        toStringBuffer.append("\n contextRoot ").append(this.contextRoot);
        toStringBuffer.append("\n loginConfiguration ").append(this.loginConfiguration);
        toStringBuffer.append("\n webComponentDescriptors ");
        if (this.webComponentDescriptors != null) {
            this.printDescriptorSet(this.webComponentDescriptors, toStringBuffer);
        }
        toStringBuffer.append("\n environmentEntries ");
        if (this.environmentEntries != null) {
            this.printDescriptorSet(this.environmentEntries, toStringBuffer);
        }
    }

    private void printDescriptorSet(Set descSet, StringBuffer sbuf) {
        if (descSet == null) {
            return;
        }
        for (Object obj : descSet) {
            if (obj instanceof Descriptor) {
                ((Descriptor)obj).print(sbuf);
                continue;
            }
            sbuf.append(obj);
        }
    }

    public ArchiveType getModuleType() {
        return DOLUtils.warType();
    }

    public ComponentVisitor getBundleVisitor() {
        return new WebBundleValidator();
    }

    public DescriptorVisitor getTracerVisitor() {
        return new WebBundleTracerVisitor();
    }

    public String getDeploymentDescriptorDir() {
        return DEPLOYMENT_DESCRIPTOR_DIR;
    }

    public SunWebApp getSunDescriptor() {
        if (this.sunWebApp == null) {
            this.sunWebApp = new SunWebAppImpl();
        }
        return this.sunWebApp;
    }

    public void setSunDescriptor(SunWebApp webApp) {
        this.sunWebApp = webApp;
    }

    public void setExtensionProperty(String key, String value) {
        if (null == this.extensionProperty) {
            this.extensionProperty = new HashMap<String, String>();
        }
        this.extensionProperty.put(key, value);
    }

    public boolean hasExtensionProperty(String key) {
        return null != this.extensionProperty && this.extensionProperty.get(key) != null;
    }

    private void combineAllResourceDescriptors(JndiNameEnvironment env) {
        for (JavaEEResourceType javaEEResourceType : JavaEEResourceType.values()) {
            this.combineResourceDescriptors(env, javaEEResourceType);
        }
    }

    protected void combineResourceDescriptors(JndiNameEnvironment env, JavaEEResourceType javaEEResourceType) {
        for (ResourceDescriptor desc : env.getResourceDescriptors(javaEEResourceType)) {
            ResourceDescriptor descriptor = this.getResourceDescriptor(javaEEResourceType, desc.getName());
            if (descriptor != null) continue;
            if (env instanceof WebBundleDescriptor) {
                WebBundleDescriptor wbDesc = (WebBundleDescriptor)env;
                if (javaEEResourceType.equals((Object)JavaEEResourceType.AODD) && wbDesc.isConflictAdminObjectDefinition()) {
                    throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionconflictadministeredobjectdefinition", "There are more than one administered object definitions defined in web fragments with the same name, but not overrided in web.xml"));
                }
                if (javaEEResourceType.equals((Object)JavaEEResourceType.MSD) && wbDesc.isConflictMailSessionDefinition()) {
                    throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionconflictmailsessiondefinition", "There are more than one mail-session definitions defined in web fragments with the same name, but not overrided in web.xml"));
                }
                if (javaEEResourceType.equals((Object)JavaEEResourceType.DSD) && wbDesc.isConflictDataSourceDefinition()) {
                    throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionconflictdatasourcedefinition", "There are more than one datasource definitions defined in web fragments with the same name, but not overrided in web.xml"));
                }
                if (javaEEResourceType.equals((Object)JavaEEResourceType.CFD) && wbDesc.isConflictConnectionFactoryDefinition()) {
                    throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionconflictconnectionfactorydefinition", "There are more than one connection factory definitions defined in web fragments with the same name, but not overrided in web.xml"));
                }
                if (javaEEResourceType.equals((Object)JavaEEResourceType.JMSCFDD) && wbDesc.isConflictJMSConnectionFactoryDefinition()) {
                    throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionconflictjmsconnectionfactorydefinition", "There are more than one jms connection factory definitions defined in web fragments with the same name, but not overrided in web.xml"));
                }
                if (javaEEResourceType.equals((Object)JavaEEResourceType.JMSDD) && wbDesc.isConflictJMSDestinationDefinition()) {
                    throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptionconflictjmsdestinationdefinition", "There are more than one jms destination definitions defined in web fragments with the same name, but not overrided in web.xml"));
                }
            }
            if (!desc.getResourceType().equals((Object)JavaEEResourceType.DSD) && !desc.getResourceType().equals((Object)JavaEEResourceType.MSD) && !desc.getResourceType().equals((Object)JavaEEResourceType.CFD) && !desc.getResourceType().equals((Object)JavaEEResourceType.AODD) && !desc.getResourceType().equals((Object)JavaEEResourceType.JMSCFDD) && !desc.getResourceType().equals((Object)JavaEEResourceType.JMSDD)) continue;
            this.getResourceDescriptors(javaEEResourceType).add(desc);
        }
    }

    private static final class ServletFilterMappingInfo {
        private ServletFilterMapping servletFilterMapping;
        private boolean hasMapping = false;
        private boolean hasDispatcher = false;

        private ServletFilterMappingInfo() {
        }
    }
}

