/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.bootstrap;

import jakarta.ws.rs.core.FeatureContext;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.krazo.binding.convert.MvcConverterProvider;
import org.eclipse.krazo.bootstrap.ConfigProvider;
import org.eclipse.krazo.core.ViewResponseFilter;
import org.eclipse.krazo.core.ViewableWriter;
import org.eclipse.krazo.forms.HiddenMethodFilter;
import org.eclipse.krazo.jaxrs.PostMatchingRequestFilter;
import org.eclipse.krazo.jaxrs.PreMatchingRequestFilter;
import org.eclipse.krazo.security.CsrfExceptionMapper;
import org.eclipse.krazo.security.CsrfProtectFilter;
import org.eclipse.krazo.security.CsrfValidateFilter;
import org.eclipse.krazo.util.CdiUtils;

public class DefaultConfigProvider
implements ConfigProvider {
    public static final Set<Class<?>> PROVIDERS = new HashSet<Class>(Arrays.asList(ViewResponseFilter.class, ViewableWriter.class, CsrfValidateFilter.class, CsrfProtectFilter.class, CsrfExceptionMapper.class, PreMatchingRequestFilter.class, PostMatchingRequestFilter.class, MvcConverterProvider.class, HiddenMethodFilter.class));

    @Override
    public void configure(FeatureContext context) {
        PROVIDERS.forEach(provider -> this.register(context, (Class<?>)provider));
    }

    private void register(FeatureContext context, Class<?> providerClass) {
        boolean isCxf = context.getClass().getName().startsWith("org.apache.cxf");
        if (isCxf) {
            List<?> providerInstances = CdiUtils.getApplicationBeans(providerClass, new Annotation[0]);
            if (!providerInstances.isEmpty()) {
                context.register(providerInstances.get(0));
            } else {
                context.register(providerClass);
            }
        } else {
            context.register(providerClass);
        }
    }
}

