/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.loader;

import com.sun.appserv.server.util.PreprocessorUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import org.glassfish.web.loader.LogFacade;

public class ResourceEntry {
    private static final System.Logger LOG = LogFacade.getSysLogger(ResourceEntry.class);
    public long lastModified = -1L;
    public byte[] binaryContent;
    public volatile Class<?> loadedClass;
    public URL source;
    public URL codeBase;
    public Manifest manifest;
    public Certificate[] certificates;

    ResourceEntry(URL url) {
        this(url, url);
    }

    ResourceEntry(URL codeBase, URL source) {
        this.codeBase = codeBase;
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readEntryData(String name, InputStream binaryStream, int contentLength, JarEntry jarEntry) {
        byte[] bytes = new byte[contentLength];
        try {
            int n;
            int pos = 0;
            while ((n = binaryStream.read(bytes, pos, bytes.length - pos)) > 0) {
                pos += n;
            }
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.WARNING, "Unable to read data for class " + name, (Throwable)e);
            return;
        }
        finally {
            try {
                binaryStream.close();
            }
            catch (IOException e) {
                LOG.log(System.Logger.Level.WARNING, "Could not close the stream for " + name, (Throwable)e);
            }
        }
        this.binaryContent = PreprocessorUtil.isPreprocessorEnabled() ? PreprocessorUtil.processClass((String)name, (byte[])bytes) : bytes;
        if (jarEntry != null) {
            this.certificates = jarEntry.getCertificates();
        }
    }

    public String toString() {
        return this.loadedClass == null ? this.source.toExternalForm() : this.loadedClass.toString();
    }
}

