/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.interactions;

import jakarta.resource.ResourceException;
import jakarta.resource.cci.IndexedRecord;
import jakarta.resource.cci.InteractionSpec;
import jakarta.resource.cci.MappedRecord;
import jakarta.resource.cci.Record;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.EISMappedRecord;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;

public abstract class EISInteraction
extends DatasourceCall {
    protected InteractionSpec interactionSpec;
    protected String functionName = "";
    protected String inputRecordName = "";
    protected Map<String, Object> properties;
    protected AbstractRecord inputRow;
    protected Vector arguments;
    protected Vector<String> outputArgumentNames;
    protected Vector<DatabaseField> outputArguments;
    protected String outputResultPath = "";

    protected EISInteraction() {
    }

    public void addOutputArgument(String parameterAndArgumentFieldName) {
        this.addOutputArgument(parameterAndArgumentFieldName, parameterAndArgumentFieldName);
    }

    public void addOutputArgument(String parameterName, String argumentFieldName) {
        this.getOutputArgumentNames().add(parameterName);
        this.getOutputArguments().add(new DatabaseField(argumentFieldName));
    }

    public Vector getArguments() {
        if (this.arguments == null) {
            this.arguments = new Vector();
        }
        return this.arguments;
    }

    public void setArguments(Vector arguments) {
        this.arguments = arguments;
    }

    public boolean hasArguments() {
        return this.arguments != null && !this.arguments.isEmpty();
    }

    @Override
    public boolean isEISInteraction() {
        return true;
    }

    public String getOutputResultPath() {
        return this.outputResultPath;
    }

    public void setOutputResultPath(String outputResultPath) {
        this.outputResultPath = outputResultPath;
    }

    public Vector<String> getOutputArgumentNames() {
        if (this.outputArgumentNames == null) {
            this.outputArgumentNames = new Vector();
        }
        return this.outputArgumentNames;
    }

    public Vector<DatabaseField> getOutputArguments() {
        if (this.outputArguments == null) {
            this.outputArguments = new Vector();
        }
        return this.outputArguments;
    }

    public void setOutputArguments(Vector<DatabaseField> outputArguments) {
        this.outputArguments = outputArguments;
    }

    public void setOutputArgumentNames(Vector<String> outputArgumentNames) {
        this.outputArgumentNames = outputArgumentNames;
    }

    public boolean hasOutputArguments() {
        return this.outputArguments != null && !this.outputArguments.isEmpty();
    }

    @Override
    public void prepare(AbstractSession session) {
        if (this.getInputRecordName().isEmpty()) {
            ClassDescriptor classDescriptor;
            DatabaseQuery q = this.getQuery();
            ClassDescriptor classDescriptor2 = classDescriptor = q != null ? q.getDescriptor() : null;
            if (classDescriptor != null && classDescriptor.isEISDescriptor()) {
                EISDescriptor descriptor = (EISDescriptor)classDescriptor;
                this.setInputRecordName(descriptor.getDataTypeName());
            } else {
                this.setInputRecordName("input");
            }
        }
        super.prepare(session);
    }

    public Object createRecordElement(String elementName, Object value, EISAccessor accessor) {
        try {
            MappedRecord element = value;
            if (element instanceof List) {
                List values = (List)element;
                MappedRecord elements = new Vector(values.size());
                for (int index = 0; index < values.size(); ++index) {
                    elements.add(this.createRecordElement(elementName, values.get(index), accessor));
                }
                element = elements;
            } else if (value instanceof AbstractRecord) {
                AbstractRecord valuesRow = (AbstractRecord)value;
                String recordName = elementName;
                if (!valuesRow.isEmpty()) {
                    recordName = valuesRow.getFields().get(0).getTableName();
                }
                MappedRecord record = accessor.getRecordFactory().createMappedRecord(recordName);
                for (DatabaseField field : valuesRow.getFields()) {
                    Object elementValue = this.createRecordElement(field.getName(), valuesRow.get(field), accessor);
                    accessor.getEISPlatform().setValueInRecord(field.getName(), elementValue, record, accessor);
                }
                element = record;
            }
            return element;
        }
        catch (ResourceException exception) {
            throw EISException.resourceException(exception, accessor, null);
        }
    }

    public InteractionSpec getInteractionSpec() {
        return this.interactionSpec;
    }

    public void setInteractionSpec(InteractionSpec interactionSpec) {
        this.interactionSpec = interactionSpec;
    }

    @Override
    public String getLogString(Accessor accessor) {
        StringWriter writer = new StringWriter();
        writer.write("Executing ");
        writer.write(this.toString());
        writer.write(System.lineSeparator());
        writer.write("\tspec => ");
        writer.write(String.valueOf(this.getInteractionSpec()));
        writer.write(System.lineSeparator());
        writer.write("\tproperties => ");
        writer.write(String.valueOf(this.getProperties()));
        writer.write(System.lineSeparator());
        writer.write("\tinput => [");
        if (!this.getParameters().isEmpty()) {
            Iterator<Object> iterator = this.getParameters().iterator();
            while (iterator.hasNext()) {
                Object parameter = iterator.next();
                writer.write(String.valueOf(parameter));
                if (iterator.hasNext()) {
                    writer.write(", ");
                    continue;
                }
                writer.write("]");
            }
        } else {
            writer.write(String.valueOf(this.getInputRow()));
            writer.write("]");
        }
        return writer.toString();
    }

    @Override
    public void translate(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
        if (modifyRow != null) {
            this.setInputRow(modifyRow);
        }
        if (this.hasArguments()) {
            ArrayList<Object> parametersValues = new ArrayList<Object>(this.getArguments().size());
            for (int index = 0; index < this.getArguments().size(); ++index) {
                Object argument = this.getArguments().get(index);
                if (argument instanceof DatabaseField) {
                    DatabaseField field = (DatabaseField)argument;
                    Object value = translationRow.get(field);
                    if (value == null && modifyRow != null) {
                        value = modifyRow.get(field);
                    }
                    parametersValues.add(value);
                    continue;
                }
                parametersValues.add(argument);
            }
            this.setParameters(parametersValues);
        }
    }

    public abstract Record createInputRecord(EISAccessor var1);

    public abstract AbstractRecord buildRow(Record var1, EISAccessor var2);

    public Vector<AbstractRecord> buildRows(Record record, EISAccessor accessor) {
        Vector<AbstractRecord> rows = null;
        if (record instanceof IndexedRecord) {
            IndexedRecord indexedRecord = (IndexedRecord)record;
            rows = new Vector(indexedRecord.size());
            for (int index = 0; index < indexedRecord.size(); ++index) {
                Object element = indexedRecord.get(index);
                if (!(element instanceof Record)) {
                    rows.add(this.buildRow(record, accessor));
                    return rows;
                }
                rows.add(this.buildRow((Record)element, accessor));
            }
        } else if (record instanceof MappedRecord) {
            MappedRecord mappedRecord = (MappedRecord)record;
            if (!this.getOutputResultPath().isEmpty()) {
                Object element = mappedRecord.get((Object)this.getOutputResultPath());
                if (element instanceof IndexedRecord) {
                    return this.buildRows((Record)((IndexedRecord)element), accessor);
                }
                if (element instanceof MappedRecord) {
                    mappedRecord = (MappedRecord)element;
                } else if (element instanceof List) {
                    List elements = (List)element;
                    rows = new Vector(elements.size());
                    for (int index = 0; index < elements.size(); ++index) {
                        Object elementValue = elements.get(index);
                        if (elementValue instanceof Record) {
                            rows.add(this.buildRow((Record)elementValue, accessor));
                            continue;
                        }
                        rows.add((AbstractRecord)elementValue);
                    }
                    return rows;
                }
            }
            rows = new Vector(1);
            EISMappedRecord row = new EISMappedRecord((Map)mappedRecord, accessor);
            rows.add(row);
        } else {
            rows = new Vector<AbstractRecord>(1);
        }
        return rows;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getInputRecordName() {
        return this.inputRecordName;
    }

    public void setInputRecordName(String recordName) {
        this.inputRecordName = recordName;
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>(5);
        }
        return this.properties;
    }

    public Object getProperty(String name) {
        Object value = this.getProperties().get(name);
        if (value == null && this.getQuery() != null && this.getQuery().getDescriptor() != null) {
            value = this.getQuery().getDescriptor().getProperty(name);
        }
        return value;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setProperty(String name, Object value) {
        this.getProperties().put(name, value);
    }

    public AbstractRecord getInputRow() {
        return this.inputRow;
    }

    public void setInputRow(AbstractRecord inputRow) {
        this.inputRow = inputRow;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getFunctionName() + ")";
    }
}

