/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.asm.Label;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.tree.ConditionVars;
import org.glassfish.rmic.tools.tree.ConstantExpression;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.Vset;

public class BooleanExpression
extends ConstantExpression {
    boolean value;

    public BooleanExpression(long where, boolean value) {
        super(61, where, Type.tBoolean);
        this.value = value;
    }

    @Override
    public Object getValue() {
        return this.value ? 1 : 0;
    }

    @Override
    public boolean equals(boolean b) {
        return this.value == b;
    }

    @Override
    public boolean equalsDefault() {
        return !this.value;
    }

    @Override
    public void checkCondition(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp, ConditionVars cvars) {
        if (this.value) {
            cvars.vsFalse = Vset.DEAD_END;
            cvars.vsTrue = vset;
        } else {
            cvars.vsFalse = vset;
            cvars.vsTrue = Vset.DEAD_END;
        }
    }

    @Override
    void codeBranch(Environment env, Context ctx, Assembler asm, Label lbl, boolean whenTrue) {
        if (this.value == whenTrue) {
            asm.add(this.where, 167, lbl);
        }
    }

    @Override
    public void codeValue(Environment env, Context ctx, Assembler asm) {
        asm.add(this.where, 18, this.value ? 1 : 0);
    }

    @Override
    public void print(PrintStream out) {
        out.print(this.value ? "true" : "false");
    }
}

