/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.common_impl;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.RepositoryChangeListener;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import com.sun.enterprise.module.common_impl.AbstractRepositoryImpl;
import com.sun.enterprise.module.common_impl.ModuleId;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;

public class DirectoryBasedRepository
extends AbstractRepositoryImpl {
    protected final File repository;
    private final ReentrantLock lock = new ReentrantLock();
    private final int intervalInMs = Integer.getInteger("hk2.file.directory.changeIntervalTimer", 1000);
    private Timer timer;
    private boolean isTimerThreadDaemon = false;
    private List<File> subDirectories;

    public DirectoryBasedRepository(String name, File repository) {
        super(name, repository.toURI());
        this.repository = repository;
    }

    private void initializeSubDirectories() {
        if (this.subDirectories != null) {
            return;
        }
        this.subDirectories = new LinkedList<File>();
        for (File file : this.repository.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            this.subDirectories.add(file);
        }
    }

    public DirectoryBasedRepository(String name, File repository, boolean isTimerThreadDaemon) {
        this(name, repository);
        this.isTimerThreadDaemon = isTimerThreadDaemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addListener(RepositoryChangeListener listener) {
        this.lock.lock();
        try {
            boolean returnValue = super.addListener(listener);
            if (returnValue && this.timer == null) {
                this.initializeSubDirectories();
                this.timer = new Timer("hk2-repo-listener-" + this.getName(), this.isTimerThreadDaemon);
                this.timer.schedule(new TimerTask(){
                    private final ReentrantLock lock = new ReentrantLock();
                    long lastModified;
                    {
                        this.lastModified = DirectoryBasedRepository.this.repository.lastModified();
                    }

                    @Override
                    public void run() {
                        this.lock.lock();
                        try {
                            if (this.lastModified < DirectoryBasedRepository.this.repository.lastModified()) {
                                this.lastModified = DirectoryBasedRepository.this.repository.lastModified();
                                DirectoryBasedRepository.this.directoryChanged();
                            }
                        }
                        finally {
                            this.lock.unlock();
                        }
                    }
                }, this.intervalInMs, (long)this.intervalInMs);
                this.timer.purge();
            }
            boolean bl = returnValue;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void shutdown() throws IOException {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    @Override
    protected void loadModuleDefs(Map<ModuleId, ModuleDefinition> moduleDefs, List<URI> libraries) throws IOException {
        if (!this.repository.exists()) {
            throw new FileNotFoundException(this.repository.getAbsolutePath());
        }
        try {
            File[] files;
            for (File aFile : files = this.repository.listFiles()) {
                if (!aFile.getName().endsWith(".jar") || this.isDisabled(aFile)) continue;
                ModuleDefinition moduleDef = this.loadJar(aFile);
                if (moduleDef != null) {
                    moduleDefs.put(AbstractFactory.getInstance().createModuleId(moduleDef), moduleDef);
                    continue;
                }
                libraries.add(aFile.toURI());
            }
        }
        catch (IOException e) {
            IOException x = new IOException("Failed to load modules from " + this.repository);
            x.initCause(e);
            throw x;
        }
    }

    protected boolean isDisabled(File jar) {
        Object fileName = jar.getName();
        fileName = ((String)fileName).substring(0, ((String)fileName).lastIndexOf(46)) + ".disabled";
        File disabledFile = new File(jar.getParent(), (String)fileName);
        return disabledFile.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void directoryChanged() {
        this.lock.lock();
        try {
            HashMap<ModuleId, ModuleDefinition> newModuleDefs = new HashMap<ModuleId, ModuleDefinition>();
            LinkedList<URI> libraries = new LinkedList<URI>();
            try {
                this.loadModuleDefs(newModuleDefs, libraries);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (ModuleDefinition moduleDefinition : newModuleDefs.values()) {
                if (this.find(moduleDefinition.getName(), moduleDefinition.getVersion()) != null) continue;
                this.add(moduleDefinition);
                for (Object listener : this.listeners) {
                    listener.moduleAdded(moduleDefinition);
                }
            }
            for (ModuleDefinition moduleDefinition : this.findAll()) {
                if (newModuleDefs.containsKey(AbstractFactory.getInstance().createModuleId(moduleDefinition))) continue;
                this.remove(moduleDefinition);
                for (Object listener : this.listeners) {
                    listener.moduleRemoved(moduleDefinition);
                }
            }
            List<URI> originalLibraries = super.getJarLocations();
            for (URI location : libraries) {
                if (originalLibraries.contains(location)) continue;
                this.addLibrary(location);
                for (RepositoryChangeListener listener : this.listeners) {
                    listener.added(location);
                }
            }
            if (originalLibraries.size() > 0) {
                LinkedList<URI> linkedList = new LinkedList<URI>();
                linkedList.addAll(originalLibraries);
                for (URI originalLocation : linkedList) {
                    if (libraries.contains(originalLocation)) continue;
                    this.removeLibrary(originalLocation);
                    for (RepositoryChangeListener listener : this.listeners) {
                        listener.removed(originalLocation);
                    }
                }
            }
            LinkedList<File> linkedList = new LinkedList<File>();
            linkedList.addAll(this.subDirectories);
            for (File file : this.repository.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            })) {
                if (!this.subDirectories.contains(file)) {
                    for (RepositoryChangeListener listener : this.listeners) {
                        listener.added(file.toURI());
                    }
                    this.subDirectories.add(file);
                    continue;
                }
                linkedList.remove(file);
            }
            if (!linkedList.isEmpty()) {
                for (File file : linkedList) {
                    for (RepositoryChangeListener listener : this.listeners) {
                        listener.removed(file.toURI());
                    }
                    this.subDirectories.remove(file);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

