/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import jakarta.enterprise.lang.model.declarations.ParameterInfo;
import jakarta.enterprise.lang.model.types.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.weld.lite.extension.translator.AnnotationInfoImpl;
import org.jboss.weld.lite.extension.translator.DeclarationInfoImpl;
import org.jboss.weld.lite.extension.translator.MethodInfoImpl;
import org.jboss.weld.lite.extension.translator.TypeImpl;
import org.jboss.weld.lite.extension.translator.util.AnnotationOverrides;

class ParameterInfoImpl
extends DeclarationInfoImpl<Parameter, AnnotatedParameter<?>>
implements ParameterInfo {
    private final MethodInfoImpl method;
    private final int position;
    private final Boolean isEnumConstructorParam;

    ParameterInfoImpl(AnnotatedParameter<?> cdiDeclaration, BeanManager bm) {
        super(cdiDeclaration.getJavaParameter(), cdiDeclaration, bm);
        this.method = new MethodInfoImpl(cdiDeclaration.getDeclaringCallable(), bm);
        this.position = cdiDeclaration.getPosition();
        this.isEnumConstructorParam = null;
    }

    ParameterInfoImpl(Parameter reflectionDeclaration, MethodInfoImpl backReference, int position, boolean isEnumConstructorParam, BeanManager bm) {
        super(reflectionDeclaration, null, bm);
        this.method = backReference;
        this.position = position;
        this.isEnumConstructorParam = isEnumConstructorParam;
    }

    public String name() {
        return ((Parameter)this.reflection).getName();
    }

    public Type type() {
        if (this.canSuperHandleAnnotations()) {
            return TypeImpl.fromReflectionType(((Parameter)this.reflection).getAnnotatedType(), this.bm);
        }
        AnnotationOverrides overrides = new AnnotationOverrides(((Parameter)this.reflection).getDeclaringExecutable().getAnnotatedParameterTypes()[this.position].getAnnotations());
        return TypeImpl.fromReflectionType(((Parameter)this.reflection).getAnnotatedType(), overrides, this.bm);
    }

    public MethodInfo declaringMethod() {
        return this.method;
    }

    private boolean canSuperHandleAnnotations() {
        if (this.cdiDeclaration != null) {
            return true;
        }
        return this.isEnumConstructorParam == null || this.isEnumConstructorParam == false;
    }

    @Override
    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        if (this.canSuperHandleAnnotations()) {
            return super.hasAnnotation(annotationType);
        }
        Annotation[] annotations = this.isEnumConstructorParam != false && ((Executable)this.method.reflection).getParameterAnnotations()[0].length == 0 ? ((Executable)this.method.reflection).getParameterAnnotations()[this.position + 2] : ((Executable)this.method.reflection).getParameterAnnotations()[this.position];
        return Arrays.stream(annotations).anyMatch(it -> annotationType.isAssignableFrom(it.annotationType()));
    }

    @Override
    public boolean hasAnnotation(Predicate<AnnotationInfo> predicate) {
        if (this.canSuperHandleAnnotations()) {
            return super.hasAnnotation(predicate);
        }
        Annotation[] annotations = ((Executable)this.method.reflection).getParameterAnnotations()[this.position];
        return Arrays.stream(annotations).anyMatch(it -> predicate.test(new AnnotationInfoImpl((Annotation)it, this.bm)));
    }

    @Override
    public <T extends Annotation> AnnotationInfo annotation(Class<T> annotationType) {
        if (this.canSuperHandleAnnotations()) {
            return super.annotation(annotationType);
        }
        Annotation[] annotations = ((Executable)this.method.reflection).getParameterAnnotations()[this.position];
        T annotation = new AnnotationOverrides(annotations).getAnnotation(annotationType);
        return annotation != null ? new AnnotationInfoImpl((Annotation)annotation, this.bm) : null;
    }

    @Override
    public <T extends Annotation> Collection<AnnotationInfo> repeatableAnnotation(Class<T> annotationType) {
        if (this.canSuperHandleAnnotations()) {
            return super.repeatableAnnotation(annotationType);
        }
        Annotation[] annotations = this.isEnumConstructorParam != false && ((Executable)this.method.reflection).getParameterAnnotations()[0].length == 0 ? ((Executable)this.method.reflection).getParameterAnnotations()[this.position + 2] : ((Executable)this.method.reflection).getParameterAnnotations()[this.position];
        return Arrays.stream(new AnnotationOverrides(annotations).getAnnotationsByType(annotationType)).map(t -> new AnnotationInfoImpl((Annotation)t, this.bm)).collect(Collectors.toList());
    }

    @Override
    public Collection<AnnotationInfo> annotations(Predicate<AnnotationInfo> predicate) {
        if (this.canSuperHandleAnnotations()) {
            return super.annotations(predicate);
        }
        Annotation[] annotations = this.isEnumConstructorParam != false && ((Executable)this.method.reflection).getParameterAnnotations()[0].length == 0 ? ((Executable)this.method.reflection).getParameterAnnotations()[this.position + 2] : ((Executable)this.method.reflection).getParameterAnnotations()[this.position];
        return Arrays.stream(annotations).map(annotation -> new AnnotationInfoImpl((Annotation)annotation, this.bm)).filter(predicate).collect(Collectors.toList());
    }

    @Override
    public String toString() {
        String name = this.name();
        return "parameter " + String.valueOf(name != null ? name : Integer.valueOf(this.position)) + " of method " + ((AnnotatedParameter)this.cdiDeclaration).getDeclaringCallable().getJavaMember().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterInfoImpl that = (ParameterInfoImpl)o;
        return this.position == that.position && Objects.equals(this.method, that.method);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.position);
    }
}

