/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.beannameelresolver;

import com.sun.ts.tests.el.common.api.resolver.ResolverTest;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.SimpleBean;
import jakarta.el.BeanNameELResolver;
import jakarta.el.BeanNameResolver;
import jakarta.el.ELContext;
import jakarta.el.ELManager;
import jakarta.el.ELResolver;
import jakarta.el.StandardELContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void beanNameELResolverTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        boolean pass = false;
        ELManager elm = new ELManager();
        TCKBeanNameResolver bnr = new TCKBeanNameResolver();
        BeanNameELResolver belr = new BeanNameELResolver((BeanNameResolver)bnr);
        elm.addBeanNameResolver((BeanNameResolver)bnr);
        elm.addELResolver((ELResolver)belr);
        elm.defineBean("simpleBean", (Object)new SimpleBean());
        StandardELContext context = elm.getELContext();
        try {
            pass = ResolverTest.testELResolver((ELContext)context, context.getELResolver(), bnr.getBean("simpleBean"), "intention", "GOLDEN", buf, false);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.INFO, buf.toString());
    }

    @Test
    public void beanNameELResolverInvokeMNFETest() throws Exception {
        StringBuffer buf = new StringBuffer();
        boolean pass = false;
        ELManager elm = new ELManager();
        TCKBeanNameResolver bnr = new TCKBeanNameResolver();
        BeanNameELResolver belr = new BeanNameELResolver((BeanNameResolver)bnr);
        elm.addBeanNameResolver((BeanNameResolver)bnr);
        elm.addELResolver((ELResolver)belr);
        elm.defineBean("simpleBean", (Object)new SimpleBean());
        StandardELContext context = elm.getELContext();
        Class[] types = new Class[]{String.class, String.class};
        Object[] values = new String[]{"Doug", "Donahue"};
        try {
            pass = ResolverTest.testELResolverInvoke((ELContext)context, context.getELResolver(), new SimpleBean(), "bogue_method", types, values, true, buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.INFO, buf.toString());
    }

    @Test
    public void beanNameELResolverInvokeTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        boolean pass = false;
        ELManager elm = new ELManager();
        TCKBeanNameResolver bnr = new TCKBeanNameResolver();
        BeanNameELResolver belr = new BeanNameELResolver((BeanNameResolver)bnr);
        elm.addBeanNameResolver((BeanNameResolver)bnr);
        elm.addELResolver((ELResolver)belr);
        elm.defineBean("simpleBean", (Object)new SimpleBean());
        StandardELContext context = elm.getELContext();
        Class[] types = new Class[]{String.class, String.class};
        Object[] values = new String[]{"Doug", "Donahue"};
        try {
            pass = ResolverTest.testELResolverInvoke((ELContext)context, context.getELResolver(), new SimpleBean(), "isName", types, values, false, buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.INFO, buf.toString());
    }

    @Test
    public void beanNameELResolverGetTypeNPETest() throws Exception {
        TCKBeanNameResolver bnr = new TCKBeanNameResolver();
        BeanNameELResolver belr = new BeanNameELResolver((BeanNameResolver)bnr);
        ELTestUtil.checkForNPE(belr, "getType", new Class[]{ELContext.class, Object.class, Object.class}, new Object[]{null, "Ender", "Wiggins"});
    }

    @Test
    public void beanNameELResolverGetValueNPETest() throws Exception {
        TCKBeanNameResolver bnr = new TCKBeanNameResolver();
        BeanNameELResolver belr = new BeanNameELResolver((BeanNameResolver)bnr);
        ELTestUtil.checkForNPE(belr, "getValue", new Class[]{ELContext.class, Object.class, Object.class}, new Object[]{null, "Ender", "Wiggins"});
    }

    @Test
    public void beanNameELResolverIsReadOnlyNPETest() throws Exception {
        TCKBeanNameResolver bnr = new TCKBeanNameResolver();
        BeanNameELResolver belr = new BeanNameELResolver((BeanNameResolver)bnr);
        ELTestUtil.checkForNPE(belr, "isReadOnly", new Class[]{ELContext.class, Object.class, Object.class}, new Object[]{null, "Ender", "Wiggins"});
    }

    @Test
    public void beanNameELResolverSetValueNPETest() throws Exception {
        TCKBeanNameResolver bnr = new TCKBeanNameResolver();
        BeanNameELResolver belr = new BeanNameELResolver((BeanNameResolver)bnr);
        ELTestUtil.checkForNPE(belr, "setValue", new Class[]{ELContext.class, Object.class, Object.class, Object.class}, new Object[]{null, "Ender", "Valintine", "Wiggins"});
    }

    private static class TCKBeanNameResolver
    extends BeanNameResolver {
        private TCKBeanNameResolver() {
        }
    }
}

